/* syscall.c  94.07.31
 * Copyright 1983-1992   Albert Davis
 * system calls: change directory, invoke another program, invoke editor, etc.
 */
#include "ecah.h"
#include "error.h"
#include "io.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	void	cmd_edit(const char*,int*);
	void	cmd_system(const char*,int*);
	void	cmd_chdir(const char*,int*);
/*--------------------------------------------------------------------------*/
extern const struct ioctrl io;
extern char e_int[];
/*--------------------------------------------------------------------------*/
/* cmd_edit: (command) invoke user defined editor on the netlist
 * if command has an argument, it edits that file instead
 * else actually edits a temporary file, and reads it back.
 */
void cmd_edit(const char *cmd, int *cnt)
{
 char *editor;
 char name[BUFLEN];
 char args[BUFLEN];

 editor = getenv("EDITOR");
 if (!editor)
    error(bERROR, "no editor defined\n");

 if (cmd[*cnt]){
    sprintf(args, "%s %s\n", editor, &cmd[*cnt]);
    system(args);
 }else{
    strcpy(name, EDITFILE);
    (void)mktemp(name);
    sprintf(args, "save %s", name);
    (void)cmdproc(args);
    sprintf(args, "%s %s", editor, name);
    system(args);
    sprintf(args, "get %s quiet", name);
    (void)cmdproc(args);
    (void)unlink(name);
 }
}
/*--------------------------------------------------------------------------*/
/* cmd_system: (! command) call the system to execute a command
 * no arg spawns a shell.
 */
void cmd_system(const char *cmd, int *cnt)
{
 if (cmd[*cnt])
    system(&cmd[*cnt]);
 else
    shell();
}
/*--------------------------------------------------------------------------*/
/* cmd_chdir: (cd, chdir command)
 * change working directory, print name of where it ends up
 * no arg just prints, does not change to a default.
 */
void cmd_chdir(const char *cmd, int *cnt)
{
 char buf[BUFLEN];

 if (cmd[*cnt])
    (void)chdir(ctostr(cmd, cnt, buf, BUFLEN-1, ""));
 if (getcwd(buf,BUFLEN))
    mprintf(io.mstderr, "%s\n", buf);
 else
    error(bERROR, e_int, "getcwd");
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
