/* xopen.c  94.07.13
 * Copyright 1983-1992   Albert Davis
 * scan a string for a file name
 * fill in extension, if necessary
 * open file
 */
#include "ecah.h"
#include "error.h"
#include <time.h>
#include "declare.h"
/*--------------------------------------------------------------------------*/
	void	xclose(FILE**);
	FILE*	xopen(const char*,int*,const char*,const char*);
/*--------------------------------------------------------------------------*/
extern FILE *stream[];
/*--------------------------------------------------------------------------*/
void xclose(FILE **fn)
{
 if (*fn){
    (void)fclose(*fn);
    *fn = (FILE*)NULL;
 }
}
/*--------------------------------------------------------------------------*/
/* xopen: open a file from a command string
 * 	scan and eat up the name from the command
 *	add default extension if appropriate
 *	if there is no name, prompt for one
 *	trap errors of not found and clobber
 */
FILE *xopen(const char *cmd, int *cnt, const char *ext, const char *how)
{
 int i;		/* an index */
 int defalt;	/* flag: we need to add the default extension */
 FILE *code;	/* a file pointer for the file we found */
 char fname[BUFLEN+5];

 skipbl(cmd,cnt);
 if (!cmd[*cnt]){
    int loccount;
    cmd = getcmd ("file name?  ",fname,BUFLEN);
    loccount = 0;
    cnt = &loccount;
 }
					/* copy the name		    */
					/* and while we're at it ...	    */
 skipbl(cmd,cnt);			/* find out if we want to add the   */
 defalt = YES;				/* default extension		    */
 for (i = 0;   i < BUFLEN;   ){
    char c;
    c = cmd[(*cnt)++];
    if (!c || isspace(c))
       break;
    if (c == '$'){
       sprintf(&(fname[i]), "%ld", (long)time((time_t*)NULL));
       i = strlen(fname);
    }else{				/* we want to add the extension	    */
       fname[i++] = c;			/* if it doesn't already have one,  */
       if (c == '.')			/* as determined by a '.'	    */
          defalt = NO;			/* not before the directory	    */
       else if (strchr(ENDDIR,c))	/* separator-terminator character   */
          defalt = YES;			/* '\' or '/' for msdos,	    */
    }  					/* ']' or '/' for vms,		    */
 }					/* '/' for unix  (in ENDDIR)	    */
 (*cnt)--;
 if (defalt && ext && *ext){		/* add the extension (maybe)	    */
    fname[i++] = '.';
    strcpy(&fname[i],ext);
 }else{
    fname[i] = '\0';
 }
 
 (void)trim(fname);
 skipcom(cmd,cnt);

 if ((*how == 'w')   &&   (access(fname,F_OK) == GOOD)){
    char buffer[BUFLEN];		
    error(bWARNING, "%s exists.  replace? ", fname);
    (void)getcmd ("", buffer, BUFLEN);
    if (match(buffer,"Yes"))		/* should be new file, but	    */
	code = fopen(fname,how);	/* file already exists,  ask	    */
    else
	return (FILE*)NULL;
 }else{
    code = fopen(fname,how);
 }

 if (code && fileno(code)>MAXHANDLE){
    error(bWARNING, "internal error: files: %d\n", fileno(code));
    (void)fclose(code);
    code = (FILE*)NULL;
 }
 if (code)
    stream[(int)fileno(code)] = code;
 else
    error(bWARNING, "can't open %s\n", fname);
 return code;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
