/*
 * fopenexcl(name) - fopen(name, "w") with error if name exists
 */

#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#ifndef O_RDONLY		/* using our fake fcntl.h; maybe it's 4.2? */
#include <sys/file.h>
#endif

#ifdef O_RDONLY			/* good, we have a 3-arg open() */
#define	OPENW(f)	open(f, O_WRONLY|O_CREAT|O_EXCL, 0666)
#else				/* don't -- must fake it */
#include <sys/stat.h>
static struct testbuf;
#define	OPENW(f)	((stat(f, &testbuf) < 0) ? creat(f, 0666) : -1)
#endif

FILE *
fopenexcl(name)
register char *name;
{
	register int fd;

	fd = OPENW(name);
	if (fd < 0)
		return NULL;		/* name existed or couldn't be made */
	else
		return fdopen(fd, "w");
}
