/********************************************************************
 * lindner
 * 3.5
 * 1995/02/13 19:10:34
 * /home/arcwelder/GopherSrc/CVS/gopher+/gopherd/AUTH.h,v
 *
 * Paul Lindner, University of Minnesota DCS.
 *
 * Copyright 1991, 92, 93, 94 by the Regents of the University of Minnesota
 * see the file "Copyright" in the distribution for conditions of use.
 *********************************************************************
 * MODULE: AUTH.c
 * Routines to verify authentication
 *********************************************************************
 * Revision History:
 * AUTH.h,v
 * Revision 3.5  1995/02/13  19:10:34  lindner
 * next compile
 *
 * Revision 3.4  1995/02/06  21:24:58  lindner
 * Add stuff for unix pw file
 *
 * Revision 3.3  1994/12/12  16:58:13  lindner
 * Add new AUTHresult code, AUTHRES_SYSERR
 *
 * Revision 3.2  1994/07/22  22:27:44  lindner
 * NO_AUTHENTICATION mods
 *
 * Revision 3.1  1994/06/29  05:34:20  lindner
 * New authentication routines
 *
 *
 *********************************************************************/

/*
 * Platform independent authentication routines go here...
 *
 * AUTH object     --> contains auth type name and script/fcn to call
 * AUTHA object    --> dynamic array of AUTH objects.
 *
 * AUTHITEM object --> contains directory, authtype, link to dns sites
 */

#include "boolean.h"
#include "STAarray.h"

typedef enum {AUTH_UNINITED, AUTH_INTERNAL, AUTH_SCRIPT} AUTHtype;
typedef enum {AUTHRES_OK, AUTHRES_BADPW, AUTHRES_EXPIRED,
	      AUTHRES_NOUSER, AUTHRES_SYSERR} AUTHresult;

struct AUTHstruct {
     AUTHtype      type;
     String        *name;

     AUTHresult    (*authfcn)();        /* The authentication test */
     char        **(*authfcnask)();     /* The authentication askblock fcn */
     String        *scriptname;
};
     
typedef struct AUTHstruct AUTH;

/*
 * Member functions
 */

#define AUTHgetType(a)         (a->type)
#define AUTHgetName(a)         (STRget(a->name))
#define AUTHgetScriptName(a)   (STRget(a->scriptname))
#define AUTHgetFcn(a)          (a->authfcn)
#define AUTHgetAskFcn(a)       (a->authfcnask)

#define AUTHsetType(a,b)       (a->type=(b))
#define AUTHsetName(a,b)       (STRset(a->name,(b)))
#define AUTHsetScriptName(a,b) (STRset(a->scriptname,b))
#define AUTHsetFcn(a,b)        (a->authfcn=(b))
#define AUTHsetAskFcn(a,b)     (a->authfcnask=(b))

/*
 * Prototypes
 */
AUTH *AUTHnew();
void  AUTHdestroy();
void  AUTHinit();
AUTH *AUTHcpy();

AUTHresult AUTHunix();
AUTHresult AUTHident();

char **AUTHgenericAsk();

/******************************************************************
 * Array of auth stuff...
 */

#include "DAarray.h"

typedef DynArray AUTHarray;

#define AUTHAgetEntry(a,b)  (AUTH*)(DAgetEntry((DynArray*)a,b))
#define AUTHAdestroy(a)     (DAdestroy(a))
#define AUTHApush(a,b)      (DApush((a),(b)))
#define AUTHAgetTop(a)      (DAgetTop(a))

AUTHarray   *AUTHAnew();
AUTHresult   AUTHAvalidate();
AUTH*        AUTHAlocate();

/******************************************************************
 *  List of items and authentication types.
 *
 */ 

struct AUTHITEMS_struct {
     StrArray *regexps;
     StrArray *authtypes;
};

typedef struct AUTHITEMS_struct AUTHITEMS;

#define AUTHITEMSgetRegexp(a,i)   (STRget(STAgetEntry((a)->regexps,i)))
#define AUTHITEMSgetAuthtype(a,i) (STRget(STAgetEntry((a)->authtypes,i)))

#ifndef NO_AUTHENTICATION
   AUTHITEMS *AUTHITEMSnew();
   void       AUTHITEMSdestroy();
   void       AUTHITEMSpush();
   AUTH      *AUTHITEMSfindAUTH();
   char      *AUTHITEMSfindType();
#else
#  define AUTHAvalidate(a,b,c,d,e,f) (AUTHRES_OK)
#  define AUTHITEMSdestroy(a) 
#  define AUTHAnew(a) (NULL)
#  define AUTHAprocessLine(a,b) (1)
#  define AUTHITEMSfindType(a,b) (NULL)
#  define AUTHITEMSprocessLine(a,b) (1)
#  define AUTHITEMSnew(a) (NULL)
#  define AUTHITEMSfindAUTH(a,b,c) (NULL)
#endif

