enum li_opcode
{
  li_nop = 0,
  li_aconst_null = 1,
  li_iconst_m1 = 2,
  li_iconst_0 = 3,
  li_iconst_1 = 4,
  li_iconst_2 = 5,
  li_iconst_3 = 6,
  li_iconst_4 = 7,
  li_iconst_5 = 8,
  li_lconst_0 = 9,
  li_lconst_1 = 10,
  li_fconst_0 = 11,
  li_fconst_1 = 12,
  li_fconst_2 = 13,
  li_dconst_0 = 14,
  li_dconst_1 = 15,
  li_bipush = 16,
  li_sipush = 17,
  li_ldc1 = 18,
  li_ldc2 = 19,
  li_ldc2w = 20,
  li_iload = 21,
  li_lload = 22,
  li_fload = 23,
  li_dload = 24,
  li_aload = 25,
  li_iload_0 = 26,
  li_iload_1 = 27,
  li_iload_2 = 28,
  li_iload_3 = 29,
  li_lload_0 = 30,
  li_lload_1 = 31,
  li_lload_2 = 32,
  li_lload_3 = 33,
  li_fload_0 = 34,
  li_fload_1 = 35,
  li_fload_2 = 36,
  li_fload_3 = 37,
  li_dload_0 = 38,
  li_dload_1 = 39,
  li_dload_2 = 40,
  li_dload_3 = 41,
  li_aload_0 = 42,
  li_aload_1 = 43,
  li_aload_2 = 44,
  li_aload_3 = 45,
  li_iaload = 46,
  li_laload = 47,
  li_faload = 48,
  li_daload = 49,
  li_aaload = 50,
  li_baload = 51,
  li_caload = 52,
  li_saload = 53,
  li_istore = 54,
  li_lstore = 55,
  li_fstore = 56,
  li_dstore = 57,
  li_astore = 58,
  li_istore_0 = 59,
  li_istore_1 = 60,
  li_istore_2 = 61,
  li_istore_3 = 62,
  li_lstore_0 = 63,
  li_lstore_1 = 64,
  li_lstore_2 = 65,
  li_lstore_3 = 66,
  li_fstore_0 = 67,
  li_fstore_1 = 68,
  li_fstore_2 = 69,
  li_fstore_3 = 70,
  li_dstore_0 = 71,
  li_dstore_1 = 72,
  li_dstore_2 = 73,
  li_dstore_3 = 74,
  li_astore_0 = 75,
  li_astore_1 = 76,
  li_astore_2 = 77,
  li_astore_3 = 78,
  li_iastore = 79,
  li_lastore = 80,
  li_fastore = 81,
  li_dastore = 82,
  li_aastore = 83,
  li_bastore = 84,
  li_castore = 85,
  li_sastore = 86,
  li_pop = 87,
  li_pop2 = 88,
  li_dup = 89,
  li_dup_x1 = 90,
  li_dup_x2 = 91,
  li_dup2 = 92,
  li_dup2_x1 = 93,
  li_dup2_x2 = 94,
  li_swap = 95,
  li_iadd = 96,
  li_ladd = 97,
  li_fadd = 98,
  li_dadd = 99,
  li_isub = 100,
  li_lsub = 101,
  li_fsub = 102,
  li_dsub = 103,
  li_imul = 104,
  li_lmul = 105,
  li_fmul = 106,
  li_dmul = 107,
  li_idiv = 108,
  li_ldiv = 109,
  li_fdiv = 110,
  li_ddiv = 111,
  li_imod = 112,
  li_lmod = 113,
  li_fmod = 114,
  li_dmod = 115,
  li_ineg = 116,
  li_lneg = 117,
  li_fneg = 118,
  li_dneg = 119,
  li_ishl = 120,
  li_lshl = 121,
  li_ishr = 122,
  li_lshr = 123,
  li_iushr = 124,
  li_lushr = 125,
  li_iand = 126,
  li_land = 127,
  li_ior = 128,
  li_lor = 129,
  li_ixor = 130,
  li_lxor = 131,
  li_iinc = 132,
  li_i2f = 133,
  li_i2d = 134,
  li_i2l = 135,
  li_l2i = 136,
  li_l2f = 137,
  li_l2d = 138,
  li_f2i = 139,
  li_f2l = 140,
  li_f2d = 141,
  li_d2i = 142,
  li_d2l = 143,
  li_d2f = 144,
  li_int2byte = 145,
  li_int2char = 146,
  li_int2short = 147,
  li_lcmp = 148,
  li_fcmpl = 149,
  li_fcmpg = 150,
  li_dcmpl = 151,
  li_dcmpg = 152,
  li_ifeq = 153,
  li_ifne = 154,
  li_iflt = 155,
  li_ifge = 156,
  li_ifgt = 157,
  li_ifle = 158,
  li_if_icmpeq = 159,
  li_if_icmpne = 160,
  li_if_icmplt = 161,
  li_if_icmpge = 162,
  li_if_icmpgt = 163,
  li_if_icmple = 164,
  li_if_acmpeq = 165,
  li_if_acmpne = 166,
  li_goto = 167,
  li_jsr = 168,
  li_ret = 169,
  li_tableswitch = 170,
  li_lookupswitch = 171,
  li_ireturn = 172,
  li_lreturn = 173,
  li_freturn = 174,
  li_dreturn = 175,
  li_areturn = 176,
  li_return = 177,
  li_getstatic = 178,
  li_putstatic = 179,
  li_getfield = 180,
  li_putfield = 181,
  li_invokevirtual = 182,
  li_invokenonvirtual = 183,
  li_invokestatic = 184,
  li_invokeinterface = 185,
  li_newfromname = 186,
  li_new = 187,
  li_newarray = 188,
  li_anewarray = 189,
  li_arraylength = 190,
  li_athrow = 191,
  li_checkcast = 192,
  li_instanceof = 193,
  li_monitorenter = 194,
  li_monitorexit = 195,
  li_verifystack = 196,
  li_breakpoint = 197,
  li_multianewarray = 198,
  li_ibitnot = 199,
  li_icnot = 200,
  li_icand = 201,
  li_icor = 202,
  li_halt = 205,
};


enum li_operand_format
{
  array_typecode = 'a',
  branch_offset = 'b',
  byte_constant_index = 'c',
  constant_index = 'e',
  constant_index_w = 'f',
  constant_field_index = 'd',
  constant_method_index = 'g',
  constant_type_index = 'h',
  jump_table = 'i',
  local_index = 'j',
  lookup_table = 'k',
  signed_byte = 'l',
  signed_short = 'm',
  unsigned_byte = 'n',
};


enum ili_opcode
{
  ili_nop = 0,
  ili_push_0 = 1,
  ili_iconst_m1 = 2,
  ili_iconst_0 = 3,
  ili_iconst_1 = 4,
  ili_iconst_2 = 5,
  ili_iconst_3 = 6,
  ili_iconst_4 = 7,
  ili_iconst_5 = 8,
  ili_lconst_0 = 9,
  ili_lconst_1 = 10,
  ili_fconst_0 = 11,
  ili_fconst_1 = 12,
  ili_fconst_2 = 13,
  ili_dconst_0 = 14,
  ili_dconst_1 = 15,
  ili_push_literal = 16,
  ili_push_literal2 = 17,
  ili_push_constant = 18,
  ili_push_constant2 = 19,
  ili_iload = 20,
  ili_lload = 21,
  ili_iload_0 = 22,
  ili_iload_1 = 23,
  ili_iload_2 = 24,
  ili_iload_3 = 25,
  ili_lload_0 = 26,
  ili_lload_1 = 27,
  ili_lload_2 = 28,
  ili_lload_3 = 29,
  ili_istore = 30,
  ili_lstore = 31,
  ili_istore_0 = 32,
  ili_istore_1 = 33,
  ili_istore_2 = 34,
  ili_istore_3 = 35,
  ili_lstore_0 = 36,
  ili_lstore_1 = 37,
  ili_lstore_2 = 38,
  ili_lstore_3 = 39,
  ili_iinc = 40,
  ili_pop = 41,
  ili_pop2 = 42,
  ili_dup = 43,
  ili_dup2 = 44,
  ili_dup_x1 = 45,
  ili_dup_x2 = 46,
  ili_dup2_x1 = 47,
  ili_dup2_x2 = 48,
  ili_swap = 49,
  ili_lshr = 50,
  ili_lshl = 51,
  ili_lushr = 52,
  ili_land = 53,
  ili_lxor = 54,
  ili_lor = 55,
  ili_ishr = 56,
  ili_ishl = 57,
  ili_iushr = 58,
  ili_iand = 59,
  ili_ixor = 60,
  ili_ior = 61,
  ili_ldiv = 62,
  ili_lmul = 63,
  ili_ladd = 64,
  ili_lsub = 65,
  ili_lmod = 66,
  ili_idiv = 67,
  ili_imul = 68,
  ili_iadd = 69,
  ili_isub = 70,
  ili_imod = 71,
  ili_fdiv = 72,
  ili_fmul = 73,
  ili_fadd = 74,
  ili_fsub = 75,
  ili_fmod = 76,
  ili_ddiv = 77,
  ili_dmul = 78,
  ili_dadd = 79,
  ili_dsub = 80,
  ili_dmod = 81,
  ili_ineg = 82,
  ili_lneg = 83,
  ili_dneg = 84,
  ili_fneg = 85,
  ili_i2f = 86,
  ili_i2l = 87,
  ili_i2d = 88,
  ili_f2i = 89,
  ili_f2l = 90,
  ili_f2d = 91,
  ili_l2i = 92,
  ili_l2f = 93,
  ili_l2d = 94,
  ili_d2i = 95,
  ili_d2f = 96,
  ili_d2l = 97,
  ili_int2byte = 98,
  ili_int2char = 99,
  ili_int2short = 100,
  ili_goto = 101,
  ili_jsr = 102,
  ili_ret = 103,
  ili_tableswitch = 104,
  ili_lookupswitch = 105,
  ili_icmp = 106,
  ili_lcmp = 107,
  ili_fcmpl = 108,
  ili_dcmpl = 109,
  ili_fcmpg = 110,
  ili_dcmpg = 111,
  ili_ifeq = 112,
  ili_ifne = 113,
  ili_iflt = 114,
  ili_ifgt = 115,
  ili_ifge = 116,
  ili_ifle = 117,
  ili_if_icmpeq = 118,
  ili_if_icmpne = 119,
  ili_if_icmplt = 120,
  ili_if_icmpgt = 121,
  ili_if_icmple = 122,
  ili_if_icmpge = 123,
  ili_newfromname = 124,
  ili_new = 125,
  ili_ds_new = 126,
  ili_getfield = 127,
  ili_ds_getfield = 128,
  ili_ds_lgetfield = 129,
  ili_putfield = 130,
  ili_ds_putfield = 131,
  ili_ds_lputfield = 132,
  ili_getstatic = 133,
  ili_ds_getstatic = 134,
  ili_ds_lgetstatic = 135,
  ili_putstatic = 136,
  ili_ds_putstatic = 137,
  ili_ds_lputstatic = 138,
  ili_newarray = 139,
  ili_anewarray = 140,
  ili_arraylength = 141,
  ili_multianewarray = 142,
  ili_iaload = 143,
  ili_laload = 144,
  ili_faload = 145,
  ili_daload = 146,
  ili_aaload = 147,
  ili_baload = 148,
  ili_caload = 149,
  ili_saload = 150,
  ili_iastore = 151,
  ili_lastore = 152,
  ili_fastore = 153,
  ili_dastore = 154,
  ili_aastore = 155,
  ili_bastore = 156,
  ili_castore = 157,
  ili_sastore = 158,
  ili_invokevirtual = 159,
  ili_ds_invokevirtual = 160,
  ili_invokenonvirtual = 161,
  ili_invokestatic = 162,
  ili_ds_invoke_known = 163,
  ili_invokeinterface = 164,
  ili_ds_invokeinterface = 165,
  ili_vreturn = 166,
  ili_ireturn = 167,
  ili_lreturn = 168,
  ili_instanceof = 169,
  ili_ds_instanceof = 170,
  ili_checkcast = 171,
  ili_ds_checkcast = 172,
  ili_athrow = 173,
  ili_monitorenter = 174,
  ili_monitorexit = 175,
  ili_verifystack = 176,
  ili_breakpoint = 177,
  ili_ibitnot = 178,
  ili_icnot = 179,
  ili_icand = 180,
  ili_icor = 181,
  ili_halt = 182,
};


struct li_desc
{
  char * name;
  char * operands;
  int len;
  enum ili_opcode internal_opcode;
};

struct li_desc li_desc[] = 
{
  { "nop", "", 1, ili_nop },
  { "aconst_null", "", 1, ili_push_0 },
  { "iconst_m1", "", 1, ili_iconst_m1 },
  { "iconst_0", "", 1, ili_iconst_0 },
  { "iconst_1", "", 1, ili_iconst_1 },
  { "iconst_2", "", 1, ili_iconst_2 },
  { "iconst_3", "", 1, ili_iconst_3 },
  { "iconst_4", "", 1, ili_iconst_4 },
  { "iconst_5", "", 1, ili_iconst_5 },
  { "lconst_0", "", 1, ili_lconst_0 },
  { "lconst_1", "", 1, ili_lconst_1 },
  { "fconst_0", "", 1, ili_fconst_0 },
  { "fconst_1", "", 1, ili_fconst_1 },
  { "fconst_2", "", 1, ili_fconst_2 },
  { "dconst_0", "", 1, ili_dconst_0 },
  { "dconst_1", "", 1, ili_dconst_1 },
  { "bipush", "l", 2, ili_push_literal },
  { "sipush", "m", 2, ili_push_literal },
  { "ldc1", "c", 2, ili_push_constant },
  { "ldc2", "e", 2, ili_push_constant },
  { "ldc2w", "f", 2, ili_push_constant2 },
  { "iload", "j", 2, ili_iload },
  { "lload", "j", 2, ili_lload },
  { "fload", "j", 2, ili_iload },
  { "dload", "j", 2, ili_lload },
  { "aload", "j", 2, ili_iload },
  { "iload_0", "", 1, ili_iload_0 },
  { "iload_1", "", 1, ili_iload_1 },
  { "iload_2", "", 1, ili_iload_2 },
  { "iload_3", "", 1, ili_iload_3 },
  { "lload_0", "", 1, ili_lload_0 },
  { "lload_1", "", 1, ili_lload_1 },
  { "lload_2", "", 1, ili_lload_2 },
  { "lload_3", "", 1, ili_lload_3 },
  { "fload_0", "", 1, ili_iload_0 },
  { "fload_1", "", 1, ili_iload_1 },
  { "fload_2", "", 1, ili_iload_2 },
  { "fload_3", "", 1, ili_iload_3 },
  { "dload_0", "", 1, ili_lload_0 },
  { "dload_1", "", 1, ili_lload_1 },
  { "dload_2", "", 1, ili_lload_2 },
  { "dload_3", "", 1, ili_lload_3 },
  { "aload_0", "", 1, ili_iload_0 },
  { "aload_1", "", 1, ili_iload_1 },
  { "aload_2", "", 1, ili_iload_2 },
  { "aload_3", "", 1, ili_iload_3 },
  { "iaload", "", 1, ili_iaload },
  { "laload", "", 1, ili_laload },
  { "faload", "", 1, ili_faload },
  { "daload", "", 1, ili_daload },
  { "aaload", "", 1, ili_aaload },
  { "baload", "", 1, ili_baload },
  { "caload", "", 1, ili_caload },
  { "saload", "", 1, ili_saload },
  { "istore", "j", 2, ili_istore },
  { "lstore", "j", 2, ili_lstore },
  { "fstore", "j", 2, ili_istore },
  { "dstore", "j", 2, ili_lstore },
  { "astore", "j", 2, ili_istore },
  { "istore_0", "", 1, ili_istore_0 },
  { "istore_1", "", 1, ili_istore_1 },
  { "istore_2", "", 1, ili_istore_2 },
  { "istore_3", "", 1, ili_istore_3 },
  { "lstore_0", "", 1, ili_lstore_0 },
  { "lstore_1", "", 1, ili_lstore_1 },
  { "lstore_2", "", 1, ili_lstore_2 },
  { "lstore_3", "", 1, ili_lstore_3 },
  { "fstore_0", "", 1, ili_istore_0 },
  { "fstore_1", "", 1, ili_istore_1 },
  { "fstore_2", "", 1, ili_istore_2 },
  { "fstore_3", "", 1, ili_istore_3 },
  { "dstore_0", "", 1, ili_lstore_0 },
  { "dstore_1", "", 1, ili_lstore_1 },
  { "dstore_2", "", 1, ili_lstore_2 },
  { "dstore_3", "", 1, ili_lstore_3 },
  { "astore_0", "", 1, ili_istore_0 },
  { "astore_1", "", 1, ili_istore_1 },
  { "astore_2", "", 1, ili_istore_2 },
  { "astore_3", "", 1, ili_istore_3 },
  { "iastore", "", 1, ili_iastore },
  { "lastore", "", 1, ili_lastore },
  { "fastore", "", 1, ili_fastore },
  { "dastore", "", 1, ili_dastore },
  { "aastore", "", 1, ili_aastore },
  { "bastore", "", 1, ili_bastore },
  { "castore", "", 1, ili_castore },
  { "sastore", "", 1, ili_sastore },
  { "pop", "", 1, ili_pop },
  { "pop2", "", 1, ili_pop2 },
  { "dup", "", 1, ili_dup },
  { "dup_x1", "", 1, ili_dup_x1 },
  { "dup_x2", "", 1, ili_dup_x2 },
  { "dup2", "", 1, ili_dup2 },
  { "dup2_x1", "", 1, ili_dup2_x1 },
  { "dup2_x2", "", 1, ili_dup2_x2 },
  { "swap", "", 1, ili_swap },
  { "iadd", "", 1, ili_iadd },
  { "ladd", "", 1, ili_ladd },
  { "fadd", "", 1, ili_fadd },
  { "dadd", "", 1, ili_dadd },
  { "isub", "", 1, ili_isub },
  { "lsub", "", 1, ili_lsub },
  { "fsub", "", 1, ili_fsub },
  { "dsub", "", 1, ili_dsub },
  { "imul", "", 1, ili_imul },
  { "lmul", "", 1, ili_lmul },
  { "fmul", "", 1, ili_fmul },
  { "dmul", "", 1, ili_dmul },
  { "idiv", "", 1, ili_idiv },
  { "ldiv", "", 1, ili_ldiv },
  { "fdiv", "", 1, ili_fdiv },
  { "ddiv", "", 1, ili_ddiv },
  { "imod", "", 1, ili_imod },
  { "lmod", "", 1, ili_lmod },
  { "fmod", "", 1, ili_fmod },
  { "dmod", "", 1, ili_dmod },
  { "ineg", "", 1, ili_ineg },
  { "lneg", "", 1, ili_lneg },
  { "fneg", "", 1, ili_fneg },
  { "dneg", "", 1, ili_dneg },
  { "ishl", "", 1, ili_ishl },
  { "lshl", "", 1, ili_lshl },
  { "ishr", "", 1, ili_ishr },
  { "lshr", "", 1, ili_lshr },
  { "iushr", "", 1, ili_iushr },
  { "lushr", "", 1, ili_lushr },
  { "iand", "", 1, ili_iand },
  { "land", "", 1, ili_land },
  { "ior", "", 1, ili_ior },
  { "lor", "", 1, ili_lor },
  { "ixor", "", 1, ili_ixor },
  { "lxor", "", 1, ili_lxor },
  { "iinc", "jl", 3, ili_iinc },
  { "i2f", "", 1, ili_i2f },
  { "i2d", "", 1, ili_i2d },
  { "i2l", "", 1, ili_i2l },
  { "l2i", "", 1, ili_l2i },
  { "l2f", "", 1, ili_l2f },
  { "l2d", "", 1, ili_l2d },
  { "f2i", "", 1, ili_f2i },
  { "f2l", "", 1, ili_f2l },
  { "f2d", "", 1, ili_f2d },
  { "d2i", "", 1, ili_d2i },
  { "d2l", "", 1, ili_d2l },
  { "d2f", "", 1, ili_d2f },
  { "int2byte", "", 1, ili_int2byte },
  { "int2char", "", 1, ili_int2char },
  { "int2short", "", 1, ili_int2short },
  { "lcmp", "", 1, ili_lcmp },
  { "fcmpl", "", 1, ili_fcmpl },
  { "fcmpg", "", 1, ili_fcmpg },
  { "dcmpl", "", 1, ili_dcmpl },
  { "dcmpg", "", 1, ili_dcmpg },
  { "ifeq", "b", 2, ili_ifeq },
  { "ifne", "b", 2, ili_ifne },
  { "iflt", "b", 2, ili_iflt },
  { "ifge", "b", 2, ili_ifge },
  { "ifgt", "b", 2, ili_ifgt },
  { "ifle", "b", 2, ili_ifle },
  { "if_icmpeq", "b", 2, ili_if_icmpeq },
  { "if_icmpne", "b", 2, ili_if_icmpne },
  { "if_icmplt", "b", 2, ili_if_icmplt },
  { "if_icmpge", "b", 2, ili_if_icmpge },
  { "if_icmpgt", "b", 2, ili_if_icmpgt },
  { "if_icmple", "b", 2, ili_if_icmple },
  { "if_acmpeq", "b", 2, ili_if_icmpeq },
  { "if_acmpne", "b", 2, ili_if_icmpne },
  { "goto", "b", 2, ili_goto },
  { "jsr", "", 2, ili_jsr },
  { "ret", "", 1, ili_ret },
  { "tableswitch", "i", 1, ili_tableswitch },
  { "lookupswitch", "k", 1, ili_lookupswitch },
  { "ireturn", "", 1, ili_ireturn },
  { "lreturn", "", 1, ili_lreturn },
  { "freturn", "", 1, ili_ireturn },
  { "dreturn", "", 1, ili_lreturn },
  { "areturn", "", 1, ili_ireturn },
  { "return", "", 1, ili_vreturn },
  { "getstatic", "d", 1, ili_getstatic },
  { "putstatic", "d", 1, ili_putstatic },
  { "getfield", "d", 1, ili_getfield },
  { "putfield", "d", 1, ili_putfield },
  { "invokevirtual", "g", 2, ili_invokevirtual },
  { "invokenonvirtual", "g", 1, ili_invokenonvirtual },
  { "invokestatic", "g", 1, ili_invokestatic },
  { "invokeinterface", "g", 1, ili_invokeinterface },
  { "newfromname", "", 1, ili_newfromname },
  { "new", "h", 1, ili_new },
  { "newarray", "a", 1, ili_newarray },
  { "anewarray", "h", 1, ili_anewarray },
  { "arraylength", "", 1, ili_arraylength },
  { "athrow", "", 1, ili_athrow },
  { "checkcast", "h", 1, ili_checkcast },
  { "instanceof", "h", 1, ili_instanceof },
  { "monitorenter", "", 1, ili_monitorenter },
  { "monitorexit", "", 1, ili_monitorexit },
  { "verifystack", "", 1, ili_verifystack },
  { "breakpoint", "", 1, ili_breakpoint },
  { "multianewarray", "hn", 1, ili_multianewarray },
  { "ibitnot", "", 1, ili_ibitnot },
  { "icnot", "", 1, ili_icnot },
  { "icand", "", 1, ili_icand },
  { "icor", "", 1, ili_icor },
  { "halt", "", 1, ili_halt },
};
