/* "readline.c" Scheme interface to readline library
   Copyright 1994 Radey Shouman.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "scm.h"

char *readline();
void add_history();

             /* Reads on stdin/stdout only */
static char s_readline[] = "read-edited-line";
SCM lreadline(prompt)
     SCM prompt;
{
  SCM res;
  char *s;
  ASSERT(NIMP(prompt) && STRINGP(prompt), prompt, ARG1, s_readline);
  s = readline(CHARS(prompt));
  if (NULL == s) return EOF_VAL;
  NEWCELL(res);
  DEFER_INTS;
  SETCHARS(res,s);
  SETLENGTH(res,(sizet)strlen(s),tc7_string);
  ALLOW_INTS;
  return res;
}
static char s_add_history[] = "add-history";
SCM ladd_history(line)
     SCM line;
{
  ASSERT(NIMP(line) && STRINGP(line), line, ARG1, s_add_history);
  add_history(CHARS(line));
  return UNSPECIFIED;
}
static char s_def_inport[] = "default-input-port";
SCM def_inport()
{
  return def_inp;
}
static char s_def_outport[] = "default-output-port";
SCM def_outport()
{
  return def_outp;
}
static char s_Iedline[] = "Iedline.scm";
void init_edline()
{
  scm_make_subr(s_def_inport, tc7_subr_0, def_inport);
  scm_make_subr(s_def_outport, tc7_subr_0, def_outport);
  scm_make_subr(s_readline, tc7_subr_1, lreadline);
  scm_make_subr(s_add_history, tc7_subr_1, ladd_history);  
  if (scm_ldprog(s_Iedline))
    scm_wta(*scm_loc_errobj, "couldn't init", s_Iedline);
}
