/* classes: src_files */

/*	Copyright (C) 1994 Free Software Foundation, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this software; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */



#include "guile.h"

#ifndef IMPLINIT
#define IMPLINIT ""
#endif

extern char * getenv ();


static char * banner[] = 
{
  "GSCM, Copyright (C) 1995 Free Software Foundation.",
  "Based on SCM version 4e2.",
  "SCM is Copyright (C) 1990, 1991, 1992, 1993, 1994 Aubrey Jaffer.",
  "SCM comes with ABSOLUTELY NO WARRANTY; for details type `(terms)'.",
  "This is free software, and you are welcome to redistribute it",
  "under certain conditions; type `(terms)' for details.",
  0
};

extern void guile_mini ();
extern void guile_ks ();

extern int scm_verbose;
extern char * gscm_last_attempted_init_file;
int 
main (argc, argv)
     int argc;
     char **argv;
{
  char *initpath;
  GSCM_status status;
  GSCM_top_level top;

  {
    char ** p;
    for (p = banner; *p; ++p)
      puts (*p);
  }
  fflush (stdout);

  gscm_take_stdin ();

  status = gscm_init_from_fn (0, argc, argv, guile_ks);

  if (status == GSCM_OK)
    status = gscm_create_top_level (&top);

  if (status == GSCM_OK)
    {
      scm_verbose = -1;
      status = gscm_seval_str (0, top, "(stand-alone-repl)");
    }


  if (status != GSCM_OK)
    {
      if (status != GSCM_QUIT)
	fprintf (stderr, "%s\n", gscm_error_msg (status));
      if (status == GSCM_ERROR_OPENING_INIT_FILE)
	fprintf (stderr, "init file was: %s\n",
		 gscm_last_attempted_init_file);
      exit (1);
    }
}
