/* classes: src_files */

/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */



SCM
latte_allocate (size, type)
     int size;
     SCM type;
{
  SCM answer;

  NEWCELL (answer);

  DEFER_INTS;
  CAR (answer) = (type + 1);
  CDR (answer) = (SCM)(1 + (SCM*)scm_must_malloc ((1 + size) * sizeof (SCM),
						  "latte-object"));
  LATTE_DATA2HANDLE (LATTE_DATA (answer)) = answer;
  bzero (LATTE_DATA (answer), size * sizeof (SCM));
  ALLOW_INTS;

  return answer;
}

static char * s_latte_allocate[] = "latte-allocate";

SCM
scm_latte_allocate (size, type)
     SCM size;
     SCM type;
{
  ASSERT (INUMP (size), size, ARG1, s_latte_allocate);
  ASSERT (NIMP (type) && LATTEP (type), type, ARG2, s_latte_allocate);
  return latte_allocate (INUM (size), type);
}


