#if 0

not portable yet

/* Interfaces to tty and pty functions.
 * 
 * Copyright (C) 1985, 1986, 1987, 1988, 1993, 1994 Free Software Foundation, Inc.
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

#ifdef linux
#define HAVE_TERMIOS
#define HAVE_PTYS
#define MAX_PTY_NAME 15
#endif

#include "scm.h"
#include "tty.h"

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_PTYS
static char scm_s_open_pty[] = "%open-pty";
SCM
scm_open_pty ()
{
  char pty_name[MAX_PTY_NAME];
  int fd;

  fd = pty_allocate (pty_name);
  if (fd == -1)
    return BOOL_F;
  else {
    FILE *stream;
    SCM ctrl_pty;

    NEWCELL (ctrl_pty);
    DEFER_INTS;
    stream = fdopen (fd, "r+");
    if (!stream)
      {
	SYSCALL (close (fd));
	ALLOW_INTS;
	return BOOL_F;
      }
    SETSTREAM (ctrl_pty, stream);
    CAR (ctrl_pty) = tc16_fport | scm_mode_bits ("r+0");
    i_setbuf0 (ctrl_pty);
    scm_add_to_port_table (ctrl_pty);
    ALLOW_INTS;
    return scm_cons (ctrl_pty,
		     scm_makfromstr (pty_name, strlen (pty_name), 0));
  }
}

/* Set the tty flags for the controlling pty terminal of a child process.  */
static char scm_s_child_pty[] = "%child-setup-master-pty";
SCM
scm_child_pty (port)
     SCM port;
{
  
  int fd;
  ASSERT (NIMP (port) && OPFPORTP (port), port, ARG1, scm_s_child_pty);
#ifndef VMS
#ifndef MSDOS
  fd = fileno (STREAM (port));
  if (fd == -1)
    return BOOL_F;

  child_setup_tty (fd);
#endif
#endif
  return BOOL_T;
}

static char scm_s_open_slave[] = "%open-slave-pty";
/* Open the slave psuedo terminal device.  */
SCM
scm_open_slave (name)
     SCM name;
{
  int fd;
  FILE *stream;
  SCM result;

  ASSERT (NIMP (name) && STRINGP (name), name, ARG1, scm_s_open_slave);
  NEWCELL (result);
  DEFER_INTS;
#ifdef O_NOCTTY
  /* Don't let this terminal become our controlling terminal
     (in case we don't have one).  */
  SYSCALL (fd = open (CHARS (name), O_RDWR | O_NOCTTY, 0));
#else
  SYSCALL (fd = open (CHARS (name), O_RDWR, 0));
#endif
  if (fd == -1)
    {
      ALLOW_INTS;
      return BOOL_F;
    }
  stream = fdopen (fd, "r+");
  if (!stream)
    {
      SYSCALL (close (fd));
      ALLOW_INTS;
      return BOOL_F;
    }
  SETSTREAM (result, stream);
  CAR (result) = tc16_fport | scm_mode_bits ("r+0");
  i_setbuf0 (result);
  scm_add_to_port_table (result);
  ALLOW_INTS;
  return result;
}
#endif /* HAVE_PTYS */

void
scm_init_pty ()
{
#ifdef HAVE_PTYS
  scm_make_subr (scm_s_open_pty, tc7_subr_0, scm_open_pty);
  scm_make_subr (scm_s_child_pty, tc7_subr_1, scm_child_pty);
  scm_make_subr (scm_s_open_slave, tc7_subr_1, scm_open_slave);
  scm_add_feature ("pty");
#endif
}

#endif
