YYSTYPE parse_answer;

YYSTYPE parse_eol;
YYSTYPE parse_false;
YYSTYPE parse_define_sym;
YYSTYPE parse_SCM_sym;
YYSTYPE parse_if_sym;
YYSTYPE parse_while_sym;
YYSTYPE parse_for_sym;
YYSTYPE parse_return_sym;
YYSTYPE parse_break_sym;
YYSTYPE parse_continue_sym;
YYSTYPE parse_comma_sym;
YYSTYPE parse_do_sym;
YYSTYPE parse_begin_sym;
YYSTYPE parse_neg_sym;
YYSTYPE parse_log_neg_sym;
YYSTYPE parse_pos_sym;
YYSTYPE parse_bit_neg_sym;
YYSTYPE parse_bit_and_sym;
YYSTYPE parse_times_sym;
YYSTYPE parse_div_sym;
YYSTYPE parse_mod_sym;
YYSTYPE parse_plus_sym;
YYSTYPE parse_minus_sym;
YYSTYPE parse_lshift_sym;
YYSTYPE parse_rshift_sym;
YYSTYPE parse_eq_sym;
YYSTYPE parse_ne_sym;
YYSTYPE parse_le_sym;
YYSTYPE parse_ge_sym;
YYSTYPE parse_lt_sym;
YYSTYPE parse_gt_sym;
YYSTYPE parse_bit_and_sym;
YYSTYPE parse_bit_xor_sym;
YYSTYPE parse_bit_or_sym;
YYSTYPE parse_log_and_sym;
YYSTYPE parse_log_or_sym;
YYSTYPE parse_if_exp_sym;
YYSTYPE parse_apply_sym;
YYSTYPE parse_assign_sym;


static YYSTYPE parse_root;


void
parse_protect (a)
     YYSTYPE a;
{
  SCM protector;
  NEWCELL(protector);
  CAR(protector) = a;
  CDR(protector) = parse_root;
  parse_root = protector;
}

YYSTYPE
parse_intern (s)
     char * s;
{
  SCM answer;
  int len;
  len = strlen (s);
  {
    int x;
    for (x = 0; x < len; ++x)
      switch (s[x])
	{
	default:
	  break;
	case '_':
	  s[x] = '-';
	}
  }
  answer = scm_intern (s, strlen(s));
  if (CDR(answer) == SCM_UNDEFINED)
    CDR (answer) = MAKINUM(0);
  parse_protect (answer);
  return CAR(answer);
}


YYSTYPE
parse_make_string (s)
     char * s;
{
  SCM answer;
  char * out;
  char * in;
  in = s + 1;
  out = s;
 interpret_char:
  switch (*in)
    {
    default:
      *out = *in;
      ++out;
      ++in;
      goto interpret_char;
    case '"':
      break;
    case '\\':
      ++in;
      switch (*in)
	{
	default:
	  *out = *in;
	  ++out;
	  ++in;
	  goto interpret_char;
	case 'n':
	  *out = '\n';
	  ++out;
	  ++in;
	  goto interpret_char;
	case 'r':
	  *out = '\r';
	  ++out;
	  ++in;
	  goto interpret_char;
	case 't':
	  *out = '\t';
	  ++out;
	  ++in;
	  goto interpret_char;
	case '0':
	  {
	    int x;
	    int len;
	    ++in;
	    len = 1;
	    x = 0;
	    while (('0' < *in) && ('8' > *in) && (len < 4))
	      {
		x *= 8;
		x += (*in - '0');
		++in;
	      }
	    *out = x;
	    ++out;
	    ++in;
	    goto interpret_char;
	  }
	}
    }
  *out = 0;
  {
    int len;
    len = strlen (s);
    answer = scm_makstr (len, 0);
    memcpy (CHARS(answer), s, len);
  }
  parse_protect (answer);
  return answer;
}

YYSTYPE
parse_make_char (s)
     char * s;
{
  int c;
  char * in;
  in = s + 1;
  switch (*in)
    {
    default:
      c = *in;
      break;
    case '\\':
      ++in;
      switch (*in)
	{
	default:
	  c = *in;
	  break;
	case 'n':
	  c = '\n';
	  break;
	case 'r':
	  c = '\r';
	  break;
	case 't':
	  c = '\t';
	  break;
	case '0':
	  {
	    int x;
	    int len;
	    ++in;
	    len = 1;
	    x = 0;
	    while (('0' < *in) && ('8' > *in) && (len < 4))
	      {
		x *= 8;
		x += (*in - '0');
		++in;
	      }
	    c = x;
	    break;
	  }
	}
    }

  return MAKICHR (c);
}


YYSTYPE 
parse_cons (a, b)
     YYSTYPE a;
     YYSTYPE b;
{
  SCM answer;
  NEWCELL(answer);
  CAR(answer) = a;
  CDR(answer) = b;
  parse_protect (answer);
  return answer;
}

YYSTYPE 
parse_append (l, p)
     YYSTYPE l;
     YYSTYPE p;
{
  SCM newc;
  SCM orig;
  newc = parse_cons (p, parse_eol);

  if (l == EOL)
    return newc;

  orig = l;
  while (NIMP(l) && NIMP (CDR(l)))
    l = CDR(l);

  if (NIMP(l))
    CDR(l) = newc;

  return orig;
}

YYSTYPE 
parse_append_optcons (l, p)
     YYSTYPE l;
     YYSTYPE p;
{
  if (NIMP (p))
    return parse_append (l, p);
  else
    {
      SCM last;
      NEWCELL (last);
      CAR(last) = p;
      CDR(last) = parse_eol;
      return parse_append (l, last);
    }  
}


YYSTYPE 
parse_2list (l, p)
     YYSTYPE l;
     YYSTYPE p;
{
  SCM newc;
  NEWCELL (newc);
  CAR(newc) = p;
  CDR(newc) = EOL;
  return parse_cons (l, newc);
}

YYSTYPE
parse_number (t)
     char * t;
{
  return scm_istring2number (t, strlen (t), 10);
}

static char s_ctax_parse[] = "ctax-parse";

SCM ctax_burst_fn;
static char * parse_buffer;
static char * parse_buffer_pos;

int
parse_input (buf, max_size)
     char * buf;
     int max_size;
{
  SCM str;
  int result;
  str = scm_apply (ctax_burst_fn, EOL, EOL);
  if (NIMP(str) && STRINGP(str))
    {
      memcpy (buf, CHARS(str), LENGTH(str));
      return LENGTH(str);
    }
  else
    return 0;
}

SCM
ctax_parse (fn)
     SCM fn;
{
  SCM answer;
  ctax_burst_fn = fn;
  ctyyrestart (stdin);
  if (!ctyyparse())
    answer = parse_answer;
  else
    answer = BOOL_F;
  parse_root = EOL;
  ctyyrestart (stdin);
  return answer;
}

static scm_iproc subr1s[] =
{
  {s_ctax_parse, ctax_parse},
  {0,0}
};

scm_init_ctax ()
{
  parse_eol = EOL;
  parse_false = BOOL_F;
  scm_init_iprocs(subr1s, tc7_subr_1);

  parse_root = scm_sysintern ("ctax:parse-root", EOL);
  parse_SCM_sym = CAR(scm_sysintern ("ctax:SCM", MAKINUM(0)));
  parse_define_sym = CAR(scm_sysintern ("ctax:define", MAKINUM(0)));
  parse_if_sym = CAR(scm_sysintern ("ctax:if", MAKINUM(0)));
  parse_while_sym = CAR(scm_sysintern ("ctax:while", MAKINUM(0)));
  parse_for_sym = CAR(scm_sysintern ("ctax:for", MAKINUM(0)));
  parse_return_sym = CAR(scm_sysintern ("ctax:return", MAKINUM(0)));
  parse_break_sym = CAR(scm_sysintern ("ctax:break", MAKINUM(0)));
  parse_continue_sym = CAR(scm_sysintern ("ctax:continue", MAKINUM(0)));
  parse_comma_sym = CAR(scm_sysintern ("ctax:comma", MAKINUM(0)));
  parse_do_sym = CAR(scm_sysintern ("ctax:do", MAKINUM(0)));
  parse_begin_sym = CAR(scm_sysintern ("ctax:begin", MAKINUM(0)));
  parse_neg_sym = CAR(scm_sysintern ("ctax:neg", MAKINUM(0)));
  parse_log_neg_sym = CAR(scm_sysintern ("ctax:log-neg", MAKINUM(0)));
  parse_pos_sym = CAR(scm_sysintern ("ctax:pos", MAKINUM(0)));
  parse_bit_neg_sym = CAR(scm_sysintern ("ctax:bit-neg", MAKINUM(0)));
  parse_bit_and_sym = CAR(scm_sysintern ("ctax:bit-and", MAKINUM(0)));
  parse_times_sym = CAR(scm_sysintern ("ctax:times", MAKINUM(0)));
  parse_div_sym = CAR(scm_sysintern ("ctax:div", MAKINUM(0)));
  parse_mod_sym = CAR(scm_sysintern ("ctax:mod", MAKINUM(0)));
  parse_plus_sym = CAR(scm_sysintern ("ctax:plus", MAKINUM(0)));
  parse_minus_sym = CAR(scm_sysintern ("ctax:minus", MAKINUM(0)));
  parse_lshift_sym = CAR(scm_sysintern ("ctax:lshift", MAKINUM(0)));
  parse_rshift_sym = CAR(scm_sysintern ("ctax:rshift", MAKINUM(0)));
  parse_eq_sym = CAR(scm_sysintern ("ctax:eq", MAKINUM(0)));
  parse_ne_sym = CAR(scm_sysintern ("ctax:ne", MAKINUM(0)));
  parse_le_sym = CAR(scm_sysintern ("ctax:le", MAKINUM(0)));
  parse_ge_sym = CAR(scm_sysintern ("ctax:ge", MAKINUM(0)));
  parse_lt_sym = CAR(scm_sysintern ("ctax:lt", MAKINUM(0)));
  parse_gt_sym = CAR(scm_sysintern ("ctax:gt", MAKINUM(0)));
  parse_bit_and_sym = CAR(scm_sysintern ("ctax:bit-and", MAKINUM(0)));
  parse_bit_xor_sym = CAR(scm_sysintern ("ctax:bit-xor", MAKINUM(0)));
  parse_bit_or_sym = CAR(scm_sysintern ("ctax:bit-or", MAKINUM(0)));
  parse_log_and_sym = CAR(scm_sysintern ("ctax:log-and", MAKINUM(0)));
  parse_log_or_sym = CAR(scm_sysintern ("ctax:log-or", MAKINUM(0)));
  parse_if_exp_sym = CAR(scm_sysintern ("ctax:if-exp", MAKINUM(0)));
  parse_apply_sym = CAR(scm_sysintern ("ctax:apply", MAKINUM(0)));
  parse_assign_sym = CAR(scm_sysintern ("ctax:assign", MAKINUM(0)));
}

int
ctyywrap ()
{
  return 1;
}
