/*	bitmap.h : bitmaps for jetpack
*/

#include "copyright.h"

static char fire_bits[FIREPHASES][FIREPARTS][60] = {
{
{
   0x80, 0x3f, 0x06, 0xe0, 0xff, 0x01, 0x72, 0xff, 0x07, 0x7e, 0x0f, 0x0e,
   0x5d, 0xfb, 0x06, 0x2e, 0x7f, 0x06, 0x6e, 0xfc, 0x0e, 0xde, 0x6f, 0x0f,
   0xe3, 0xdf, 0x0f, 0xee, 0x77, 0x0f, 0x1f, 0x7c, 0x0c, 0xf8, 0xbd, 0x07,
   0x9c, 0x1b, 0x0f, 0x7e, 0x3f, 0x07, 0xfa, 0xdf, 0x0f, 0xea, 0x75, 0x07,
   0xf1, 0xff, 0x0f, 0xe0, 0x7f, 0x08, 0x8a, 0x3f, 0x00, 0x2f, 0x49, 0x00},
{
   0x00, 0x00, 0xf0, 0x00, 0x00, 0xf0, 0x80, 0x00, 0xf0, 0x80, 0xf0, 0xf1,
   0xa0, 0x04, 0xf1, 0xd0, 0x80, 0xf1, 0x90, 0x03, 0xf1, 0x20, 0x90, 0xf0,
   0x1c, 0x20, 0xf0, 0x10, 0x88, 0xf0, 0xe0, 0x83, 0xf3, 0x00, 0x42, 0xf0,
   0x60, 0xe4, 0xf0, 0x80, 0xc0, 0xf0, 0x00, 0x20, 0xf0, 0x10, 0x8a, 0xf0,
   0x00, 0x00, 0xf0, 0x00, 0x00, 0xf0, 0x00, 0x00, 0xf0, 0x00, 0x00, 0xf0},
},
{
{
   0x81, 0x17, 0x00, 0xe7, 0xff, 0x08, 0xf1, 0xfd, 0x0f, 0x7b, 0x6e, 0x0b,
   0xde, 0xc2, 0x0a, 0xbc, 0xbf, 0x04, 0xfe, 0x97, 0x03, 0xf4, 0xef, 0x0f,
   0xe4, 0xd6, 0x0f, 0xf0, 0xf0, 0x0d, 0xbf, 0x2d, 0x0f, 0xd7, 0x7f, 0x0e,
   0xfb, 0xf7, 0x0f, 0xeb, 0xbf, 0x06, 0x7e, 0x63, 0x06, 0x78, 0xa3, 0x03,
   0xb4, 0xdf, 0x04, 0xe0, 0xff, 0x0e, 0x4b, 0xa7, 0x00, 0x80, 0x20, 0x00},
{
   0x00, 0x00, 0xf0, 0x00, 0x00, 0xf0, 0x00, 0x02, 0xf0, 0x80, 0x91, 0xf0,
   0x20, 0x3d, 0xf1, 0x40, 0x40, 0xf3, 0x00, 0x68, 0xf0, 0x08, 0x10, 0xf0,
   0x18, 0x29, 0xf0, 0x08, 0x0f, 0xf2, 0x40, 0xd2, 0xf0, 0x28, 0x80, 0xf1,
   0x04, 0x08, 0xf0, 0x14, 0x40, 0xf1, 0x80, 0x9c, 0xf1, 0x80, 0x5c, 0xf0,
   0x40, 0x20, 0xf0, 0x00, 0x00, 0xf0, 0x00, 0x00, 0xf0, 0x00, 0x00, 0xf0},
},
{
{
   0x80, 0x9f, 0x00, 0xee, 0xff, 0x09, 0xf7, 0xaf, 0x05, 0xb9, 0xff, 0x03,
   0xf8, 0xab, 0x07, 0xdc, 0xe7, 0x07, 0x62, 0x49, 0x0d, 0x9e, 0xff, 0x0e,
   0xfb, 0x3f, 0x0d, 0x1e, 0x3f, 0x0d, 0x7c, 0xea, 0x0f, 0x9c, 0xee, 0x0d,
   0xae, 0xbb, 0x0f, 0x9d, 0xb3, 0x06, 0x96, 0xfb, 0x07, 0xfa, 0xe7, 0x07,
   0xef, 0xee, 0x04, 0xee, 0x7f, 0x0d, 0x84, 0x75, 0x0a, 0xa0, 0xe7, 0x08},
{
   0x00, 0x00, 0xf0, 0x00, 0x00, 0xf0, 0x00, 0x50, 0xf0, 0x40, 0x00, 0xf0,
   0x00, 0x54, 0xf0, 0x20, 0x18, 0xf0, 0x9c, 0xb6, 0xf2, 0x60, 0x00, 0xf1,
   0x04, 0xc0, 0xf2, 0xe0, 0xc0, 0xf2, 0x80, 0x15, 0xf0, 0x60, 0x11, 0xf2,
   0x50, 0x44, 0xf0, 0x62, 0x4c, 0xf1, 0x68, 0x04, 0xf0, 0x04, 0x18, 0xf0,
   0x00, 0x11, 0xf0, 0x00, 0x00, 0xf0, 0x00, 0x02, 0xf0, 0x00, 0x00, 0xf0},
},
{
{
   0xb2, 0x3a, 0x0c, 0xe9, 0xfd, 0x00, 0x28, 0xfd, 0x07, 0x72, 0xe4, 0x06,
   0xf2, 0x1f, 0x04, 0x37, 0xde, 0x02, 0x7f, 0x3f, 0x0f, 0xfe, 0x2f, 0x0f,
   0x3a, 0x86, 0x0d, 0xa2, 0xff, 0x0d, 0xce, 0xda, 0x0d, 0xfe, 0xeb, 0x0f,
   0x47, 0xfc, 0x0f, 0xab, 0xf2, 0x05, 0xbe, 0x66, 0x01, 0xd9, 0x4b, 0x03,
   0x72, 0xdf, 0x07, 0xd4, 0xed, 0x04, 0x92, 0x7f, 0x0b, 0x14, 0x18, 0x00},
{
   0x00, 0x00, 0xf0, 0x10, 0x02, 0xf0, 0xd0, 0x02, 0xf0, 0x8c, 0x1b, 0xf1,
   0x0c, 0xe0, 0xf3, 0xc8, 0x21, 0xf1, 0x80, 0xc0, 0xf0, 0x01, 0xd0, 0xf0,
   0xc5, 0x79, 0xf2, 0x5d, 0x00, 0xf2, 0x31, 0x25, 0xf2, 0x01, 0x14, 0xf0,
   0xb8, 0x03, 0xf0, 0x54, 0x0d, 0xf0, 0x40, 0x99, 0xf0, 0x20, 0xb4, 0xf0,
   0x80, 0x20, 0xf0, 0x00, 0x12, 0xf3, 0x00, 0x00, 0xf0, 0x00, 0x00, 0xf0},
},
{
{
   0xb0, 0x7b, 0x04, 0xea, 0xc9, 0x0d, 0xff, 0xf8, 0x05, 0x7e, 0xf7, 0x07,
   0xfc, 0x7f, 0x05, 0xfc, 0x33, 0x02, 0xbc, 0x63, 0x0e, 0xf6, 0xdf, 0x07,
   0xef, 0xad, 0x0f, 0xf6, 0xfd, 0x0f, 0x7f, 0xf2, 0x0e, 0xd7, 0x75, 0x0f,
   0xae, 0xbe, 0x0b, 0x7e, 0xff, 0x07, 0x97, 0xff, 0x0b, 0xf4, 0x6b, 0x01,
   0x60, 0x77, 0x01, 0x98, 0xff, 0x00, 0x74, 0xac, 0x06, 0x06, 0x00, 0x08},
{
   0x00, 0x00, 0xf0, 0x10, 0x30, 0xf0, 0x00, 0x00, 0xf0, 0x80, 0x08, 0xf0,
   0x10, 0x80, 0xf0, 0x00, 0xcc, 0xf1, 0x40, 0x9c, 0xf1, 0x08, 0x20, 0xf0,
   0x10, 0x52, 0xf0, 0x08, 0x02, 0xf0, 0x80, 0x0d, 0xf1, 0x28, 0x8a, 0xf0,
   0x50, 0x41, 0xf0, 0x80, 0x00, 0xf0, 0x60, 0x00, 0xf0, 0x00, 0x94, 0xf0,
   0x80, 0x88, 0xf0, 0x60, 0x00, 0xf0, 0x00, 0x00, 0xf0, 0x00, 0x00, 0xf0},
},
};

static char key_bits[KEYPARTS][20] = { {
   0x0e, 0x00, 0x1b, 0x00, 0x11, 0x00, 0x3b, 0x00, 0x7e, 0x00, 0xc0, 0x00,
   0xe0, 0x01, 0x20, 0x03, 0x80, 0x03, 0x80, 0x00}
};

static char burn_bits[BURNDIRECTIONS][BURNPARTS][60] = {
{
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x80, 0x03, 0x00, 0x00, 0x01,
   0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
},
{
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x0e,
   0x02, 0x00, 0x04, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x05, 0x00, 0x0a, 0x05, 0x00, 0x0a, 0x07, 0x00, 0x0e, 0x02, 0x00, 0x04,
   0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
},
{
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00,
   0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x14, 0x00, 0x00, 0x14, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x08, 0x00, 0x00,
   0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
},

};

static char player_bits[PLAYERPHASES][PLAYERPARTS][60] = {
{
{
   0xc0, 0x00, 0x00, 0xe0, 0x01, 0x00, 0xe0, 0x01, 0x00, 0xc0, 0x00, 0x00,
   0x20, 0x01, 0x00, 0xd0, 0x00, 0x00, 0xd0, 0x00, 0x00, 0xd0, 0x00, 0x00,
   0xe0, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xe0, 0x01, 0x00, 0xe0, 0x00, 0x00, 0xe0, 0x00, 0x00, 0xc0, 0x00, 0x00,
   0xc0, 0x01, 0x00, 0x80, 0x01, 0x00, 0x80, 0x03, 0x00, 0xc0, 0x03, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0xc0, 0x03, 0x00, 0xe0, 0x03,
   0xc0, 0xf6, 0x03, 0x20, 0xbf, 0x03, 0x20, 0x9f, 0x03, 0x20, 0x0f, 0x00,
   0x00, 0x07, 0x00, 0x80, 0x07, 0x00, 0xfc, 0x07, 0x00, 0xfc, 0x07, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
},

{
{
   0xc0, 0x00, 0x00, 0xe0, 0x01, 0x00, 0xe0, 0x01, 0x00, 0xc0, 0x00, 0x00,
  0x20, 0x01, 0x00, 0xd0, 0x00, 0x00, 0xd0, 0x00, 0x00, 0xd0, 0x00, 0x00,
   0xe0, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xe0, 0x01, 0x00, 0xe0, 0x01, 0x00, 0xe0, 0x00, 0x00, 0xf0, 0x00, 0x00,
   0xe0, 0x01, 0x00, 0xe0, 0x03, 0x00, 0x60, 0x03, 0x00, 0xf0, 0x01, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0xc0, 0x03, 0x00, 0xe0, 0x03,
   0xc0, 0xf6, 0x03, 0x20, 0xbf, 0x03, 0x20, 0x9f, 0x03, 0x20, 0x0f, 0x00,
   0x00, 0x07, 0x00, 0x80, 0x07, 0x00, 0xfc, 0x07, 0x00, 0xfc, 0x07, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
},

{
{
   0xc0, 0x00, 0x00, 0xe0, 0x01, 0x00, 0xe0, 0x01, 0x00, 0xc0, 0x00, 0x00,
  0x20, 0x01, 0x00, 0xd0, 0x00, 0x00, 0xd0, 0x00, 0x00, 0xd0, 0x00, 0x00,
   0xe0, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xe0, 0x01, 0x00, 0xf0, 0x01, 0x00, 0xb0, 0x01, 0x00, 0x30, 0x03, 0x00,
   0x30, 0x06, 0x00, 0x30, 0x0c, 0x00, 0x30, 0x06, 0x00, 0x38, 0x00, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0xc0, 0x03, 0x00, 0xe0, 0x03,
   0xc0, 0xf6, 0x03, 0x20, 0xbf, 0x03, 0x20, 0x9f, 0x03, 0x20, 0x0f, 0x00,
   0x00, 0x07, 0x00, 0x80, 0x07, 0x00, 0xfc, 0x07, 0x00, 0xfc, 0x07, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
},

{
{
   0xc0, 0x00, 0x00, 0xe0, 0x01, 0x00, 0xe0, 0x01, 0x00, 0xc0, 0x00, 0x00,
  0x20, 0x01, 0x00, 0xd0, 0x00, 0x00, 0xd0, 0x00, 0x00, 0xd0, 0x00, 0x00,
   0xe0, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xe0, 0x01, 0x00, 0xf0, 0x01, 0x00, 0xb0, 0x01, 0x00, 0xb0, 0x01, 0x00,
   0x18, 0x03, 0x00, 0x18, 0x03, 0x00, 0x18, 0x06, 0x00, 0x1c, 0x07, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0xc0, 0x03, 0x00, 0xe0, 0x03,
   0xc0, 0xf6, 0x03, 0x20, 0xbf, 0x03, 0x20, 0x9f, 0x03, 0x20, 0x0f, 0x00,
   0x00, 0x07, 0x00, 0x80, 0x07, 0x00, 0xfc, 0x07, 0x00, 0xfc, 0x07, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
},

{
{
   0xc0, 0x00, 0x00, 0xe0, 0x01, 0x00, 0xe0, 0x01, 0x00, 0xc0, 0x00, 0x00,
  0x20, 0x01, 0x00, 0xd0, 0x00, 0x00, 0xd0, 0x00, 0x00, 0xd0, 0x00, 0x00,
   0xe0, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xe0, 0x01, 0x00, 0xb0, 0x01, 0x00, 0xb0, 0x01, 0x00, 0xb8, 0x01, 0x00,
   0x18, 0x03, 0x00, 0x18, 0x03, 0x00, 0x1c, 0x03, 0x00, 0x80, 0x03, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0xc0, 0x03, 0x00, 0xe0, 0x03,
   0xc0, 0xf6, 0x03, 0x20, 0xbf, 0x03, 0x20, 0x9f, 0x03, 0x20, 0x0f, 0x00,
   0x00, 0x07, 0x00, 0x80, 0x07, 0x00, 0xfc, 0x07, 0x00, 0xfc, 0x07, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
},

{
{
   0xc0, 0x00, 0x00, 0xe0, 0x01, 0x00, 0xe0, 0x01, 0x00, 0xc0, 0x00, 0x00,
  0x20, 0x01, 0x00, 0xd0, 0x00, 0x00, 0xd0, 0x00, 0x00, 0xd0, 0x00, 0x00,
   0xe0, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xe0, 0x01, 0x00, 0xe0, 0x00, 0x00, 0xf0, 0x00, 0x00, 0xf0, 0x00, 0x00,
   0xb0, 0x01, 0x00, 0xb0, 0x01, 0x00, 0xb8, 0x01, 0x00, 0xc0, 0x01, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0xc0, 0x03, 0x00, 0xe0, 0x03,
   0xc0, 0xf6, 0x03, 0x20, 0xbf, 0x03, 0x20, 0x9f, 0x03, 0x20, 0x0f, 0x00,
   0x00, 0x07, 0x00, 0x80, 0x07, 0x00, 0xfc, 0x07, 0x00, 0xfc, 0x07, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
},

{
{
   0xc0, 0x00, 0x00, 0xe0, 0x01, 0x00, 0xe0, 0x01, 0x00, 0xc0, 0x00, 0x00,
  0x20, 0x01, 0x00, 0xd0, 0x00, 0x00, 0xd0, 0x00, 0x00, 0xd0, 0x00, 0x00,
   0xe0, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xe0, 0x01, 0x00, 0xe0, 0x00, 0x00, 0xc0, 0x00, 0x00, 0xc0, 0x00, 0x00,
   0xc0, 0x00, 0x00, 0xc0, 0x00, 0x00, 0xc0, 0x00, 0x00, 0xe0, 0x00, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0xc0, 0x03, 0x00, 0xe0, 0x03,
   0xc0, 0xf6, 0x03, 0x20, 0xbf, 0x03, 0x20, 0x9f, 0x03, 0x20, 0x0f, 0x00,
   0x00, 0x07, 0x00, 0x80, 0x07, 0x00, 0xfc, 0x07, 0x00, 0xfc, 0x07, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
},


{
{
   0x00, 0x06, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x06, 0x00,
   0x00, 0x0f, 0x00, 0xc0, 0x36, 0x00, 0xe0, 0x76, 0x00, 0xb0, 0xd6, 0x00,
   0x30, 0xc9, 0x00, 0x30, 0xc9, 0x00, 0x20, 0x40, 0x00, 0x20, 0x40, 0x00,
   0x00, 0x00, 0x00, 0x80, 0x19, 0x00, 0x80, 0x19, 0x00, 0x80, 0x19, 0x00,
   0x80, 0x10, 0x00, 0x80, 0x19, 0x00, 0x80, 0x19, 0x00, 0xc0, 0x39, 0x00},
{
   0x00, 0x00, 0x00, 0x06, 0x00, 0x06, 0x0f, 0x00, 0x0f, 0x1f, 0x80, 0x0f,
   0xbf, 0xd0, 0x0f, 0x37, 0xc9, 0x0e, 0x07, 0x09, 0x0e, 0x40, 0x29, 0x00,
   0x80, 0x16, 0x00, 0x00, 0x06, 0x00, 0xc0, 0x3f, 0x00, 0xc0, 0x3f, 0x00,
   0x00, 0x0f, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
},

{
{
   0x00, 0x30, 0x00, 0x00, 0x78, 0x00, 0x00, 0x78, 0x00, 0x00, 0x30, 0x00,
  0x00, 0x48, 0x00, 0x00, 0xb0, 0x00, 0x00, 0xb0, 0x00, 0x00, 0xb0, 0x00,
   0x00, 0x70, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x78, 0x00, 0x00, 0x70, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00,
   0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x70, 0x00},
{
   0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x7c, 0x00, 0x00,
   0xfc, 0x36, 0x00, 0xdc, 0x4f, 0x00, 0x9c, 0x4f, 0x00, 0x00, 0x4f, 0x00,
   0x00, 0x0e, 0x00, 0x00, 0x1e, 0x00, 0x00, 0xfe, 0x03, 0x00, 0xfe, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
},

{
{
   0x00, 0x30, 0x00, 0x00, 0x78, 0x00, 0x00, 0x78, 0x00, 0x00, 0x30, 0x00,
  0x00, 0x48, 0x00, 0x00, 0xb0, 0x00, 0x00, 0xb0, 0x00, 0x00, 0xb0, 0x00,
   0x00, 0x70, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x78, 0x00, 0x00, 0x70, 0x00, 0x00, 0xf0, 0x00, 0x00, 0xf0, 0x00,
   0x00, 0xd8, 0x00, 0x00, 0xd8, 0x00, 0x00, 0xd8, 0x01, 0x00, 0x38, 0x00},
{
   0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x7c, 0x00, 0x00,
   0xfc, 0x36, 0x00, 0xdc, 0x4f, 0x00, 0x9c, 0x4f, 0x00, 0x00, 0x4f, 0x00,
   0x00, 0x0e, 0x00, 0x00, 0x1e, 0x00, 0x00, 0xfe, 0x03, 0x00, 0xfe, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
},

{
{
   0x00, 0x30, 0x00, 0x00, 0x78, 0x00, 0x00, 0x78, 0x00, 0x00, 0x30, 0x00,
  0x00, 0x48, 0x00, 0x00, 0xb0, 0x00, 0x00, 0xb0, 0x00, 0x00, 0xb0, 0x00,
   0x00, 0x70, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x78, 0x00, 0x00, 0xd8, 0x00, 0x00, 0xd8, 0x00, 0x00, 0xd8, 0x01,
   0x00, 0x8c, 0x01, 0x00, 0x8c, 0x01, 0x00, 0x8c, 0x03, 0x00, 0x1c, 0x00},
{
   0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x7c, 0x00, 0x00,
   0xfc, 0x36, 0x00, 0xdc, 0x4f, 0x00, 0x9c, 0x4f, 0x00, 0x00, 0x4f, 0x00,
   0x00, 0x0e, 0x00, 0x00, 0x1e, 0x00, 0x00, 0xfe, 0x03, 0x00, 0xfe, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
},

{
{
   0x00, 0x30, 0x00, 0x00, 0x78, 0x00, 0x00, 0x78, 0x00, 0x00, 0x30, 0x00,
  0x00, 0x48, 0x00, 0x00, 0xb0, 0x00, 0x00, 0xb0, 0x00, 0x00, 0xb0, 0x00,
   0x00, 0x70, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x78, 0x00, 0x00, 0xf8, 0x00, 0x00, 0xd8, 0x00, 0x00, 0xd8, 0x00,
   0x00, 0x8c, 0x01, 0x00, 0x8c, 0x01, 0x00, 0x86, 0x01, 0x00, 0x8e, 0x03},
{
   0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x7c, 0x00, 0x00,
   0xfc, 0x36, 0x00, 0xdc, 0x4f, 0x00, 0x9c, 0x4f, 0x00, 0x00, 0x4f, 0x00,
   0x00, 0x0e, 0x00, 0x00, 0x1e, 0x00, 0x00, 0xfe, 0x03, 0x00, 0xfe, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
},

{
{
   0x00, 0x30, 0x00, 0x00, 0x78, 0x00, 0x00, 0x78, 0x00, 0x00, 0x30, 0x00,
  0x00, 0x48, 0x00, 0x00, 0xb0, 0x00, 0x00, 0xb0, 0x00, 0x00, 0xb0, 0x00,
   0x00, 0x70, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x78, 0x00, 0x00, 0xf8, 0x00, 0x00, 0xd8, 0x00, 0x00, 0xcc, 0x00,
   0x00, 0xc6, 0x00, 0x00, 0xc3, 0x00, 0x00, 0xc6, 0x00, 0x00, 0xc0, 0x01},
{
   0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x7c, 0x00, 0x00,
   0xfc, 0x36, 0x00, 0xdc, 0x4f, 0x00, 0x9c, 0x4f, 0x00, 0x00, 0x4f, 0x00,
   0x00, 0x0e, 0x00, 0x00, 0x1e, 0x00, 0x00, 0xfe, 0x03, 0x00, 0xfe, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
},

{
{
   0x00, 0x30, 0x00, 0x00, 0x78, 0x00, 0x00, 0x78, 0x00, 0x00, 0x30, 0x00,
  0x00, 0x48, 0x00, 0x00, 0xb0, 0x00, 0x00, 0xb0, 0x00, 0x00, 0xb0, 0x00,
   0x00, 0x70, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x78, 0x00, 0x00, 0x78, 0x00, 0x00, 0x70, 0x00, 0x00, 0xf0, 0x00,
   0x00, 0x78, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x6c, 0x00, 0x00, 0xf8, 0x00},
{
   0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x7c, 0x00, 0x00,
   0xfc, 0x36, 0x00, 0xdc, 0x4f, 0x00, 0x9c, 0x4f, 0x00, 0x00, 0x4f, 0x00,
   0x00, 0x0e, 0x00, 0x00, 0x1e, 0x00, 0x00, 0xfe, 0x03, 0x00, 0xfe, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
},


{
{
   0x00, 0x30, 0x00, 0x00, 0x78, 0x00, 0x00, 0x78, 0x00, 0x00, 0x30, 0x00,
   0x00, 0x48, 0x00, 0x00, 0xb0, 0x00, 0x00, 0xb0, 0x00, 0x00, 0xb0, 0x00,
   0x00, 0x70, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x78, 0x00, 0x00, 0x70, 0x00, 0x00, 0x70, 0x00, 0x00, 0x30, 0x00,
   0x00, 0x38, 0x00, 0x00, 0x18, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x3c, 0x00},
{
   0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x7c, 0x00, 0x00,
   0xfc, 0x36, 0x00, 0xdc, 0x4f, 0x00, 0x9c, 0x4f, 0x00, 0x00, 0x4f, 0x00,
   0x00, 0x0e, 0x00, 0x00, 0x1e, 0x00, 0x00, 0xfe, 0x03, 0x00, 0xfe, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
}
};

static char sweeper_bits[SWEEPERPHASES][SWEEPERPARTS][60] = {
{
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00,
   0x20, 0x4f, 0x00, 0xe0, 0x7d, 0x00, 0xe0, 0x7f, 0x00, 0x20, 0x4f, 0x00,
   0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{
   0x21, 0x22, 0x02, 0x22, 0x22, 0x02, 0xfc, 0xff, 0x03, 0x0c, 0x00, 0x03,
   0x04, 0x00, 0x0e, 0x07, 0x00, 0x02, 0x04, 0x00, 0x02, 0x04, 0x00, 0x02,
   0x04, 0x00, 0x0e, 0x07, 0x00, 0x02, 0x04, 0x00, 0x02, 0x04, 0x00, 0x02,
   0x04, 0x00, 0x0e, 0x07, 0x00, 0x02, 0x04, 0x00, 0x02, 0x04, 0x00, 0x02,
   0x0c, 0x00, 0x0f, 0xff, 0xff, 0x03, 0x10, 0x11, 0x01, 0x10, 0x11, 0x01},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xe0, 0x00,
   0xc8, 0x10, 0x01, 0xa8, 0xf0, 0x01, 0x98, 0x10, 0x01, 0x70, 0xe0, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x70, 0xe0, 0x00, 0xa8, 0x30, 0x01, 0xa8, 0x50, 0x01, 0xa8, 0x90, 0x01,
   0x70, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
},
{
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00,
   0x20, 0x4f, 0x00, 0xe0, 0x7b, 0x00, 0xe0, 0x7f, 0x00, 0x20, 0x4f, 0x00,
   0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{
   0x44, 0x44, 0x08, 0x44, 0x44, 0x04, 0xfc, 0xff, 0x03, 0x0c, 0x00, 0x03,
   0x07, 0x00, 0x02, 0x04, 0x00, 0x0e, 0x04, 0x00, 0x02, 0x04, 0x00, 0x02,
   0x07, 0x00, 0x02, 0x04, 0x00, 0x0e, 0x04, 0x00, 0x02, 0x04, 0x00, 0x02,
   0x07, 0x00, 0x02, 0x04, 0x00, 0x0e, 0x04, 0x00, 0x02, 0x04, 0x00, 0x02,
   0x0f, 0x00, 0x03, 0xfc, 0xff, 0x0f, 0x88, 0x88, 0x00, 0x88, 0x88, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xe0, 0x00,
   0x88, 0x30, 0x01, 0xf8, 0x50, 0x01, 0x88, 0x90, 0x01, 0x70, 0xe0, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x70, 0xe0, 0x00, 0xc8, 0x50, 0x01, 0xa8, 0x50, 0x01, 0x98, 0x50, 0x01,
   0x70, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
},
{
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00,
   0x20, 0x4f, 0x00, 0xe0, 0x7f, 0x00, 0xe0, 0x7b, 0x00, 0x20, 0x4f, 0x00,
   0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{
   0x88, 0x88, 0x00, 0x88, 0x88, 0x00, 0xfc, 0xff, 0x0f, 0x0f, 0x00, 0x03,
   0x04, 0x00, 0x02, 0x04, 0x00, 0x02, 0x04, 0x00, 0x0e, 0x07, 0x00, 0x02,
   0x04, 0x00, 0x02, 0x04, 0x00, 0x02, 0x04, 0x00, 0x0e, 0x07, 0x00, 0x02,
   0x04, 0x00, 0x02, 0x04, 0x00, 0x02, 0x04, 0x00, 0x0e, 0x07, 0x00, 0x02,
   0x0c, 0x00, 0x03, 0xfc, 0xff, 0x03, 0x44, 0x44, 0x04, 0x44, 0x44, 0x08},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xe0, 0x00,
   0x98, 0x50, 0x01, 0xa8, 0x50, 0x01, 0xc8, 0x50, 0x01, 0x70, 0xe0, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x70, 0xe0, 0x00, 0x88, 0x90, 0x01, 0xf8, 0x50, 0x01, 0x88, 0x30, 0x01,
   0x70, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
},
{
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00,
   0x20, 0x4f, 0x00, 0xe0, 0x7f, 0x00, 0xe0, 0x7d, 0x00, 0x20, 0x4f, 0x00,
   0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{
   0x10, 0x11, 0x01, 0x10, 0x11, 0x01, 0xff, 0xff, 0x03, 0x0c, 0x00, 0x0f,
   0x04, 0x00, 0x02, 0x04, 0x00, 0x02, 0x07, 0x00, 0x02, 0x04, 0x00, 0x0e,
   0x04, 0x00, 0x02, 0x04, 0x00, 0x02, 0x07, 0x00, 0x02, 0x04, 0x00, 0x0e,
   0x04, 0x00, 0x02, 0x04, 0x00, 0x02, 0x07, 0x00, 0x02, 0x04, 0x00, 0x0e,
   0x0c, 0x00, 0x03, 0xfc, 0xff, 0x03, 0x22, 0x22, 0x02, 0x21, 0x22, 0x02},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xe0, 0x00,
   0xa8, 0x90, 0x01, 0xa8, 0x50, 0x01, 0xa8, 0x30, 0x01, 0x70, 0xe0, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x70, 0xe0, 0x00, 0x98, 0x10, 0x01, 0xa8, 0xf0, 0x01, 0xc8, 0x10, 0x01,
   0x70, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
}
};

static char door_bits[DOORFRAMES][DOORPARTS][120] =  {
{
{
   0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0x0f,
   0xfc, 0x01, 0xf0, 0x07, 0xa8, 0x00, 0xa0, 0x02, 0xa8, 0xff, 0xbf, 0x02,
   0xa8, 0x40, 0xa0, 0x02, 0xa8, 0x40, 0xa0, 0x02, 0xa8, 0x40, 0xa0, 0x02,
   0xa8, 0x40, 0xa0, 0x02, 0xa8, 0x40, 0xa0, 0x02, 0xa8, 0x40, 0xa0, 0x02,
   0xa8, 0x40, 0xa0, 0x02, 0xa8, 0x40, 0xa0, 0x02, 0xa8, 0x40, 0xa0, 0x02,
   0xa8, 0xe0, 0xa0, 0x02, 0xa8, 0xf0, 0xa1, 0x02, 0xa8, 0xb0, 0xa1, 0x02,
   0xa8, 0xb0, 0xa1, 0x02, 0xa8, 0xf0, 0xa1, 0x02, 0xa8, 0xe0, 0xa0, 0x02,
   0xa8, 0x40, 0xa0, 0x02, 0xa8, 0x40, 0xa0, 0x02, 0xa8, 0x40, 0xa0, 0x02,
   0xa8, 0x40, 0xa0, 0x02, 0xa8, 0x40, 0xa0, 0x02, 0xa8, 0x40, 0xa0, 0x02,
   0xa8, 0x40, 0xa0, 0x02, 0xfc, 0x41, 0xf0, 0x07, 0xfe, 0xff, 0xff, 0x0f},
},
{
{
   0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0x0f,
   0xfc, 0x01, 0xf0, 0x07, 0xa8, 0x00, 0xa0, 0x02, 0xa8, 0xff, 0xbf, 0x02,
   0xa8, 0x40, 0xa0, 0x02, 0xa8, 0x40, 0xa0, 0x02, 0xa8, 0x40, 0xa0, 0x02,
   0xa8, 0x40, 0xa0, 0x02, 0xa8, 0x40, 0xa0, 0x02, 0xa8, 0x40, 0xa0, 0x02,
   0xa8, 0x40, 0xa0, 0x02, 0xa8, 0x40, 0xa0, 0x02, 0xa8, 0x40, 0xa0, 0x02,
   0xa8, 0xe0, 0xa0, 0x02, 0xa8, 0xf0, 0xa1, 0x02, 0xa8, 0xb0, 0xa1, 0x02,
   0xa8, 0xb0, 0xa1, 0x02, 0xa8, 0xf0, 0xa1, 0x02, 0xa8, 0xe0, 0xa0, 0x02,
   0xa8, 0x40, 0xa0, 0x02, 0xa8, 0x40, 0xa0, 0x02, 0xa8, 0x40, 0xa0, 0x02,
   0xa8, 0x40, 0xa0, 0x02, 0xa8, 0x40, 0xa0, 0x02, 0xa8, 0x40, 0xa0, 0x02,
   0xa8, 0x40, 0xa0, 0x02, 0xfc, 0x41, 0xf0, 0x07, 0xfe, 0xff, 0xff, 0x0f},
},
};

static char extraman_bits[] = {
   0x60, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0x60, 0x00, 0xf0, 0x00, 0xfc, 0x03,
   0xfe, 0x07, 0xff, 0x0f, 0xfb, 0x0d, 0xf3, 0x0c, 0xf3, 0x0c, 0xf2, 0x04,
   0xf8, 0x01, 0x98, 0x01, 0x98, 0x01, 0x98, 0x01, 0x08, 0x01, 0x98, 0x01,
   0x98, 0x01, 0x9c, 0x03};

static char fuel_bits[FUELPARTS][60] = {
{
   0xfc, 0xff, 0x03, 0xfe, 0xff, 0x07, 0x47, 0x45, 0x0f, 0x77, 0x75, 0x0f,
   0x67, 0x65, 0x0f, 0x77, 0x75, 0x0f, 0x77, 0x44, 0x0c, 0xfe, 0xff, 0x07,
   0xfc, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xba, 0x00, 0x88, 0x8a, 0x00,
   0x98, 0x9a, 0x00, 0x88, 0x8a, 0x00, 0x88, 0xbb, 0x03, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x80, 0x03,
   0x00, 0x00, 0x06, 0x00, 0x10, 0x04, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xe0, 0x81, 0x00, 0x18, 0x46, 0x00,
   0x04, 0x38, 0x00, 0x04, 0x00, 0x00, 0x04, 0x68, 0x00, 0x04, 0x76, 0x00,
   0x08, 0x71, 0x00, 0x88, 0x48, 0x00, 0x90, 0x48, 0x00, 0x60, 0x38, 0x00},
};

#define	SKELWIDTH	20
#define	SKELHEIGHT	20
static char skel_bits[EXPLODEFRAMES][60] = {
{
   0x00, 0x06, 0x00, 0x00, 0x09, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00,
   0x80, 0x19, 0x00, 0x40, 0x26, 0x00, 0x20, 0x49, 0x00, 0xa0, 0x56, 0x00,
   0x20, 0x46, 0x00, 0xa0, 0x59, 0x00, 0xa0, 0x56, 0x00, 0x00, 0x09, 0x00,
   0x80, 0x16, 0x00, 0x80, 0x10, 0x00, 0x80, 0x10, 0x00, 0x40, 0x29, 0x00,
   0x80, 0x10, 0x00, 0x80, 0x10, 0x00, 0x80, 0x10, 0x00, 0x40, 0x29, 0x00},
{
   0x00, 0x06, 0x00, 0x00, 0x09, 0x00, 0x00, 0x06, 0x00, 0x00, 0x0e, 0x00,
   0x00, 0x51, 0x00, 0x40, 0x86, 0x00, 0x00, 0x89, 0x00, 0xa0, 0x96, 0x00,
   0x20, 0x86, 0x00, 0x90, 0x99, 0x00, 0x90, 0x16, 0x00, 0x10, 0x09, 0x00,
   0x80, 0x16, 0x00, 0x80, 0x10, 0x00, 0x60, 0x10, 0x00, 0x40, 0x1d, 0x00,
   0x80, 0x18, 0x00, 0x80, 0x20, 0x00, 0x80, 0xc0, 0x00, 0x40, 0x42, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x09, 0x00, 0x00, 0x96, 0x00,
   0x10, 0x26, 0x01, 0x80, 0x00, 0x01, 0x00, 0x13, 0x00, 0x80, 0x2c, 0x01,
   0x40, 0x0c, 0x02, 0x90, 0x01, 0x04, 0x88, 0x1a, 0x00, 0x08, 0x15, 0x00,
   0x48, 0x0a, 0x00, 0x20, 0x14, 0x00, 0x10, 0x10, 0x00, 0x80, 0x12, 0x00,
   0x00, 0x19, 0x00, 0x80, 0x20, 0x00, 0x80, 0xe0, 0x01, 0x40, 0x84, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x01, 0x08, 0x29, 0x02,
   0x00, 0x46, 0x02, 0x80, 0x06, 0x00, 0x00, 0x58, 0x00, 0x80, 0x59, 0x00,
   0x40, 0x00, 0x00, 0x20, 0x00, 0x0e, 0xc8, 0x00, 0x00, 0x44, 0x19, 0x00,
   0x84, 0x14, 0x00, 0x04, 0x09, 0x00, 0x38, 0x14, 0x00, 0x00, 0x10, 0x00,
   0x00, 0x11, 0x00, 0x00, 0x1b, 0x00, 0x80, 0x00, 0x02, 0x60, 0xc0, 0x01},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x04, 0x08, 0x06, 0x00,
   0x00, 0x89, 0x00, 0x00, 0x04, 0x01, 0x80, 0x36, 0x00, 0x00, 0x30, 0x01,
   0xc0, 0x80, 0x00, 0x20, 0x00, 0x08, 0x00, 0x00, 0x04, 0xc4, 0x00, 0x00,
   0x42, 0x19, 0x00, 0x82, 0x14, 0x00, 0x00, 0x09, 0x00, 0x08, 0x10, 0x00,
   0x10, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x1b, 0x00, 0x20, 0x00, 0x01},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x04, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x05, 0x02, 0x00, 0x0c, 0x00,
   0x00, 0x64, 0x00, 0x20, 0x00, 0x01, 0x10, 0x00, 0x08, 0x00, 0x00, 0x00,
   0x42, 0x00, 0x00, 0xa1, 0x08, 0x00, 0x40, 0x10, 0x00, 0x00, 0x00, 0x00,
   0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x0d, 0x00,
   0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x08, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0x00, 0x00, 0x00, 0x10, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x18, 0x00, 0x00, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
};

static char explode_bits[EXPLODEFRAMES][120] = {
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x60, 0x03, 0x00, 0x00, 0x98, 0x05, 0x00, 0x00, 0xf8, 0x0f, 0x00,
   0x00, 0xf0, 0x1f, 0x00, 0x00, 0xfc, 0x17, 0x00, 0x00, 0xfe, 0x1f, 0x00,
   0x00, 0xfc, 0x1f, 0x00, 0x00, 0xf8, 0x1f, 0x00, 0x00, 0xf4, 0x07, 0x00,
   0x00, 0xf0, 0x1f, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0x80, 0x01, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
   0x00, 0xe4, 0x1f, 0x00, 0x00, 0xc0, 0x43, 0x00, 0x80, 0xec, 0x3f, 0x00,
   0x80, 0x66, 0x2f, 0x00, 0x40, 0x9b, 0x2f, 0x00, 0x40, 0xf3, 0xce, 0x00,
   0x40, 0x33, 0x9c, 0x00, 0x40, 0xff, 0x37, 0x00, 0x00, 0x6f, 0x9c, 0x00,
   0x00, 0xfb, 0x3f, 0x00, 0x00, 0xbf, 0x7a, 0x00, 0x00, 0xf5, 0x37, 0x00,
   0x00, 0xf1, 0x7f, 0x00, 0x80, 0xd6, 0x54, 0x00, 0x00, 0x4c, 0x65, 0x00,
   0x00, 0xf8, 0x1f, 0x00, 0x00, 0xe0, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x00, 0x00, 0xd8, 0x0f, 0x00, 0x00, 0x0f, 0x18, 0x00,
   0x80, 0xe5, 0x3f, 0x00, 0x60, 0xc0, 0x43, 0x00, 0x80, 0xec, 0x3f, 0x00,
   0xa0, 0x06, 0x2f, 0x05, 0x60, 0x03, 0xaa, 0x01, 0x60, 0x13, 0xc0, 0x01,
   0x60, 0xc3, 0x94, 0x01, 0x40, 0xcb, 0x34, 0x01, 0x10, 0xc3, 0x90, 0x01,
   0x00, 0x13, 0x3a, 0x00, 0x20, 0x8f, 0x78, 0x00, 0x20, 0x01, 0x34, 0x02,
   0xc0, 0x01, 0x7f, 0x02, 0x80, 0x16, 0x54, 0x00, 0x00, 0x4d, 0x65, 0x01,
   0x00, 0xf9, 0x1f, 0x01, 0x40, 0xe1, 0x11, 0x00, 0x80, 0x01, 0x80, 0x00,
   0x00, 0x8b, 0x80, 0x00, 0x00, 0x40, 0x64, 0x00, 0x00, 0x00, 0x0c, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x01, 0x00, 0x00, 0x40, 0x0c, 0x00,
   0xc0, 0x34, 0xc1, 0x00, 0xf0, 0xda, 0x0f, 0x00, 0x10, 0x00, 0x18, 0x00,
   0x90, 0x84, 0x33, 0x01, 0x74, 0x78, 0x42, 0x01, 0x84, 0x8c, 0x1f, 0x02,
   0xa0, 0x01, 0x2c, 0x06, 0x64, 0x01, 0xac, 0x00, 0x60, 0x98, 0x4c, 0x08,
   0x64, 0xf8, 0x11, 0x08, 0x40, 0xfa, 0x25, 0x09, 0x10, 0xf2, 0xd1, 0x08,
   0x42, 0xb2, 0x93, 0x00, 0xa2, 0xe9, 0x80, 0x00, 0xa4, 0x61, 0x24, 0x02,
   0xc0, 0x00, 0x67, 0x0a, 0x98, 0x16, 0x40, 0x08, 0x90, 0x0d, 0x60, 0x09,
   0x00, 0xb9, 0x15, 0x08, 0x40, 0xa0, 0x49, 0x0b, 0xa0, 0x03, 0x03, 0x00,
   0x20, 0x87, 0x80, 0x10, 0x20, 0x50, 0x64, 0x0f, 0x80, 0x00, 0xec, 0x04,
   0x00, 0x0d, 0x0c, 0x00, 0x00, 0xf8, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00},
{
   0x20, 0x0b, 0x2b, 0x00, 0x10, 0xf0, 0x01, 0x05, 0x04, 0x40, 0x0c, 0x04,
   0xc4, 0x20, 0xc1, 0x00, 0x83, 0x10, 0x00, 0x10, 0x10, 0x00, 0x1e, 0x10,
   0x00, 0xbe, 0x23, 0x21, 0xc4, 0x01, 0x22, 0x00, 0x81, 0x00, 0xdc, 0x00,
   0xb1, 0x09, 0xa1, 0x25, 0x66, 0x20, 0x25, 0x01, 0x20, 0xfc, 0x44, 0x00,
   0x21, 0xfe, 0x07, 0x09, 0x40, 0xfe, 0x06, 0x21, 0x10, 0x0e, 0xd3, 0x01,
   0x42, 0x3e, 0x97, 0x09, 0xa3, 0xfe, 0x82, 0x21, 0xb1, 0xf4, 0x23, 0x29,
   0xe1, 0xb4, 0xa7, 0x08, 0xc0, 0x88, 0x03, 0x08, 0x80, 0xc0, 0x80, 0x00,
   0x01, 0x0b, 0x80, 0x00, 0x41, 0x20, 0x70, 0x23, 0x01, 0x03, 0x6f, 0x00,
   0x21, 0xfe, 0x39, 0x00, 0x22, 0x58, 0x05, 0x0e, 0x80, 0x00, 0xc0, 0x14,
   0x10, 0x0d, 0x0c, 0x1c, 0x60, 0xf8, 0x01, 0x03, 0x00, 0x1c, 0x71, 0x01},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x01, 0x20, 0x8a, 0x18, 0x00,
   0xb0, 0x21, 0xc1, 0x01, 0x90, 0x10, 0x00, 0x04, 0x10, 0x00, 0x18, 0x08,
   0x00, 0xb8, 0x23, 0x11, 0x0c, 0x3b, 0x22, 0x08, 0x84, 0x61, 0x1f, 0x08,
   0x30, 0x08, 0x39, 0x0d, 0x64, 0x20, 0x24, 0x04, 0x20, 0x8b, 0x40, 0x08,
   0x20, 0xf5, 0x00, 0x01, 0x02, 0x61, 0x40, 0x09, 0x12, 0xf9, 0xf1, 0x00,
   0x04, 0xe8, 0x31, 0x08, 0x20, 0x01, 0x24, 0x00, 0xb2, 0x1d, 0x37, 0x08,
   0xe4, 0x9e, 0x33, 0x08, 0xc4, 0xe0, 0x03, 0x08, 0x82, 0xc0, 0x80, 0x00,
   0x04, 0x0a, 0x80, 0x00, 0x44, 0x00, 0x70, 0x1b, 0x00, 0x00, 0x6f, 0x00,
   0x29, 0xfe, 0x39, 0x00, 0x20, 0x58, 0x05, 0x0e, 0x80, 0x00, 0xc0, 0x06,
   0x90, 0x0d, 0x2c, 0x04, 0xc0, 0x6f, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00},
{
   0x70, 0x36, 0x02, 0x00, 0x08, 0x40, 0x70, 0x01, 0x0c, 0x08, 0x10, 0x00,
   0x10, 0x36, 0x00, 0x00, 0x81, 0x63, 0x19, 0x04, 0xe0, 0x00, 0x58, 0x18,
   0x30, 0x10, 0x00, 0x11, 0x01, 0x20, 0x00, 0x00, 0x00, 0x90, 0x80, 0x01,
   0x00, 0x06, 0x08, 0x01, 0x08, 0xe0, 0x06, 0x1a, 0x29, 0xe9, 0x01, 0x02,
   0x20, 0xf8, 0x0a, 0x03, 0x01, 0xfb, 0x17, 0x05, 0x15, 0xff, 0xba, 0x00,
   0x08, 0xf8, 0x03, 0x36, 0x00, 0x68, 0x0e, 0x00, 0xa1, 0x6c, 0x24, 0x00,
   0x35, 0xd0, 0x00, 0x02, 0x02, 0x88, 0x23, 0x22, 0xc0, 0x00, 0x00, 0x22,
   0x04, 0x62, 0x87, 0x22, 0xc0, 0x00, 0x30, 0x00, 0x83, 0x01, 0x30, 0x10,
   0x04, 0x7a, 0x18, 0x10, 0x00, 0x00, 0x00, 0x1c, 0x90, 0x00, 0x00, 0x0c,
   0x20, 0x00, 0x02, 0x07, 0x80, 0x68, 0x24, 0x00, 0x00, 0x01, 0x00, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xa8, 0x71, 0x00,
   0x10, 0x00, 0x40, 0x00, 0x08, 0x00, 0x00, 0x02, 0x04, 0x04, 0x00, 0x06,
   0x04, 0xd8, 0x02, 0x01, 0x00, 0x02, 0x16, 0x04, 0x00, 0x03, 0x00, 0x00,
   0x40, 0xea, 0x20, 0x08, 0xc0, 0x0c, 0x00, 0x00, 0x86, 0x04, 0x44, 0x00,
   0x04, 0x70, 0x04, 0x10, 0x40, 0xf8, 0x85, 0x10, 0x42, 0x70, 0xa1, 0x00,
   0x04, 0xf2, 0x91, 0x00, 0x40, 0x52, 0x00, 0x18, 0x40, 0x00, 0x83, 0x00,
   0x08, 0x30, 0x60, 0x00, 0x04, 0x80, 0x63, 0x10, 0x88, 0x00, 0x00, 0x00,
   0x80, 0x62, 0x07, 0x08, 0x00, 0x87, 0x03, 0x00, 0x10, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x03, 0x60, 0x00, 0x40, 0x00, 0x40, 0x0c, 0x64, 0x00,
   0x00, 0x61, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
   0x80, 0x44, 0x02, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x30, 0x40, 0x80, 0x01, 0x00, 0x01, 0x80, 0x00, 0x04, 0x01, 0x08, 0x00,
   0x04, 0x00, 0x00, 0x02, 0x00, 0x14, 0x20, 0x00, 0x00, 0x84, 0x00, 0x00,
   0x00, 0x00, 0x04, 0x04, 0x20, 0x00, 0x00, 0x00, 0x02, 0x02, 0x44, 0x04,
   0x02, 0x00, 0x40, 0x08, 0x00, 0x18, 0x00, 0x00, 0xc0, 0x00, 0x01, 0x00,
   0x00, 0x10, 0x01, 0x04, 0x02, 0x00, 0x10, 0x00, 0x04, 0x02, 0x10, 0x00,
   0x00, 0x00, 0x00, 0x06, 0x00, 0x40, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x63, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x08, 0x00, 0x00, 0x20, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x00, 0x00,
   0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
};

static char guard_bits[GUARDPARTS][63] = {
{
   0x00, 0x00, 0x00, 0x82, 0x20, 0x08, 0xe4, 0xf1, 0x04, 0xf8, 0xff, 0x03,
   0xe8, 0xff, 0x02, 0xfc, 0xe0, 0x07, 0xfc, 0xf1, 0x07, 0xfe, 0xff, 0x0f,
   0xdc, 0x7f, 0x07, 0x98, 0x35, 0x03, 0x98, 0x3f, 0x03, 0x98, 0x35, 0x03,
   0xdc, 0x7f, 0x07, 0xfe, 0xff, 0x0f, 0xfc, 0xf1, 0x07, 0xfc, 0xe0, 0x07,
   0xe8, 0xff, 0x02, 0xf8, 0xff, 0x03, 0xe4, 0xf1, 0x04, 0x82, 0x20, 0x08,
   0x00, 0x00, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00,
   0x20, 0x80, 0x00, 0x60, 0xc0, 0x00, 0x60, 0xc0, 0x00, 0x60, 0xc0, 0x00,
   0x20, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x1f, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00},
};

static char guard_flame_bits[GUARDDIRECTIONS][GUARDFLAMEPARTS][63] = {
{
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x0e, 0x00,
   0x00, 0x04, 0x00},
},
{
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x03, 0x00, 0x00, 0x06, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00},
},
{
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00},
{
   0x00, 0x04, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00},
},
{
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x18, 0x00, 0x00, 0x0c,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00},
},
};

static char guard_light_bits[GUARDLIGHTS][63] = {
{
   0x01, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x01, 0x00, 0x10},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x10, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x10, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00},
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00},
};
