/*
	Netvideo version 3.3
	Written by Ron Frederick <frederick@parc.xerox.com>

	CU_SeeMe decode routines
*/

/*
 * Copyright (c) Xerox Corporation 1992. All rights reserved.
 *  
 * License is granted to copy, to use, and to make and to use derivative
 * works for research and evaluation purposes, provided that Xerox is
 * acknowledged in all documentation pertaining to any such copy or derivative
 * work. Xerox grants no other licenses expressed or implied. The Xerox trade
 * name should not be used in any advertising without its written permission.
 *  
 * XEROX CORPORATION MAKES NO REPRESENTATIONS CONCERNING EITHER THE
 * MERCHANTABILITY OF THIS SOFTWARE OR THE SUITABILITY OF THIS SOFTWARE
 * FOR ANY PARTICULAR PURPOSE.  The software is provided "as is" without
 * express or implied warranty of any kind.
 *  
 * These notices must be retained in any copies of any part of this software.
 */

#include <sys/types.h>
#include "sized_types.h"
#include "vid_image.h"
#include "vid_code.h"
#include "cuseeme.h"

static int16 intraRowBytes[16] =
  { -1,
    -1, 0, 1,
    -1, 0, 1,
    -1, 0, 1,
    -1, 0, 1,
    -1, 0, 1 };

static int32 interRowDiff[16] =
  { 0x00000000,
    0xDDDDDDDE, 0xEEEEEEEF, 0x00000000,
    0xEEEEEEEF, 0x00000000, 0x11111111,
    0x00000000, 0x11111111, 0x22222222,
    0x11111111, 0x22222222, 0x33333333,
    0x22222222, 0x33333333, 0x44444444 };

static uint16 wordDiff[256] =
  { 0x0000, 0x0001, 0x0002, 0x0003, 0x0010, 0x0011, 0x0012, 0x0013,
    0x0020, 0x0021, 0x0022, 0x0023, 0x0030, 0x0031, 0x0032, 0x0033,
    0x0100, 0x0101, 0x0102, 0x0103, 0x0110, 0x0111, 0x0112, 0x0113,
    0x0120, 0x0121, 0x0122, 0x0123, 0x0130, 0x0131, 0x0132, 0x0133,
    0x0200, 0x0201, 0x0202, 0x0203, 0x0210, 0x0211, 0x0212, 0x0213,
    0x0220, 0x0221, 0x0222, 0x0223, 0x0230, 0x0231, 0x0232, 0x0233,
    0x0300, 0x0301, 0x0302, 0x0303, 0x0310, 0x0311, 0x0312, 0x0313,
    0x0320, 0x0321, 0x0322, 0x0323, 0x0330, 0x0331, 0x0332, 0x0333,
    0x1000, 0x1001, 0x1002, 0x1003, 0x1010, 0x1011, 0x1012, 0x1013,
    0x1020, 0x1021, 0x1022, 0x1023, 0x1030, 0x1031, 0x1032, 0x1033,
    0x1100, 0x1101, 0x1102, 0x1103, 0x1110, 0x1111, 0x1112, 0x1113,
    0x1120, 0x1121, 0x1122, 0x1123, 0x1130, 0x1131, 0x1132, 0x1133,
    0x1200, 0x1201, 0x1202, 0x1203, 0x1210, 0x1211, 0x1212, 0x1213,
    0x1220, 0x1221, 0x1222, 0x1223, 0x1230, 0x1231, 0x1232, 0x1233,
    0x1300, 0x1301, 0x1302, 0x1303, 0x1310, 0x1311, 0x1312, 0x1313,
    0x1320, 0x1321, 0x1322, 0x1323, 0x1330, 0x1331, 0x1332, 0x1333,
    0x2000, 0x2001, 0x2002, 0x2003, 0x2010, 0x2011, 0x2012, 0x2013,
    0x2020, 0x2021, 0x2022, 0x2023, 0x2030, 0x2031, 0x2032, 0x2033,
    0x2100, 0x2101, 0x2102, 0x2103, 0x2110, 0x2111, 0x2112, 0x2113,
    0x2120, 0x2121, 0x2122, 0x2123, 0x2130, 0x2131, 0x2132, 0x2133,
    0x2200, 0x2201, 0x2202, 0x2203, 0x2210, 0x2211, 0x2212, 0x2213,
    0x2220, 0x2221, 0x2222, 0x2223, 0x2230, 0x2231, 0x2232, 0x2233,
    0x2300, 0x2301, 0x2302, 0x2303, 0x2310, 0x2311, 0x2312, 0x2313,
    0x2320, 0x2321, 0x2322, 0x2323, 0x2330, 0x2331, 0x2332, 0x2333,
    0x3000, 0x3001, 0x3002, 0x3003, 0x3010, 0x3011, 0x3012, 0x3013,
    0x3020, 0x3021, 0x3022, 0x3023, 0x3030, 0x3031, 0x3032, 0x3033,
    0x3100, 0x3101, 0x3102, 0x3103, 0x3110, 0x3111, 0x3112, 0x3113,
    0x3120, 0x3121, 0x3122, 0x3123, 0x3130, 0x3131, 0x3132, 0x3133,
    0x3200, 0x3201, 0x3202, 0x3203, 0x3210, 0x3211, 0x3212, 0x3213,
    0x3220, 0x3221, 0x3222, 0x3223, 0x3230, 0x3231, 0x3232, 0x3233,
    0x3300, 0x3301, 0x3302, 0x3303, 0x3310, 0x3311, 0x3312, 0x3313,
    0x3320, 0x3321, 0x3322, 0x3323, 0x3330, 0x3331, 0x3332, 0x3333 };

static uint32 longDiff[256] =
  { 0x00000000, 0x00000001, 0x00000010, 0x00000011,
    0x00000100, 0x00000101, 0x00000110, 0x00000111,
    0x00001000, 0x00001001, 0x00001010, 0x00001011,
    0x00001100, 0x00001101, 0x00001110, 0x00001111,
    0x00010000, 0x00010001, 0x00010010, 0x00010011,
    0x00010100, 0x00010101, 0x00010110, 0x00010111,
    0x00011000, 0x00011001, 0x00011010, 0x00011011,
    0x00011100, 0x00011101, 0x00011110, 0x00011111,
    0x00100000, 0x00100001, 0x00100010, 0x00100011,
    0x00100100, 0x00100101, 0x00100110, 0x00100111,
    0x00101000, 0x00101001, 0x00101010, 0x00101011,
    0x00101100, 0x00101101, 0x00101110, 0x00101111,
    0x00110000, 0x00110001, 0x00110010, 0x00110011,
    0x00110100, 0x00110101, 0x00110110, 0x00110111,
    0x00111000, 0x00111001, 0x00111010, 0x00111011,
    0x00111100, 0x00111101, 0x00111110, 0x00111111,
    0x01000000, 0x01000001, 0x01000010, 0x01000011,
    0x01000100, 0x01000101, 0x01000110, 0x01000111,
    0x01001000, 0x01001001, 0x01001010, 0x01001011,
    0x01001100, 0x01001101, 0x01001110, 0x01001111,
    0x01010000, 0x01010001, 0x01010010, 0x01010011,
    0x01010100, 0x01010101, 0x01010110, 0x01010111,
    0x01011000, 0x01011001, 0x01011010, 0x01011011,
    0x01011100, 0x01011101, 0x01011110, 0x01011111,
    0x01100000, 0x01100001, 0x01100010, 0x01100011,
    0x01100100, 0x01100101, 0x01100110, 0x01100111,
    0x01101000, 0x01101001, 0x01101010, 0x01101011,
    0x01101100, 0x01101101, 0x01101110, 0x01101111,
    0x01110000, 0x01110001, 0x01110010, 0x01110011,
    0x01110100, 0x01110101, 0x01110110, 0x01110111,
    0x01111000, 0x01111001, 0x01111010, 0x01111011,
    0x01111100, 0x01111101, 0x01111110, 0x01111111,
    0x10000000, 0x10000001, 0x10000010, 0x10000011,
    0x10000100, 0x10000101, 0x10000110, 0x10000111,
    0x10001000, 0x10001001, 0x10001010, 0x10001011,
    0x10001100, 0x10001101, 0x10001110, 0x10001111,
    0x10010000, 0x10010001, 0x10010010, 0x10010011,
    0x10010100, 0x10010101, 0x10010110, 0x10010111,
    0x10011000, 0x10011001, 0x10011010, 0x10011011,
    0x10011100, 0x10011101, 0x10011110, 0x10011111,
    0x10100000, 0x10100001, 0x10100010, 0x10100011,
    0x10100100, 0x10100101, 0x10100110, 0x10100111,
    0x10101000, 0x10101001, 0x10101010, 0x10101011,
    0x10101100, 0x10101101, 0x10101110, 0x10101111,
    0x10110000, 0x10110001, 0x10110010, 0x10110011,
    0x10110100, 0x10110101, 0x10110110, 0x10110111,
    0x10111000, 0x10111001, 0x10111010, 0x10111011,
    0x10111100, 0x10111101, 0x10111110, 0x10111111,
    0x11000000, 0x11000001, 0x11000010, 0x11000011,
    0x11000100, 0x11000101, 0x11000110, 0x11000111,
    0x11001000, 0x11001001, 0x11001010, 0x11001011,
    0x11001100, 0x11001101, 0x11001110, 0x11001111,
    0x11010000, 0x11010001, 0x11010010, 0x11010011,
    0x11010100, 0x11010101, 0x11010110, 0x11010111,
    0x11011000, 0x11011001, 0x11011010, 0x11011011,
    0x11011100, 0x11011101, 0x11011110, 0x11011111,
    0x11100000, 0x11100001, 0x11100010, 0x11100011,
    0x11100100, 0x11100101, 0x11100110, 0x11100111,
    0x11101000, 0x11101001, 0x11101010, 0x11101011,
    0x11101100, 0x11101101, 0x11101110, 0x11101111,
    0x11110000, 0x11110001, 0x11110010, 0x11110011,
    0x11110100, 0x11110101, 0x11110110, 0x11110111,
    0x11111000, 0x11111001, 0x11111010, 0x11111011,
    0x11111100, 0x11111101, 0x11111110, 0x11111111 };

static uint16 cvt4bitTo8bit[256] =
 { 0xffff, 0xffee, 0xffdd, 0xffcc, 0xffbb, 0xffaa, 0xff99, 0xff88,
   0xff77, 0xff66, 0xff55, 0xff44, 0xff33, 0xff22, 0xff11, 0xff00,
   0xeeff, 0xeeee, 0xeedd, 0xeecc, 0xeebb, 0xeeaa, 0xee99, 0xee88,
   0xee77, 0xee66, 0xee55, 0xee44, 0xee33, 0xee22, 0xee11, 0xee00,
   0xddff, 0xddee, 0xdddd, 0xddcc, 0xddbb, 0xddaa, 0xdd99, 0xdd88,
   0xdd77, 0xdd66, 0xdd55, 0xdd44, 0xdd33, 0xdd22, 0xdd11, 0xdd00,
   0xccff, 0xccee, 0xccdd, 0xcccc, 0xccbb, 0xccaa, 0xcc99, 0xcc88,
   0xcc77, 0xcc66, 0xcc55, 0xcc44, 0xcc33, 0xcc22, 0xcc11, 0xcc00,
   0xbbff, 0xbbee, 0xbbdd, 0xbbcc, 0xbbbb, 0xbbaa, 0xbb99, 0xbb88,
   0xbb77, 0xbb66, 0xbb55, 0xbb44, 0xbb33, 0xbb22, 0xbb11, 0xbb00,
   0xaaff, 0xaaee, 0xaadd, 0xaacc, 0xaabb, 0xaaaa, 0xaa99, 0xaa88,
   0xaa77, 0xaa66, 0xaa55, 0xaa44, 0xaa33, 0xaa22, 0xaa11, 0xaa00,
   0x99ff, 0x99ee, 0x99dd, 0x99cc, 0x99bb, 0x99aa, 0x9999, 0x9988,
   0x9977, 0x9966, 0x9955, 0x9944, 0x9933, 0x9922, 0x9911, 0x9900,
   0x88ff, 0x88ee, 0x88dd, 0x88cc, 0x88bb, 0x88aa, 0x8899, 0x8888,
   0x8877, 0x8866, 0x8855, 0x8844, 0x8833, 0x8822, 0x8811, 0x8800,
   0x77ff, 0x77ee, 0x77dd, 0x77cc, 0x77bb, 0x77aa, 0x7799, 0x7788,
   0x7777, 0x7766, 0x7755, 0x7744, 0x7733, 0x7722, 0x7711, 0x7700,
   0x66ff, 0x66ee, 0x66dd, 0x66cc, 0x66bb, 0x66aa, 0x6699, 0x6688,
   0x6677, 0x6666, 0x6655, 0x6644, 0x6633, 0x6622, 0x6611, 0x6600,
   0x55ff, 0x55ee, 0x55dd, 0x55cc, 0x55bb, 0x55aa, 0x5599, 0x5588,
   0x5577, 0x5566, 0x5555, 0x5544, 0x5533, 0x5522, 0x5511, 0x5500,
   0x44ff, 0x44ee, 0x44dd, 0x44cc, 0x44bb, 0x44aa, 0x4499, 0x4488,
   0x4477, 0x4466, 0x4455, 0x4444, 0x4433, 0x4422, 0x4411, 0x4400,
   0x33ff, 0x33ee, 0x33dd, 0x33cc, 0x33bb, 0x33aa, 0x3399, 0x3388,
   0x3377, 0x3366, 0x3355, 0x3344, 0x3333, 0x3322, 0x3311, 0x3300,
   0x22ff, 0x22ee, 0x22dd, 0x22cc, 0x22bb, 0x22aa, 0x2299, 0x2288,
   0x2277, 0x2266, 0x2255, 0x2244, 0x2233, 0x2222, 0x2211, 0x2200,
   0x11ff, 0x11ee, 0x11dd, 0x11cc, 0x11bb, 0x11aa, 0x1199, 0x1188,
   0x1177, 0x1166, 0x1155, 0x1144, 0x1133, 0x1122, 0x1111, 0x1100,
   0x00ff, 0x00ee, 0x00dd, 0x00cc, 0x00bb, 0x00aa, 0x0099, 0x0088,
   0x0077, 0x0066, 0x0055, 0x0044, 0x0033, 0x0022, 0x0011, 0x0000 };

static uint8 *CUSeeMe_DecodeRow(uint16 *ip, uint8 *data, int code,
				uint32 *rowdatap)
{
    int intra;
    uint32 pix, rowdata;

    rowdata = *rowdatap;
    if (code == 0) {
	pix = data[0];
	rowdata = pix << 24;
	ip[0] = cvt4bitTo8bit[pix];
	pix = data[1];
	rowdata += pix << 16;
	ip[1] = cvt4bitTo8bit[pix];
	pix = data[2];
	rowdata += pix << 8;
	ip[2] = cvt4bitTo8bit[pix];
	pix = data[3];
	rowdata += pix;
	ip[3] = cvt4bitTo8bit[pix];
	data += 4;
    } else {
	rowdata -= interRowDiff[code];
	intra = intraRowBytes[code];
	if (intra > 0) {
	    rowdata += (wordDiff[data[0]] << 16) + wordDiff[data[1]];
	    data += 2;
	} else if (intra == 0) {
	    rowdata += longDiff[data[0]];
	    data++;
	}
	ip[0] = cvt4bitTo8bit[rowdata >> 24];
	ip[1] = cvt4bitTo8bit[(rowdata >> 16) & 0xff];
	ip[2] = cvt4bitTo8bit[(rowdata >> 8) & 0xff];
	ip[3] = cvt4bitTo8bit[rowdata & 0xff];
    }

    *rowdatap = rowdata;
    return data;
}

static uint8 *CUSeeMe_DecodeSquare(vidimage_t *image, uint8 *data,
				   uint8 *dataLim)
{
    int x, y, row, code, width=image->width;
    uint8 *codeptr;
    uint16 square, *ip;
    uint32 rowdata;

    if (dataLim-data < 6) return 0;

    square = (data[0] << 8) + data[1];
    if (square > image->height*width/64) return 0;
    data += 2;

    x = square % (width/8);
    y = square / (width/8);
    ip = (uint16 *) &image->y_data[y*8*width+x*8];

    codeptr = data;
    data += 4;

    rowdata = 0x88888888;
    for (row=0; row<8; row+=2) {
	code = *codeptr++;
	data = CUSeeMe_DecodeRow(ip, data, code >> 4, &rowdata);
	data = CUSeeMe_DecodeRow(ip+width/2, data, code & 0xf, &rowdata);
	ip += width;
    }
    VidImage_UpdateRect(image, x*8, y*8, 8, 8);

    return data;
}

int CUSeeMe_Decode(vidimage_t *image, uint8 *data, int len)
{
    int packtype, width, height;
    uint8 *dataLim=data+len;

    if (dataLim-data < 2) return 1;

    packtype = (data[0] << 8) + data[1];
    data += 2;

    switch (packtype) {
    case CUSEEME_HALFSIZE:
	width  = CUSEEME_HALFWIDTH;
	height = CUSEEME_HALFHEIGHT;
	break;
    case CUSEEME_FULLSIZE:
	width  = CUSEEME_FULLWIDTH;
	height = CUSEEME_FULLHEIGHT;
	break;
    default:
	/* Unknown type */
	return 1;
    }

    if ((width != image->width) || (height != image->height))
	VidImage_SetSize(image, width, height);

    while ((data != 0) && (data < dataLim))
	data = CUSeeMe_DecodeSquare(image, data, dataLim);

    return (data != dataLim);
}
