.de Sh
.br
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp
.if t .sp .5v
.if n .sp
..
.TH ST 1
.SH NAME
st - Sound Tools - sound sample file and effects libraries.
.SH SYNOPSIS
.B cc \fIfile.c\fB -o \fIfile \fBlibst.a
.SH DESCRIPTION
.I Sound\ Tools
is a library of sound sample file format readers/writers
and sound effects processors.
.P
Sound Tools includes skeleton C
files to assist you in writing new formats and effects.  
The full skeleton driver, skel.c, helps you write drivers 
for a new format which has data structures.  
The simple skeleton drivers
help you write a new driver for raw (headerless) formats, or
for formats which just have a simple header followed by raw data.
.P
Most sound sample formats are fairly simple: they are just a string
of bytes or words and are presumed to be sampled at a known data rate.
Most of them have a short data structure at the beginning of the file.
.SH INTERNALS
The Sound Tools formats and effects operate on an internal buffer format
of signed 32-bit longs.
The data processing routines are called with buffers of these
samples, and buffer sizes which refer to the number of samples
processed, not the number of bytes.
File readers translate the input samples to signed longs
and return the number of longs read.
For example, data in linear signed byte format is left-shifted 24 bits.
.P
This does cause problems in processing the data.  
For example:
.br
	*obuf++ = (*ibuf++ * *ibuf++)/2;
.br
would
.I not
mix down left and right channels into one monophonic channel,
because the resulting samples would overflow 32 bits.
Instead, the ``avg'' effects must use:
.br
	*obuf++ = *ibuf++/2 * *ibuf++/2;
.br
.P
Stereo data is stored with the left and right speaker data in
successive samples.
Quadraphonic data is stored in this order: 
left front, right front, left rear, right rear.
.SH FORMATS
A 
.I format 
is responsible for translating between sound sample files
and an internal buffer.  The internal buffer is store in signed longs
with a fixed sampling rate.  The 
.I format
operates from two data structures:
a format structure, and a private structure.
.P
The format structure contains a list of control parameters for
the sample: sampling rate, data size (bytes, words, floats, etc.),
style (unsigned, signed, logarithmic), number of sound channels.
It also contains other state information: whether the sample file
needs to be byte-swapped, whether fseek() will work, its suffix,
its file stream pointer, its 
.I format
pointer, and the 
.I private
structure for the 
.I format .
.P
The 
.I private 
area is just a preallocated data array for the 
.I format
to use however it wishes.  
It should have a defined data structure
and cast the array to that structure.  
See voc.c for the use of a private data area.  
Voc.c has to track the number of samples it 
writes and when finishing, seek back to the beginning of the file
and write it out.
The private area is not very large.
The ``echo'' effect has to malloc() a much larger area for its
delay line buffers.
.P
A 
.I format
has 6 routines:
.TP 20
startread
Set up the format parameters, or read in
a data header, or do what needs to be done.
.TP 20
read
Given a buffer and a length: 
read up to that many samples, 
transform them into signed long integers,
and copy them into the buffer.
Return the number of samples actually read.
.TP 20
stopread
Do what needs to be done.
.TP 20
startwrite
Set up the format parameters, or write out 
a data header, or do what needs to be done.
.TP 20
write
Given a buffer and a length: 
copy that many samples out of the buffer,
convert them from signed longs to the appropriate
data, and write them to the file.
If it can't write out all the samples,
fail.
.TP 20
stopwrite
Fix up any file header, or do what needs to be done.
.SH EFFECTS
An effects loop has one input and one output stream.
It has 5 routines.
.TP 20
getopts
is called with a character string argument list for the effect.
.TP 20
start
is called with the signal parameters for the input and output
streams.
.TP 20 
flow
is called with input and output data buffers,
and (by reference) the input and output data sizes.
It processes the input buffer into the output buffer,
and sets the size variables to the numbers of samples
actually processed.
It is under no obligation to fill the output buffer.
.TP 20 
drain
is called after there are no more input data samples.
If the effect wishes to generate more data samples
it copies the generated data into a given buffer
and returns the number of samples generated.
If it fills the buffer, it will be called again, etc.
The echo effect uses this to fade away.
.TP 20
stop
is called when there are no more input samples to process.
.I stop
may generate output samples on its own.
See echo.c for how to do this, 
and see that what it does is absolutely bogus.
.SH COMMENTS
Theoretically, formats can be used to manipulate several files 
inside one program.  Multi-sample files, for example the download
for a sampling keyboard, can be handled cleanly with this feature.
.SH PORTABILITY PROBLEMS
Many computers don't supply arithmetic shifting, so do multiplies
and divides instead of << and >>.  The compiler will do the right
thing if the CPU supplies arithmetic shifting.
.P
Do all arithmetic conversions one stage at a time.
I've had too many problems with "obviously clean" combinations.
.P
In general, don't worry about "efficiency".  
The sox.c base translator
is disk-bound on any machine (other than a 8088 PC with an SMD disk 
controller).  
Just comment your code and make sure it's clean and simple.
You'll find that DSP code is extremely painful to write as it is.
.SH BUGS
The HCOM format is not re-entrant; it can only be used once in a program.
.P
The program/library interface is pretty weak.
There's too much ad-hoc information which a program is supposed to
gather up.
Sound Tools wants to be an object-oriented dataflow architecture.
.P
The human ear can't really hear better than 20 bits.
With an internal format of 16 bits, we will eventually
destroy information when used to mix CD's.
The internal format should be 24-bit signed data.
But, with 24 bits you still have to be careful multiplying.
Check the ``vibro'' effect for how it handles this problem.
