# AddINC.pm
#
# Copyright (c) 1995 Graham Barr. All rights reserved.
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
#
=head1 NAME

AddINC - include directories relative to the calling script

=head1 SYNOPSIS

 use AddINC qw(../lib/perl);

or

 use AddINC;
 push(@INC, AddINC::resolve qw(../lib/perl);

=head1 DESCRIPTION

This package uses the package import mechanism to allow a user to unshift
directories onto @INC relative to where the current script was located

It allows the user to replace a line like

 BEGIN { unshift(@INC,qw(. ./lib ../lib ../../lib ../../../lib)) } 

with

 use AddINC qw(. ./lib ../lib ../../lib ../../../lib);

the example used here is in common use within test scripts under the
perl5/ext/... directories

This allows a user to setup a directory tree for some software with
directories <root>/bin and <root>/lib and then the following will allow
the use of modules in the lib directory without knowing where the software
tree is installed

 use AddINC qw(../lib);

=head1 VARIABLES

As a side effect two variables are set

 $AddINC::SCRIPT - Path to real script file, not a link
 $AddINC::BIN    - Path to bin directory which $AddINC::SCRIPT resides

=head1 AUTHOR

Graham Barr <Graham.Barr@tiuk.ti.com>

=head1 COPYRIGHT

Copyright (c) 1995 Graham Barr. All rights reserved. This program is free 
software; you can redistribute it and/or modify it under the same terms 
as Perl itself.

=head1 REVISION HISTORY

v1.00  25Jan95

 Moved the unshift out of resolve and into import to allow
  push(@INC,AddINC::resolve(.....));
 Changed name to AddINC from relinc
 Added pod manual
 Initial release to perl5-porters

v0.20  15Dec94

  Added the ability to allow absolute paths to be specified.

v0.10  04Dec94

  Initial version

=cut

package AddINC;

$Version = 1.0;		# Last edited 25th Jan 1995 by Graham Barr

require 5.000;

$SCRIPT = undef;
$BIN    = undef;

sub resolve
{
 unless(defined $SCRIPT)
  {
   $SCRIPT = $0;

   while(1)
    {
     local($linktext) = readlink($SCRIPT);

     $BIN = ($SCRIPT =~ m#^(.*)/[^/]*$#)[0] || ".";

     last unless defined $linktext;

     $SCRIPT = ($linktext =~ m#^/#)
                 ? $linktext
                 : $BIN . "/" . $linktext;
    }
  }
 grep(-d, grep(do{s#\A([^/])#$BIN/$1#;1},@_));
}

sub import {
 local($package,@paths) = @_;

 unshift(@INC, resolve(@paths));
}

1; # Keep require happy

