use ExtUtils::MakeMaker qw(%att &WriteMakefile);

$Version = 'b3';

$define = '-DBASEEXT=\\"$(BASEEXT)\\"';
$define .= " -DNTK_VERSION=\\\"$Version\\\"";
$inc    = "";
$xlib   = "";
require './myConfig';


# The existence of the ./*/Makefile.PL file causes MakeMaker
# to automatically include Makefile code for the targets
#	config, all, clean, realclean and */Makefile
# which perform the corresponding action in the subdirectory.
                           
WriteMakefile(
    'NAME'     => 'Tk',
    'DISTNAME' => "Tk-$Version",
    'VERSION'  => $Version,
    'MYEXTLIB' => 'pTk/libpTk.a',
    'DEFINE'  => $define, 
    'INC'     => $inc,
#   'PM'      => $pm,
    'OBJECT'  => '$(BASEEXT).o nIO.o tkGlue.o leak_util.o',
    'LIBS'    => ["$xlib -lX11 -lpt -lsocket -lnsl -lm"],
    'clean' 	=> {'FILES' => 'libpTk.a *%'}
);

sub MY::post_initialize {
 "# MM version $ExtUtils::MakeMaker::Version\n";
}

sub MY::post_constants {

 return &upgrade_pic();
}

sub MY::postamble {
    '
Makefile     : myConfig
$(BASEEXT).o : tkGlue.h
tkGlue.o     : tkGlue.c tkGlue.h pTk/Methods.def tkGlue.t

tkGlue.t     : tkGlue.h
	$(PERL) pTk/mkVFunc tkGlue.h

$(MYEXTLIB)  : FORCE
	cd pTk; $(MAKE) libpTk.a

pTk/Methods.def : FORCE
	cd pTk; $(MAKE) Methods.def

';
}

sub MY::distclean {
'

MANIFEST : ./mkMANIFEST FORCE
	$(PERL) ./mkMANIFEST 

distclean: MANIFEST
	cd ..; tar cvf $(DISTNAME).tar `sed -e "s,^,$(DISTNAME)/," $(DISTNAME)/MANIFEST`
	cd ..; gzip -f $(DISTNAME).tar
	:

';
}

