#
# Copyright (c) 1992-1994 The Regents of the University of California.
# Copyright (c) 1994 Sun Microsystems, Inc.
# Copyright (c) 1995 Nick Ing-Simmons. All rights reserved.
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself, subject 
# to additional disclaimer in Tk/license.terms due to partial
# derivation from Tk4.0 sources.
#
package Tk;
require Exporter;
require AutoLoader;
require DynaLoader;

@ISA       = qw(Exporter DynaLoader);

use Carp;

@EXPORT    = qw(Exists Ev after exit focus MainLoop DoOneEvent destroy update tkinit tkmainloop tkwait
		$tk_library $tk_patchLevel $tk_strictMotif $tk_version $nTk_version);
@EXPORT_OK = qw(Exists Ev winfo after exit focus MainLoop DoOneEvent destroy update tkinit tkmainloop tkwait
		$tk_library $tk_patchLevel $tk_strictMotif $tk_version $nTk_version NoOp lsearch);

$tk_library     = "Tk";
$tk_version     = "4.0";
$tk_patchLevel  = "4.0";
$Tk_module      = "alpha";
$tk_strictMotif = 0;

bootstrap Tk;



# $tk_library , $tk_version and $tk_patchLevel are set by pTk when a mainwindow is created
# $Version is set by bootstrap


# Following AUTOLOAD is no longer used, it is retained here
# as getting it to work in scalar/array context etc. took 
# a lot of effort and false starts
sub Tk::Obsolete::AUTOLOAD
{
 my @ result;
 if (wantarray)
  {
   eval { @result = $window->call($method, @_) };
  }
 else
  {
   eval { $result[0] = $window->call($method, @_) };
  }
 if ($@)
  {
   $@ =~ s/at.*\n//;
   croak $@;
  }
 return (wantarray) ? @result : $result[0];
}


sub NoOp {}

sub Ev
{
 my @args = @_;
 my $obj;
 if (@args == 1)
  {
   my $arg = pop(@args);
   $obj = (ref $arg) ? $arg : \$arg;
  }
 else 
  {
   $obj = \@args;
  }
 return bless $obj,"Tk::Ev";
}


sub lsearch
{my $ar = shift;
 my $x  = shift;
 my $i;
 for ($i = 0; $i < scalar @$ar; $i++)
  {
   return $i if ($$ar[$i] == $x);
  }
 return -1;
}

require Tk::Callback;
require Tk::Widget;
Tk::Widget->import;

require Tk::Image;
# Tk::Image->import;

require Tk::MainWindow;

sub tkinit
{
 return MainWindow->new(@_);
}

sub tkmainloop
{
 Tk->MainLoop();
}

sub Exists
{my $w = shift;
 return defined($w) && ref($w) && $w->IsWidget && $w->exists;
}

sub CancelRepeat
{
 if (defined $afterId)
  {
   after("cancel",$afterId);
   undef $afterId;
  }
}

#----------------------------------------------------------------------------
# focus.tcl --
#
# This file defines several procedures for managing the input
# focus.
#
# @(#) focus.tcl 1.6 94/12/19 17:06:46
#
# Copyright (c) 1994 Sun Microsystems, Inc.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.

#
# focusNext --
# This procedure is invoked to move the input focus to the next window
# after a given one. "Next" is defined in terms of the window
# stacking order, with all the windows underneath a given top-level
# (no matter how deeply nested in the hierarchy) considered except
# for frames and toplevels.
#
# Arguments:
# w - Name of a window: the procedure will set the focus
# to the next window after this one in the traversal
# order.
sub focusNext
{
 my $w = shift;
 my $cur = $w;
 while (1)
  {
   # Descend to just before the first child of the current widget.
   my $parent = $cur;
   my @children = $cur->children();
   my $i = -1;
   # Look for the next sibling that isn't a top-level.
   while (1)
    {
     $i += 1;
     if ($i < @children)
      {
       $cur = $children[$i];
       next if ($cur->toplevel == $cur);
       last
      }
     # No more siblings, so go to the current widget's parent.
     # If it's a top-level, break out of the loop, otherwise
     # look for its next sibling.
     $cur = $parent;
     last if ($cur->toplevel() == $cur);
     $parent = $parent->parent();
     @children = $parent->children();
     $i = lsearch(\@children,$cur);
    }
   if ($cur == $w || $cur->FocusOK)
    {
     $cur->focus;
     return;
    }
  }
}
# focusPrev --
# This procedure is invoked to move the input focus to the previous
# window before a given one. "Previous" is defined in terms of the
# window stacking order, with all the windows underneath a given
# top-level (no matter how deeply nested in the hierarchy) considered.
#
# Arguments:
# w - Name of a window: the procedure will set the focus
# to the previous window before this one in the traversal
# order.
sub focusPrev
{
 my $w = shift;
 my $cur = $w;
 my @children;
 my $i;
 my $parent;
 while (1)
  {
   # Collect information about the current window's position
   # among its siblings. Also, if the window is a top-level,
   # then reposition to just after the last child of the window.
   if ($cur->toplevel() == $cur)
    {
     $parent = $cur;
     @children = $cur->children();
     $i = @children;
    }
   else
    {
     $parent = $cur->parent();
     @children = $parent->children();
     $i = lsearch(\@children,$cur);
    }
   # Go to the previous sibling, then descend to its last descendant
   # (highest in stacking order. While doing this, ignore top-levels
   # and their descendants. When we run out of descendants, go up
   # one level to the parent.
   while ($i > 0)
    {
     $i--;
     $cur = $children[$i];
     next if ($cur->toplevel() == $cur);
     $parent = $cur;
     @children = $parent->children();
     $i = @children;
    }
   $cur = $parent;
   if ($cur == $w || $cur->FocusOK)
    {
     $cur->focus;
     return;
    }
  }

}

sub FocusOK
{
 my $w = shift;
 my $value;
 eval { $value = $w->cget('-takefocus') };
 if (!$@ && defined($value))
  {
   return 0 if ($value == 0);
   return 1 if ($value == 1);
   $value = $w->$value();
   return $value if (defined $value);
  }
 if (!$w->allmapped)
  {
   return 0;
  }
 eval { $value = $w->cget('-state') } ;
 if (!$@ && defined($value) && $value eq "disabled")
  {
   return 0;
  }
 $value = grep(/Key|Focus/,$w->Tk::bind(),$w->Tk::bind(ref($w)));
 return $value;
}


# focusFollowsMouse
#
# If this procedure is invoked, Tk will enter "focus-follows-mouse"
# mode, where the focus is always on whatever window contains the
# mouse. If this procedure isn't invoked, then the user typically
# has to click on a window to give it the focus.
#
# Arguments:
# None.

sub EnterFocus
{
 my $w  = shift;
 my $Ev = $w->XEvent;
 my $d  = $Ev->d;
 $w->focus() if ($d eq "NotifyAncestor" ||  $d eq "NotifyNonlinear" ||  $d eq "NotifyInferior");
}

sub focusFollowsMouse
{
 my $widget = shift;
 $widget->bind('all',"EnterFocus");
}

sub InitBindings
{
 my $mw = shift;
 $mw->bind('all',"<Tab>","focusNext");
 $mw->bind('all',"<Shift-Tab>","focusPrev");
                                    
 $mw->bind('all',"<Alt-KeyPress>",[TraverseToMenu,Ev(A)]);
 $mw->bind('all',"<F10>",FirstMenu);
}

# tkTraverseToMenu --
# This procedure implements keyboard traversal of menus. Given an
# ASCII character "char", it looks for a menubutton with that character
# underlined. If one is found, it posts the menubutton's menu
#
# Arguments:
# w - Window in which the key was typed (selects
# a toplevel window).
# char - Character that selects a menu. The case
# is ignored. If an empty string, nothing
# happens.
sub TraverseToMenu
{
 my $w = shift;
 my $char = shift;
 return unless(defined $char && $char ne "");
 $w = $w->toplevel->FindMenu($char);
 $w->PostFirst() if (defined $w);
}
# tkFirstMenu --
# This procedure traverses to the first menubutton in the toplevel
# for a given window, and posts that menubutton's menu.
#
# Arguments:
# w - Name of a window. Selects which toplevel
# to search for menubuttons.
sub FirstMenu
{
 my $w = shift;
 $w = $w->toplevel->FindMenu("");
 $w->PostFirst() if (defined $w);
}

# Find --
# This procedure searches the entire window hierarchy under w for
# a menubutton that isn't disabled and whose underlined character
# is "char". It returns the name of that window, if found, or an
# empty string if no matching window was found. If "char" is an
# empty string then the procedure returns the name of the first
# menubutton found that isn't disabled.
#
# Arguments:
# w - Name of window where key was typed.
# char - Underlined character to search for;
# may be either upper or lower case, and
# will match either upper or lower case.
sub FindMenu
{
 my $w = shift;
 my $char = shift;
 my $child;
 foreach $child ($w->children)
  {
   next unless (ref $child);
   if ($child->IsMenubutton)
    {
     my $ul = $child->cget("-underline");
     if (defined $ul && $ul >= 0 && $child->cget("-state") ne "disabled")
      {
       my $char2 = $child->cget("-text");
       $char2 = substr("\L$char2",$ul,1) if (defined $char2);
       if (!defined($char) || $char eq "" || (defined($char2) && "\l$char" eq $char2))
        {
         return $child;
        }
      }
    }
   elsif ($child->IsFrame)
    {
     $match = $child->FindMenu($char);
     return $match if (defined $match);
    }
  }
 return undef;
}

# These wrappers don't use method syntax so need to live
# in same package as raw Tk routines are newXS'ed into.

sub Selection
{my $widget = shift;
 my $cmd    = shift;
 die "Use SelectionOwn/SelectionOwner" if ($cmd eq 'own');
 die "Use Selection\u$cmd()";
}

sub SelectionOwn
{my $widget = shift;
 selection('own',(@_,$widget));
}

sub SelectionOwner
{
 selection('own',"-displayof",@_);
}

sub SelectionClear
{
 selection('clear',"-displayof",@_);
}

sub SelectionHandle
{my $widget = shift;
 my $command = pop;
 selection('handle',@_,$widget,$command);
}

sub Clipboard
{my $widget = shift;
 my $cmd    = shift;
 clipboard($cmd,"-displayof",$widget,@_);
}

sub OptionGet
{
 option('get',@_);
}

sub break
{
 die "_TK_BREAK_\n";
}

sub idletasks
{
 update('idletasks');
}

sub ImageNames
{
 image('names');
}

sub ImageTypes
{
 image('types');
}

sub BackgroundError
{my $w = shift;
 my $error = shift;
 chomp($error);
 carp "Background Error: $error\n " . join("\n ",@_);
}

sub receive
{
 my $w = shift;
 warn "receive(" . join(',',@_) .")";
 die "Tk rejects send(" . join(',',@_) .")\n";
}

sub interps
{
 return winfo('interps');
}

1;

__END__
# provide an exit() to be exported if exit occurs 
# before a MainWindow->new()
sub exit { CORE::exit(@_);}
