package Tk::Callback;

use Carp;

#
# Call is used by Scrollbar to invoke the command now that all the 
# behaviour of the Scrollbar is defined in Tcl converted to perl.
# The code below is supposed to emulate LangDoCallback() but is 
# incomplete. 
# 
# There is a further snag:
#   $w->cget("-command") returns [a,...z] as multiple values
#   rather than an array ref as a result of some hacking gone astray.
# This (sort of) helps here as it means that @_ has already had [] 
# style callbacks expanded, but makes Scrollbar.pm somewhat non-intuitive,
# and potentially makes things more memory hungry than necessary.
# 
sub Call
{
 # print "Call(",join(',',@_),")\n";
 my $cb  = shift;
 my $type = "$cb";
 croak("Not a Callback $type") unless($cb->IsCallback);
 if ($type =~ /ARRAY/)
  {
   unshift(@_,@$cb[1..(@$cb-1)]);
   $cb = $$cb[0];
  }
 elsif ($type =~ /=SCALAR/)
  {
   $cb =$$cb;
  }
 my $type = "$cb";
 if ($type =~ /CODE/)
  {
   &$cb(@_);
  }
 else
  {
   my $obj = shift;
   if (ref $obj)
    {
     $obj->$cb(@_);
    }
   else
    {
     &$cb($obj,@_);
    }
  }
}    

sub IsCallback {1}

sub new
{
 my $class = shift;
 my $obj;
 return undef unless (@_);
 croak "No content to Callback" unless @_;
 if (@_ == 1)
  {
   my $arg = shift;
   return undef unless (defined $arg);
   $obj = (ref $arg) ? $arg : \$arg;
  }
 else
  {
   $obj = \@_;
  }
 return bless $obj,$class;
}

sub DESTROY
{

}

1;
