# simply split out of Tk-a5's Tk.pm

package Tk::Composite;

#sub classinit 
#{ 
# my ($class,$mw) = @_;
# return $class;
# 

package Tk::ScrolledListbox; @ISA = qw(Tk::Composite Tk::Listbox);

use Tk::Widget qw(Frame Listbox Scrollbar);

(bless \qw(ScrolledListbox))->WidgetClass;


sub new 
{
 my $package = shift;
 my $class   = $package;
 $class =~ s/^Tk:://;
 my $parent = shift;
 $package->DoInit($parent);
 my $f = $parent->Frame();
 my $l = $f->Listbox(@_);
 my $s = $f->Scrollbar("-orient" => "vertical", "-command" => [ "yview", $l ]);
 $l->configure("-yscrollcommand" => ["set", $s]);
 $s->pack("-side" => "left", "-fill" => "y");
 $l->pack("-side" => "left", "-fill" => "both", "-expand" => "y");
 $l->{Frame} = $f;
 $l->{Scrollbar} = $s;
 return bless $l,$package;
}

sub pack
{my $l = shift;
 my $f = $l->{Frame};
 $f->pack(@_);
}

1;
