package Tk::Widget;

use Carp;

# print __FILE__," loaded by ",join(' ',caller),"\n";

@ISA = qw(Tk);

@EXPORT = qw(Button Checkbutton Radiobutton Label 
             Canvas Entry Frame Listbox 
             Menu Menubutton Message Scale Scrollbar
             ScrolledListbox Text Toplevel);

sub import
{
 my $package = shift;
 my $need;
 @_ = @EXPORT unless (@_);
 foreach $need (@_)
  {
   unless (defined $classes{$need})
    {
#    print "Tk::Widget::import ",$need," for ",join(' ',caller),"\n";
     require "Tk/${need}.pm"; 
    }
   croak "Cannot locate $need" unless (defined $classes{$need});
  }
}

sub IS
{
 return (defined $_[1]) && $_[0] == $_[1];
}

sub WidgetClass
{
 my $name  = shift;
 my $class = ref $name;
 $name  = $$name;
#print "$name: ",join(',',caller),"\n";
 eval "sub Tk::Widget::$name  {  $class->new(\@_) }
       sub ${class}::Is${name}    { 1 } 
       sub Tk::Widget::Is${name} { 0 } 
      ";
 croak($@) if ($@);
 $classes{$name} = $class;
}

sub ClassFor
{
 my $class = shift;
 return $classes{$class};
}

sub XEvent { shift->{"_XEvent_"} }

sub DoInit
{
 my $package = shift;
 my $parent = shift;
 croak "Unexpected type of parent $parent" unless(ref $parent);
 my $mw = $parent->MainWindow;
 unless (exists $mw->{'_ClassInit_'}{$package})
  {
   $mw->{'_ClassInit_'}{$package} = $package->classinit($mw);
  }
}

sub new
{
 my $package = shift;
 my $parent = shift;
 $package->DoInit($parent);
 my $leaf = "\L$package";
 $leaf =~ s/^tk:://;
 my $cmd = "Tk::$leaf";
 my $pname = $parent->PathName;
 $pname = "" if ($pname eq ".");
 my $lname = $pname . "." . $leaf;
 if (@_ && $_[0] eq 'Name')
  {
   shift;
   $leaf = shift;
  }
 else
  {
   my $num = 0;
   while (defined ($parent->Widget($lname)))
    {
     $lname = $pname . "." . $leaf . ++$num;
    }
  }
 my $obj = eval { &$cmd($lname, @_) };
 croak($@) if ($@);
 bless $obj,$package;
 $obj->bindtags([$package,$obj,$obj->toplevel,'all']);
 return $obj;
}

sub classinit
{
 my $class = shift;
 return $class;
}

sub DESTROY
{
 my $w = shift;
 $w->destroy if ($w->IsWidget);
}

sub rootproperty
{
 my $w = shift;
 return $w->property(@_,'root');
}

# Some tidy-ness functions for winfo stuff

foreach $fn (qw(allmapped cells class depth exists geometry height id ismapped manager
              name parent reqheight reqwidth rootx rooty screen screencells
              screendepth screenheight screenmmheight screenmmwidth        
              screenvisual screenwidth visual visualsavailable    
              vrootheight vrootwidth vrootx vrooty width x y toplevel 
              children pixels fpixels rgb
             ))
  {
   eval "sub $fn { my \$w = shift; \$w->winfo('$fn', \@_) }";
  }

# atom, atomname, containing, interps, pathname 
# don't work this way - there is no window arg
# So we pretend there was an call the C versions from Tk.xs

sub atom       { shift->InternAtom(@_)  }
sub atomname   { shift->GetAtomName(@_) }
sub containing { shift->Containing(@_)  }

# interps not done yet
# pathname not done yet


1;
