use ExtUtils::MakeMaker;


WriteMakefile(
    'LINKTYPE'  => 'static',
    'PM'        => {},
    'SKIP'	=> [qw(static static_lib dynamic dynamic_lib distclean 
                       test perldepend linkext dynamic_bs)]
);

sub MY::post_initialize {

 foreach $name (MM_Unix::lsdir("."))
  {
   next unless (-f $name && $name =~ /^[^\.]+$/);
   $att{PM}->{"$name"} = "\$(INST_LIBDIR)/demos/$name";
  }
 foreach $name (MM_Unix::lsdir("images"))
  {
   next unless (-f "images/$name");
   $att{PM}->{"images/$name"} = "\$(INST_LIBDIR)/demos/images/$name";
  }
 foreach $name (MM_Unix::lsdir("widget_lib"))
  {
   next unless (-f "widget_lib/$name" && $name =~ /\.pl$/);
   $att{PM}->{"widget_lib/$name"} = "\$(INST_LIBDIR)/demos/widget_lib/$name";
  }

}

sub MY::top_targets {
'
all :: static 

static : $(INST_PM)

config ::

';
}

sub MY::realclean {
	'
realclean :: clean
	rm -f Makefile
';
}



