use Config;
use ExtUtils::MakeMaker;

$define = "-DTK_LIBRARY=\\\"$Config{'privlib'}/Tk\\\"";
$inc    = "";
# The existence of the ./pTk/Makefile.PL file causes MakeMaker
# to automatically include Makefile code for the targets
#	config, all, clean, realclean and sdbm/Makefile
# which perform the corresponding action in the subdirectory.

require '../myConfig';

$inc .= " -I." ; 

WriteMakefile(
    'LINKTYPE'  => 'static',
    'DEFINE'	=> $define,
    'MYEXTLIB' => 'xpm/libXpm.a',
    'INC'	=> $inc,
    'SKIP'	=> [qw(static static_lib dynamic dynamic_lib distclean 
                       test perldepend xs_o)],
    'clean' 	=> {'FILES' => 'libpTk.a *%'}
);

sub MY::xs_c {
'
# Rules for building .t table files from .h files
.SUFFIXES: .t

.h.t :
	$(PERL) mkVFunc $< 
'
}

sub MY::post_constants {

my $objects = "LIBOBJS =";
unless (defined($Config{'i_stdlib'}) && &try_compile("config/Hstrtoul.c"))
 {
  $objects .= " strtoul.o" 
 }
my $len     = length($objects);
foreach (<[LXt]*.c>)
{
 s/\.c/.o/;
 if (($len+length($_)+1) > 72)
  {
   $objects .= "\\\n\t";
   $len = 8;
  }
 $objects .= " $_";
 $len     += 1+length($_);
} 
$objects .= "\n";

return "\n" . $objects . &upgrade_pic();
};

sub MY::install {
'
install :: all
';
}

sub MY::top_targets {
'
all :: static 

static  ::	libpTk.a 

dynamic ::	libpTk.a 

libpTk.a: $(LIBOBJS) $(MYEXTLIB)
	cp $(MYEXTLIB) $@
	ar cr libpTk.a $(LIBOBJS)
	$(RANLIB) libpTk.a

$(LIBOBJS): $(HDRS)


';
}

sub MY::realclean {
	'
realclean :: clean
	rm -f Makefile
';
}

sub MY::postamble {
join('',`cat *.d`) . '
Makefile : ../myConfig

Lang.f  : Lang.h   mkVFunc
tk.f    : tk.h     mkVFunc
tkInt.f : tkInt.h  mkVFunc

config :: Lang.f tk.f tkInt.f

$(MYEXTLIB)  : FORCE
	cd xpm; $(MAKE) libXpm.a

';
}


