use Config;
use ExtUtils::MakeMaker;

$define = "";
$inc    = "";
# The existence of the ./pTk/Makefile.PL file causes MakeMaker
# to automatically include Makefile code for the targets
#	config, all, clean, realclean and sdbm/Makefile
# which perform the corresponding action in the subdirectory.

require '../../myConfig';

$inc .= " -I." ; 

WriteMakefile(
    'LINKTYPE'  => 'static',
    'DEFINE'	=> $define,
    'INC'	=> $inc,
    'SKIP'	=> [qw(static static_lib dynamic dynamic_lib distclean 
                       test perldepend xs_c xs_o)],
    'clean' 	=> {'FILES' => 'libXpm.a *%'}
);

sub MY::post_constants {
 return &upgrade_pic();
}

#'LIBOBJS= data.o create.o misc.o rgb.o scan.o parse.o hashtab.o \
#      WrFFrP.o RdFToP.o CrPFrDat.o CrDatFrP.o \
#      WrFFrI.o RdFToI.o CrIFrDat.o CrDatFrI.o \
#      CrIFrBuf.o CrPFrBuf.o CrBufFrI.o CrBufFrP.o \
#      RdFToDat.o WrFFrDat.o \
#      Attrib.o CrIFrP.o CrPFrI.o Image.o Info.o RdFToBuf.o WrFFrBuf.o

sub MY::install {
'
install :: all
';
}

sub MY::top_targets {
'
all :: linkext

static  ::	libXpm.a

dynamic ::	libXpm.a

libXpm.a: $(O_FILES)
	ar cr libXpm.a $(O_FILES)
	$(RANLIB) libXpm.a

config ::

';
}

sub MY::realclean {
	'
realclean :: clean
	rm -f Makefile
';
}

sub MY::postamble {
'
Makefile : ../../myConfig
# Other dependencies.
CrBufFrI.o:  xpmP.h xpm.h
CrBufFrP.o:  xpmP.h xpm.h
CrDatFI.o:  xpmP.h xpm.h
CrDatFP.o:  xpmP.h xpm.h
CrIFrBuf.o:  xpmP.h xpm.h
CrIFrDat.o:  xpmP.h xpm.h
CrPFrBuf.o:  xpmP.h xpm.h
CrPFrDat.o:  xpmP.h xpm.h
RdFToDat.o:  xpmP.h xpm.h
RdFToI.o:  xpmP.h xpm.h
RdFToP.o:  xpmP.h xpm.h
WrFFrDat.o:  xpmP.h xpm.h
WrFFrI.o:  xpmP.h xpm.h
WrFFrP.o:  xpmP.h xpm.h
create.o:  xpmP.h xpm.h
data.o:  xpmP.h xpm.h
hashtab.o:  xpmP.h xpm.h
misc.o:  xpmP.h xpm.h
parse.o:  xpmP.h xpm.h
rgb.o:  xpmP.h xpm.h
scan.o:  xpmP.h xpm.h
Attrib.o:  xpmP.h xpm.h
CrIFrP.o:  xpmP.h xpm.h
CrPFrI.o:  xpmP.h xpm.h
Image.o:  xpmP.h xpm.h
Info.o:  xpmP.h xpm.h
RdFToBuf.o:  xpmP.h xpm.h
WrFFrBuf.o:  xpmP.h xpm.h
';
}



