
% COLOR110.INC Color and Blink attributes
% ---------------------------------------
%
% Contents:
%
% - Store colors in variables.                   (Bo Bendtsen  10-Aug-1995)
% - Function BlinkBit - test status of BlinkBit  (Joop Blokker 12-Aug-1995)
% - Function ToggleBlinkBit - set/reset BlinkBit (Joop Blokker 13-Aug-1995)
%
% =========================================================================
% - Store colors in variables.                   (Bo Bendtsen  10-Aug-1995)
% =========================================================================
% Low intensity:
% Foreground & Background)
% ------------------------
  Set Black        =   0
  Set Blue         =   1
  Set Green        =   2
  Set Cyan         =   3
  Set Red          =   4
  Set Magenta      =   5
  Set Brown        =   6
  Set LightGray    =   7

%
% Foreground  and  Blinking OR Intensive Background
% ------------------------
  Set DarkGray     =   8
  Set LightBlue    =   9
  Set LightGreen   =  10
  Set LightCyan    =  11
  Set LightRed     =  12
  Set LightMagenta =  13
  Set Yellow       =  14
  Set White        =  15

% =========================================================================
% - Function BlinkBit - Test status of BlinkBit  (Joop Blokker 12-Aug-1995)
% =========================================================================
%
% Test Blink attribute.
%  If ON  (1) then text is blinking.
%  If OFF (0) then text has High-Intensity background.
% -----------------------------------------------
Function BlinkBit()
Set Status = MEM(64,101)         % get byte from memory
Set BinaryS = Binary(Status,8)   % convert to binary string
If Copy(BinaryS,3,1) ="1"        % test bit 5 - blinkbit
  Set Status = 1                 % blinking
else
  Set Status = 0                 % not blinking (high intensive background)
endif
EndFunc Status

% =====================================================================
% - Function ToggleBlinkBit - set/reset BlinkBit (Joop Blokker 13-Aug-1995)
% =====================================================================
%
% Toggle Blink attribute.
%  If ON  (1) then text is blinking if Background > 7
%  If OFF (0) then text has High-Intensity background if Background > 7
% ---------------------------------------------------------------------
Function ToggleBlinkBit(Status)
If Status = 1
  Set Dummy = INTERRUPT(16, 4099, 1, 0, 0, 0, 0, 0, 0)
else
  Set Dummy = INTERRUPT(16, 4099, 0, 0, 0, 0, 0, 0, 0)
endif
EndFunc

