% -----------------------------------------------------------------------------
% Keyboard Include file (addition)                     *TERMINATE PRESCRIPTION*
% -----------------------------------------------------------------------------
%
%  Version          : 1.02
%  Filename         : KEYBOARD.INC
%  Company          : None
%  Programmer       : Dave Wapstra
%  Module created   : 07 Aug 1995
%  Latest revision  : 03 Nov 1995
%  Language/version : Terminate Prescription 1.00
%  Remarks          : Keyboard keycodes and functions
%  Credits          : Thanks to Dennis Janssen for the KeyShift entries
%
% -----------------------------------------------------------------------------

%
% KEYBOARD.INC
%
% Keycodes and keyboard functions
%
% Dave Wapstra
% 7 Aug. 1995
%

% Normal keys

Set KeyEsc = 27
Set KeyEnter = 13

Set KeyA = 97
Set KeyB = 98
Set KeyC = 99
Set KeyD = 100
Set KeyE = 101
Set KeyF = 102
Set KeyG = 103
Set KeyH = 104
Set KeyI = 105
Set KeyJ = 106
Set KeyK = 107
Set KeyL = 108
Set KeyM = 109
Set KeyN = 110
Set KeyO = 111
Set KeyP = 112
Set KeyQ = 113
Set KeyR = 114
Set KeyS = 115
Set KeyT = 116
Set KeyU = 117
Set KeyV = 118
Set KeyW = 119
Set KeyX = 120
Set KeyY = 121
Set KeyZ = 122

% Function Keys

Set KeyF1 = 315
Set KeyF2 = 316
Set KeyF3 = 317
Set KeyF4 = 318
Set KeyF5 = 319
Set KeyF6 = 320
Set KeyF7 = 321
Set KeyF8 = 322
Set KeyF9 = 323
Set KeyF10 = 324
Set KeyF11 = 389
Set KeyF12 = 390

% Arrow Keys
Set KeyUp = 328
Set KeyDown = 336
Set KeyLeft = 331
Set KeyRight = 333

%==========================================================================
% Keyboard scancodes for StuffKey Function          (Dave Wapstra 03-11-95)
%==========================================================================

Set ScanKeyEnter = 7181
Set ScanKeyEscape = 283

% Function keys

Set ScanKeyF10 = 17408
Set ScanKeyF11 = 34048
Set ScanKeyF12 = 34304

Set ScanKeyShiftF10 = 23808
Set ScanKeyShiftF11 = 34560
Set ScanKeyShiftF12 = 34816

Set ScanKeyCtrlF10 = 26368
Set ScanKeyCtrlF11 = 35072
Set ScanKeyCtrlF12 = 35328

Set ScanKeyAltF10 = 28928
Set ScanKeyAltF11 = 35584
Set ScanKeyAltF12 = 35840

%==========================================================================
% Stuff functions                                   (Dave Wapstra 03-11-95)
%==========================================================================

Function StuffKey(KeyVal)
  % AL returns:
  % 0 = Succes
  % 1 = Keyboard buffer is full
  Set Return = Interrupt(22,1280,0,KeyVal,0,0,0,0,0)
  If GrabWord(Return,2) = 0
    Set StuffKey = 0
  Else
    Set StuffKey = 1
  EndIf
EndFunc StuffKey

Function StuffChar(KeyChar)
  % AL returns:
  % 0 = Succes
  % 1 = Keyboard buffer is full
  Set KeyVal = Ord(KeyChar)
  Set Return = Interrupt(22,1280,0,KeyVal,0,0,0,0,0)
  If GrabWord(Return,2) = 0
    Set StuffChar = 0
  Else
    Set StuffChar = 1
  EndIf
EndFunc StuffChar

Function StuffStr(KeyStr)
  % AL returns:
  % 0 = Succes
  % 1 = Keyboard buffer is full
  For x,1,Length(KeyStr),1
    Set KeyVal = Ord(Copy(KeyStr,x,1))
    Set Return = Interrupt(22,1280,0,KeyVal,0,0,0,0,0)
    If GrabWord(Return,2) = 0
      Set StuffStr = 0
    Else
      Set StuffStr = 1
    EndIf
  Next
EndFunc StuffStr

