@ECHO OFF

Rem 
Rem       Sample batchfile to send a fax from the command line.
Rem 
Rem   Parameters:
Rem 
Rem   1 : File to send, either APF (Fax-format), PCX, TIFF or Ascii Text
Rem   2 : Number to call
Rem   3 : Person to receive fax (Optional), replace blanks with underscores
Rem 
Rem   Examples:
Rem 
Rem     TERMINAT /FAX /SEND c:\autoexec.bat 4264xxxx
Rem     TERMINAT /FAX /SEND c:\autoexec.bat 4264xxxx Bo_Bendtsen
Rem 

..\TERMINAT /FAX /SEND %1 %2 %3

If Errorlevel == 6 Goto Error
If Errorlevel == 5 Goto Busy
If Errorlevel == 4 Goto DataCall
If Errorlevel == 3 Goto VoiceCall
If Errorlevel == 2 Goto UserAbort
If Errorlevel == 1 Goto TimeOut
If Errorlevel == 0 Goto Ok

:Error
Echo Some error occured during transfer or setup
Goto End

:Busy
Echo The line was busy
Goto End

:DataCall
Echo The number was a modem which was not set to fax answer mode
Goto End

:VoiceCall
Echo Someone answered the call voice
Goto End

:UserAbort
Echo You aborted the call by pressing the ESCape key
Goto End

:TimeOut
Echo The call elapsed without any response from the other side
Goto End

:Ok
Echo The file was sent successfully
Goto End

:End

