/* commandfuncs.h
 * header file for functions invoked by user keypresses
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999-2005 Matthew Hiller
 */

#include <denemo/denemo.h> 

void
nudgerightward (scoreinfo  *si);

void
nudge_downward (scoreinfo  *si);

void
set_width_to_work_with (scoreinfo  *si);

void
adjustmeasurewidth (scoreinfo  *si, gint amount);

void
setcurrents (scoreinfo  *si);

void
adjuststaffheight (scoreinfo  *si, gint amount);

void
measureleft (scoreinfo  *si);

void
measureright (scoreinfo  *si);

void
staffup (scoreinfo  *si);

void
staffdown (scoreinfo  *si);

void
cursorleft (scoreinfo  *si);

void
cursorright (scoreinfo  *si);

void
cursorup (scoreinfo  *si);

void
cursordown (scoreinfo  *si);

void
shiftcursor (scoreinfo  *si, gint note_value);

void
insertchord (scoreinfo  *si, gint duration, gboolean rest);

void
changeduration (scoreinfo  *si, gint duration);

void
tonechange (scoreinfo  *si, gboolean remove);

void
changeenshift (scoreinfo  *si, gint amount);

void
change_stem_directive (scoreinfo  *si, enum stemdirections amount);

void
changedots (scoreinfo  *si, gint amount);

void
insertmeasures (scoreinfo  *si, gint number);

void
appendmeasures (scoreinfo  *si, gint number);

void
deleteobject (scoreinfo  *si);

void
deletemeasure (scoreinfo  *si);

void
deletestaff (scoreinfo  *si, gint pos);

void
insertclone (scoreinfo  *si);

void
toend (GtkAction *action, scoreinfo  *si);

void
tohome (GtkAction *action, scoreinfo  *si);

void
tonextscore (GtkAction *action, scoreinfo  *si);

void
inserttuplet (scoreinfo  *si, tuplet_type type);

void
object_insert (scoreinfo  *si, mudelaobject *mudela_obj_new);

void
stem_directive_insert (GtkAction *action, scoreinfo *si);

void
toggle_begin_slur (scoreinfo  *si);

void
toggle_end_slur (scoreinfo  *si);

void insertgrace(scoreinfo  *si);

void
toggle_start_crescendo (scoreinfo  *si);

void
toggle_end_crescendo (scoreinfo  *si);

void
toggle_start_diminuendo (scoreinfo  *si);

void
toggle_end_diminuendo (scoreinfo  *si);

void nextmeasure(scoreinfo  *si);

void
caution (scoreinfo  *si);
void displayhelper(scoreinfo  *si);

gboolean
auto_save_document_timeout(scoreinfo  *si);
void delete_staff(scoreinfo *si, guint callback_action);

void delete_staff_current(GtkAction *action,scoreinfo *si);
void delete_staff_before(GtkAction *action, scoreinfo *si);
void delete_staff_after(GtkAction *action, scoreinfo *si);
