/* headerdialog.c
 * Prompts the user to change the header information
 *
 *  (c) 2000-2005 Laurent Martelli <laurent@linuxfan.com>
 * Modified by Matt Hiller 22 Apr 2000, 2001, 2002 
 * Modified by Adam Tee 22 03 2005
 */

#include <denemo/denemo.h>
#include "utils.h"
#include "scorewizard.h" //for papersetup

#define COL_NAME 0
#define COL_VALUE 1
#define COL_PTR 2

/**
 * callback to set the header fields value after an edit
 *
 */
static void
cell_edited (GtkCellRendererText * cellrenderertext,
	     gchar * path_string, gchar * new_text, GtkTreeModel * model)
{
  GtkTreePath *path = gtk_tree_path_new_from_string (path_string);
  GtkTreeIter iter;

  gtk_tree_model_get_iter (model, &iter, path);
  gtk_list_store_set (GTK_LIST_STORE (model), &iter, COL_VALUE, new_text, -1);
  gtk_tree_path_free (path);
}

/**
 * Populate the gtk_tree_view with the header fields and their corresponding 
 * data if present
 */
void 
headerfields(GtkWidget *dialog, GtkListStore *list_store, GtkTreeIter *iter, struct scoreinfo *si, gboolean isdialog)
{
  GtkWidget *list;
  GtkCellRenderer *renderer;
  
  list_store = gtk_list_store_new (3, G_TYPE_STRING,	/* label */
				   G_TYPE_STRING,	/* value */
				   G_TYPE_POINTER);	/* pointer to the corresponding header field */

  list = gtk_tree_view_new_with_model (GTK_TREE_MODEL (list_store));
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (list),
					       0, "Name",
					       gtk_cell_renderer_text_new (),
					       "text", 0, NULL);
  renderer = gtk_cell_renderer_text_new ();
  g_object_set (renderer, "editable", TRUE, NULL);
  g_object_set (renderer, "width", 200, NULL);
  g_signal_connect (renderer, "edited", (GCallback) cell_edited, list_store);
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (list),
					       1, "Value",
					       renderer, "text", 1, NULL);

  gtk_list_store_append (list_store, iter);
  gtk_list_store_set (list_store, iter,
		      COL_NAME, _("Title"),
		      COL_VALUE, si->headerinfo->title->str,
		      COL_PTR, &(si->headerinfo->title->str), -1);

  gtk_list_store_append (list_store, iter);
  gtk_list_store_set (list_store, iter,
		      COL_NAME, _("Subtitle"),
		      COL_VALUE, si->headerinfo->subtitle->str,
		      COL_PTR, &(si->headerinfo->subtitle->str), -1);

  gtk_list_store_append (list_store, iter);
  gtk_list_store_set (list_store, iter,
		      COL_NAME, _("Poet"),
		      COL_VALUE, si->headerinfo->poet->str,
		      COL_PTR, &(si->headerinfo->poet->str), -1);

  gtk_list_store_append (list_store, iter);
  gtk_list_store_set (list_store, iter,
		      COL_NAME, _("Composer"),
		      COL_VALUE, si->headerinfo->composer->str,
		      COL_PTR, &(si->headerinfo->composer->str), -1);

  gtk_list_store_append (list_store, iter);
  gtk_list_store_set (list_store, iter,
		      COL_NAME, _("Meter"),
		      COL_VALUE, si->headerinfo->meter->str,
		      COL_PTR, &(si->headerinfo->meter->str), -1);

  gtk_list_store_append (list_store, iter);
  gtk_list_store_set (list_store, iter,
		      COL_NAME, _("Opus"),
		      COL_VALUE, si->headerinfo->opus->str,
		      COL_PTR, &(si->headerinfo->opus->str), -1);

  gtk_list_store_append (list_store, iter);
  gtk_list_store_set (list_store, iter,
		      COL_NAME, _("Arranger"),
		      COL_VALUE, si->headerinfo->arranger->str,
		      COL_PTR, &(si->headerinfo->arranger->str), -1);

  gtk_list_store_append (list_store, iter);
  gtk_list_store_set (list_store, iter,
		      COL_NAME, _("Instrument"),
		      COL_VALUE, si->headerinfo->instrument->str,
		      COL_PTR, &(si->headerinfo->instrument->str), -1);

  gtk_list_store_append (list_store, iter);
  gtk_list_store_set (list_store, iter,
		      COL_NAME, _("Dedication"),
		      COL_VALUE, si->headerinfo->dedication->str,
		      COL_PTR, &(si->headerinfo->dedication->str), -1);

  gtk_list_store_append (list_store, iter);
  gtk_list_store_set (list_store, iter,
		      COL_NAME, _("Balls"),
		      COL_VALUE, si->headerinfo->piece->str,
		      COL_PTR, &(si->headerinfo->piece->str), -1);

  gtk_list_store_append (list_store, iter);
  gtk_list_store_set (list_store, iter,
		      COL_NAME, _("Head"),
		      COL_VALUE, si->headerinfo->head->str,
		      COL_PTR, &(si->headerinfo->head->str), -1);

  gtk_list_store_append (list_store, iter);
  gtk_list_store_set (list_store, iter,
		      COL_NAME, _("Copyright"),
		      COL_VALUE, si->headerinfo->copyright->str,
		      COL_PTR, &(si->headerinfo->copyright->str), -1);

  gtk_list_store_append (list_store, iter);
  gtk_list_store_set (list_store, iter,
		      COL_NAME, _("Footer"),
		      COL_VALUE, si->headerinfo->footer->str,
		      COL_PTR, &(si->headerinfo->footer->str), -1);

  gtk_list_store_append (list_store, iter);
  gtk_list_store_set (list_store, iter,
		      COL_NAME, _("Tagline"),
		      COL_VALUE, si->headerinfo->tagline->str,
		      COL_PTR, &(si->headerinfo->tagline->str), -1);
	 if(isdialog)
	 {
   		gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), list,
		  								    TRUE, TRUE, 0);
	 }
	 else
	 {
	   gtk_notebook_append_page (GTK_NOTEBOOK (dialog), list, NULL);
		 gtk_notebook_set_tab_label_text (GTK_NOTEBOOK (dialog), list,
																   _("Header Setup"));
	 }

}

/* Sorry Laurent - this was really out of whack with how any of the other
 * dialogs are written. I had to change it. */
/**
 * Header dialog to allow editing of the lilypond header fields
 *
 */
void
header_change (GtkAction * action, struct scoreinfo *si)
{
  GtkWidget *dialog;
  GtkListStore *list_store = NULL;
  GtkTreeIter iter;
 

  g_assert (si != NULL);

  if (si->lily_file)
    return;			/* no code for this yet - just edit textually */

  dialog = gtk_dialog_new_with_buttons (_("Score information"),
					GTK_WINDOW (si->window),
					(GtkDialogFlags)
					(GTK_DIALOG_MODAL |
					 GTK_DIALOG_DESTROY_WITH_PARENT),
					GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
					GTK_STOCK_CANCEL, GTK_STOCK_CANCEL,
					NULL);
  headerfields(dialog, list_store, &iter, si, TRUE);
 


  gtk_widget_show_all (dialog);
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
    {
      gchar *value;
      GString *dest;
      gtk_tree_model_get_iter_first (GTK_TREE_MODEL (list_store), &iter);
      do
	{
	  gtk_tree_model_get (GTK_TREE_MODEL (list_store), &iter,
			      COL_VALUE, &value, COL_PTR, &dest, -1); 
	  g_string_assign (dest, value);
	}
      while (gtk_tree_model_iter_next (GTK_TREE_MODEL (list_store), &iter));
    }
  gtk_widget_destroy (dialog);

}


