import os, sys, urllib2, urlparse, getpass, dputhelper

# Handle valid WebDAV success return values.
class DavErrorProcessor(urllib2.HTTPErrorProcessor):
    def http_response(self, request, response):
        code, msg, hdrs = response.code, response.msg, response.info()
        if code not in range(200, 208):
            response = self.parent.error('http', request, response, code, msg, hdrs)
        return response
    https_response = http_response

# Workaround to support PUT requests in urllib2.
class HttpDavRequest(urllib2.Request):
    def __init__(self, url, data=None, headers={}, origin_req_host=None, unverifiable=False):
        urllib2.Request.__init__(self, url, data, headers, origin_req_host, unverifiable)
    
    def get_method(self):
        # This is very ugly.
        if self.has_data():
            return "PUT"
        else:
            return "GET"

# Custom password manager that prompts for a password using getpass() if
# required, and mangles the saved URL so that only one password is prompted for.
class PromptingPasswordMgr(urllib2.HTTPPasswordMgr):
    def __init__(self, username):
        urllib2.HTTPPasswordMgr.__init__(self)
        self.username = username

    def find_user_password(self, realm, authuri):
        # Hack so that we only prompt for a password once
        authuri = self.reduce_uri(authuri)[0]
        authinfo = urllib2.HTTPPasswordMgr.find_user_password(self, realm, authuri)
        if authinfo != (None, None):
            return authinfo

        password = getpass.getpass("Password for %s:" % realm)
        self.add_password(realm, authuri, self.username, password)
        return (self.username, password)


# Upload the files via WebDAV
def upload(fqdn, login, incoming, files_to_upload, debug, dummy, protocol="http"):
    authhandler = urllib2.HTTPBasicAuthHandler(PromptingPasswordMgr(login))
    opener = urllib2.build_opener(authhandler, DavErrorProcessor())
    urllib2.install_opener(opener)

    baseurl = urlparse.urlunsplit((protocol, fqdn, incoming, None, None))

    for afile in files_to_upload:
        path_to_package, package_name = os.path.split(afile)
        url = urlparse.urljoin(baseurl, package_name)
        try:
            if debug:
                print "D: HTTP-Connection to URL: %s" % url
            request = HttpDavRequest(url, ''.join(open(afile).readlines()))
            response = opener.open(request)
        except urllib2.HTTPError, e:
	  if e.code==401:
	    print "Upload failed: %s"%e.msg
	    print "  Maybe wrong username or password?"
	  else:
	    print "Connection failed, aborting. Check your network."
	    print e
          sys.exit(1)
