#!/usr/local/bin/perl

# FILE:   lat2ansi
# DOEL:   conversie van Latin1 naar ANSI en vice versa. Het korte
#         streepje (\255) uit ISO Latin1 ontbreekt in ANSI. Daarom wordt
#         hiervoor een punt (\372) gekozen. Het `tr' commando (translate)
#         is opgesplitst in meerder regels vanwege de leesbaarheid. Let
#	  op dat hierdoor karakters niet tweemaal geconverteerd worden
#	  zoals in mijn vorige versie.
#
# AUTEUR: Piet Tutelaers
# VERSIE: 1.3 (october 1996)

do 'getopts.pl';

&Getopts('rh') || die &usage;

if ($opt_h) { &help; }

while (<>) {
   if ($opt_r) { # ANSI naar Latin1, remove MSDOS \r
      s/\r\n$/\n/;
      tr/\372\233\242\243/\255\242\363\372/;            # 
      tr/\200\201\202\203\245/\307\374\351\342\321/;    # 
      tr/\204\205\206\207\210/\344\340\345\347\352/;	# 
      tr/\211\212\213\214\215/\353\350\357\356\354/;	# 
      tr/\216\217\220\221\222/\304\305\311\346\306/;	# 
      tr/\223\224\225\226\227/\364\366\362\373\371/;	# 
      tr/\231\232\240\241\244/\326\334\341\355\361/;	# 
   }
   else {       # Latin1 naar ANSI, add MSDOS \r
      s/\n$/\r\n/ unless /\r\n$/;
      tr/\255\242\363\372/\372\233\242\243/;            # 
      tr/\307\374\351\342\321/\200\201\202\203\245/;    # 
      tr/\344\340\345\347\352/\204\205\206\207\210/;	# 
      tr/\353\350\357\356\354/\211\212\213\214\215/;	# 
      tr/\304\305\311\346\306/\216\217\220\221\222/;	# 
      tr/\364\366\362\373\371/\223\224\225\226\227/;	# 
      tr/\326\334\341\355\361/\231\232\240\241\244/;	# 
   }
   print;
}

sub help
{
   print &usage;
   print <<HELP;

BEKNOPTE UITLEG:
	Lat2ansi converteert een Latin1 bestand naar ANSI, de MSDOS
        uitbreiding van ASCII. Of omgekeerd van ANSI naar Latin1 met
	de optie -r. Een voorbeeld (latin1.txt moet identiek zijn met
        latin2.txt):

	   lat2ansi latin1.txt | lat2ansi -r > latin2.txt
   
HELP
   exit(0);
}

sub usage
{
   return "Gebruik: lat2ansi [-h] [-r] [ file ... ]\n";
}

