/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libbsd.so
 *
 *   File: bsd_disklabel.h
 */

#ifndef _BSD_DISKLABEL_H
#define _BSD_DISKLABEL_H 1


/*

  Some BSD Info...
  
  
  The very first sector may hold a "slice table" in BSD parlance.  In this
  case, our msdos segment manager will look at the partition table and find
  a primary partition of type 0xa9. Which will cause it to look for a BSD 
  disklabel in sector 1.  This is known as BSD compatibiltiy mode disk:
  
  compatibility disk - setting up a disk so that it has a partition table 
	 	       that is compatible with other operating systems.
  
  But a BSD system can use the entire disk and not provide a compatibility 
  partition table for other operating systems to use.  In this case, the 
  BSD disklabel is found in the very first sector on the disk.  The evms
  msdos segment manager won't discover this because the compatiblity MBR
  partition table will be missing ... along with the MSDOS signature.  So,
  this segment manager is used for non compatibility BSD disk ... which are
  also known as ... dedicated mode disks or sometimes ... dangerously dedicated
  disks.  
  
  dedicated disk - has no slice table that would provide compatiblity with 
                   another operating system. Instead, it has the BSD disklabel
		   in sector Zero.  
  

  bsd disk labeling follows these rules:
 
         bsd partitions are identified by letters (a, b, c...) instead of numbers. 

         The partition types are different. For example, "83" and "82" no longer 
	 correspond to "Linux" and "Linux Swap," respectively. A Linux native partition
         is identified as BSD_TAG_MSDOS and the Linux swap partition is BSD_TAG_SWAP.. 

         There is a usual maximum of eight partitions (a to h) per drive. 

         The first partition should start on cylinder 2.  This leaves room on the 
	 disk for system programs (boot stuff).  In fact, you will see some partitions
	 in the BSD partition table that have size/length info but no file system
	 info and these partitions are describing the location of the system info on 
	 the drive. So, basically the 1st cylinder on a BSD disk is reserved for use
	 by the OS.	  
   
*/	       
	       

	       
// partition fs types
#define BSD_TAG_UNUSED   0x0000  // unused slice
#define BSD_TAG_SWAP     0x0001  // swap fs
#define BSD_TAG_VERS6    0x0002  // 6th version
#define BSD_TAG_VERS7    0x0003  // 7th version
#define BSD_TAG_SYSV     0x0004  // system 5
#define BSD_TAG_VERS7k   0x0005  // 7th version with 1k blocks
#define BSD_TAG_VERS8    0x0006  // 8th version
#define BSD_TAG_FASTBSD  0x0007  // fast bsd
#define BSD_TAG_MSDOS    0x0008  // msdos
#define BSD_TAG_LFSBSD   0x0009  // logging bsd
#define BSD_TAG_OTHER    0x000a  // unknown
#define BSD_TAG_HPFS     0x000b  // os2 hpfs
#define BSD_TAG_ISO9660  0x000c  // ISO
#define BSD_TAG_BOOT     0x000d  // boot code
#define BSD_TAG_AMIGA    0x000e  // amiga dos
#define BSD_TAG_MAC      0x000f  // mac hfs
#define BSD_TAG_ACORN    0x0010  // acorn file system
#define BSD_TAG_EXT2     0x0011  // ext2
#define BSD_TAG_NTFS     0x0012  // NT file system


#ifdef NEED_BSD_NAMES

#define BSD_TAG_NAME_COUNT 19
static const char *bsd_names[BSD_TAG_NAME_COUNT]={
     "UNUSED",
     "SWAP",
     "VERS 6",
     "VERS 7",
     "SYSTEM V",
     "VERS 7",
     "VERS 8",
     "BSD",
     "MSDOS",
     "LOGGING BSD",
     "UNKNOWN",
     "HPFS",
     "ISO9660",
     "BOOT",
     "AMIGA DOS",
     "MAC",
     "ACORN",
     "EXT2",
     "NTFS"
};

#endif


/*
 * BSD disklabel support by Yossi Gottlieb <yogo@math.tau.ac.il>
 * updated by Marc Espie <Marc.Espie@openbsd.org>
 */

/* check against BSD src/sys/sys/disklabel.h for consistency */

#define BSD_DISKMAGIC   (0x82564557UL)  /* The disk magic number */
#define BSD_MAXPARTITIONS   8
#define OPENBSD_MAXPARTITIONS   16
#define BSD_FS_UNUSED       0   /* disklabel unused partition entry ID */
typedef struct bsd_disklabel {
    u_int32_t   d_magic;        /* the magic number */
    int16_t     d_type;         /* drive type */
    int16_t     d_subtype;      /* controller/d_type specific */
    int8_t      d_typename[16];     /* type name, e.g. "eagle" */
    int8_t      d_packname[16];         /* pack identifier */
    u_int32_t   d_secsize;      /* # of bytes per sector */
    u_int32_t   d_nsectors;     /* # of data sectors per track */
    u_int32_t   d_ntracks;      /* # of tracks per cylinder */
    u_int32_t   d_ncylinders;       /* # of data cylinders per unit */
    u_int32_t   d_secpercyl;        /* # of data sectors per cylinder */
    u_int32_t   d_secperunit;       /* # of data sectors per unit */
    u_int16_t   d_sparespertrack;   /* # of spare sectors per track */
    u_int16_t   d_sparespercyl;     /* # of spare sectors per cylinder */
    u_int32_t   d_acylinders;       /* # of alt. cylinders per unit */
    u_int16_t   d_rpm;          /* rotational speed */
    u_int16_t   d_interleave;       /* hardware sector interleave */
    u_int16_t   d_trackskew;        /* sector 0 skew, per track */
    u_int16_t   d_cylskew;      /* sector 0 skew, per cylinder */
    u_int32_t   d_headswitch;       /* head switch time, usec */
    u_int32_t   d_trkseek;      /* track-to-track seek, usec */
    u_int32_t   d_flags;        /* generic flags */
#define NDDATA 5
    u_int32_t   d_drivedata[NDDATA];    /* drive-type specific information */
#define NSPARE 5
    u_int32_t   d_spare[NSPARE];    /* reserved for future use */
    u_int32_t   d_magic2;       /* the magic number (again) */
    u_int16_t   d_checksum;     /* xor of data incl. partitions */

            /* filesystem and partition information: */
    u_int16_t   d_npartitions;      /* number of partitions in following */
    u_int32_t   d_bbsize;       /* size of boot area at sn0, bytes */
    u_int32_t   d_sbsize;       /* max size of fs superblock, bytes */
    struct  bsd_partition {     /* the partition table */
        u_int32_t   p_size;     /* number of sectors in partition */
        u_int32_t   p_offset;   /* starting sector */
        u_int32_t   p_fsize;    /* filesystem basic fragment size */
        u_int8_t    p_fstype;   /* filesystem type, see below */
        u_int8_t    p_frag;     /* filesystem fragments per block */
        u_int16_t   p_cpg;      /* filesystem cylinders per group */
    } d_partitions[BSD_MAXPARTITIONS];  /* actually may be more */
} bsd_disklabel_t;


typedef struct bsd_partition bsd_partition_t;


#endif


