/*
 *   (C) Copyright IBM Corp. 2006
 *   (C) Copyright ALT Linux Ltd. 2006
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: FAT FSIM
 * File: evms2/engine/plugins/fat/fatfsim.h
 */

#ifndef _FATFSIM_H_
#define _FATFSIM_H_ 1

extern plugin_record_t *my_plugin_record;
extern engine_functions_t *EngFncs;
extern boolean have_fatresize;

typedef struct private_data_s {
	sector_count_t		fs_size;
	sector_count_t		max_fs_size;
	sector_count_t		max_vol_size;
	u_int32_t		cluster_size;
	u_int16_t		logical_sector_size;
	char			*vol_name;
	u_int32_t		vol_id;
	u_int32_t		flags;
} private_data_t;

/* mkfs option array indices */
#define MKFS_LABEL_INDEX         0
#define MKFS_LABEL_NAME          "label"
#define MKFS_OPTIONS_COUNT       1

#define MAX_LABEL_LEN            11

#endif

