/*
 *
 *   (C) Copyright IBM Corp. 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libmac.so
 *
 *   File: options.h
 */

#ifndef   _MAC_OPTIONS_HEADER
#define   _MAC_OPTIONS_HEADER                        1


//
//  Seg Info
//
#define SEG_INFO_COUNT                              4
#define SEG_INFO_TYPE_INDEX                         0
#define SEG_INFO_NAME_INDEX                         1
#define SEG_INFO_START_INDEX                        2
#define SEG_INFO_SIZE_INDEX                         3

//
//  Metadata Info
//
#define MAC_LABEL_INFO_COUNT                        0  // 5
#define MAC_INFO_GEO_INDEX                          0
#define MAC_INFO_SECTORSIZE_INDEX                   1
#define MAC_INFO_PCOUNT_INDEX                       2
#define MAC_INFO_BOOTSIZE_INDEX                     3
#define MAC_INFO_SBSIZE_INDEX                       4



//
//  Plugin Info
//
#define PLUGIN_INFO_COUNT                           6
#define PLUGIN_INFO_SNAME_INDEX                     0
#define PLUGIN_INFO_LNAME_INDEX                     1
#define PLUGIN_INFO_TYPE_INDEX                      2
#define PLUGIN_INFO_VERSION_INDEX                   3
#define PLUGIN_INFO_REQENGSVCVERSION_INDEX          4
#define PLUGIN_INFO_REQPLUGAPIVERSION_INDEX         5





int         mac_get_segment_info( storage_object_t  * object, extended_info_array_t **info);

int         mac_get_metadata_info(storage_object_t * object, extended_info_array_t **info_array);

int         mac_get_plugin_info( char * descriptor_name, extended_info_array_t * * info );

#endif

