/*
 *   (C) Copyright IBM Corp. 2004
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: utils.h
 *
 */

extern int has_ntfs_boot_sector(logical_volume_t * ev);

extern int clear_ntfs_boot_sectors(logical_volume_t * ev);

extern int try_run(char * prog_name);

extern int get_version_from_fd(int fd, char * version);

extern int try_run_get_version(char * prog_name, char * version);

extern int get_field_number_value(char * buffer, char * field_name,
				  u_int64_t * number);

extern int get_field_string_value(char * buffer, char * field_name,
				  char * * string);
extern sector_count_t get_min_fs_size(logical_volume_t * vol);


extern int fill_private_data(logical_volume_t * vol);

extern void free_private_data(logical_volume_t * vol);

extern logical_volume_t * find_volume(char * name);

extern int resize_ntfs(logical_volume_t * volume, sector_count_t * new_size);

extern int run_ntfsfix(logical_volume_t * volume);

extern int run_ntfsclone(logical_volume_t * source,
			 logical_volume_t * target,
			 boolean            force);

extern int is_acceptable_clone_target(logical_volume_t * source,
				      logical_volume_t * target);
