# (c) 2005 Canonical, GPL

from SimpleGladeApp import SimpleGladeApp
import gtk
import os
from gettext import gettext as _
import gettext
from BrowserView import GtkHtml2BrowserView as BrowserView


# FIXME: this should be renamed to something like
#        DialogComponentEnable()
# 
class DialogUnavailable(SimpleGladeApp):

    def __init__(self, datadir, parent, item, need_internet=True):
        SimpleGladeApp.__init__(self,
                                path=datadir+"/gnome-app-install.glade",
                                root="dialog_unavailable",
                                domain="gnome-app-install")
        # Keep this strings in sync with the ones in the app description of the main window,
        # to minimize the translation work
        #FIXME: also mention the security updates
        if item.component == "main":
            header = _("Install supported Ubuntu software?")
            msg = _("%s is part of the Ubuntu main distribution.") % item.name
        elif item.component == "universe":
            header = _("Install community maintained software?")
            msg = _("%s is maintained by the Ubuntu community.") % item.name
        elif item.component == "multiverse":
            header = _("Install unsupported and restricted software?")
            msg = _("The use, modification and distribution of %s "
                    "is restricted by copyright or by legal terms in "
                    "some countries.") % item.name
        elif item.component:
            # Only a fallback
            header = _("Install software from the %s component of Ubuntu?") % item.component
            msg = _("%s is not officially supported with security updates.") % item.name
        elif item.channel:
            header = _("Install software from %s?") % item.channel
            msg = _("%s is provided by a third party vendor. The third party vendor "
                    "is responsible for support and security updates.") % item.name
        if need_internet:
            msg += "\n\n%s" % _("You need a working internet connection to continue.")
        self.button_unavailable_add.set_label(_("_Install"))
        self.dialog_unavailable.set_transient_for(parent)
        self.dialog_unavailable.realize()
        self.dialog_unavailable.window.set_functions(gtk.gdk.FUNC_MOVE)
        self.unavailable_label.set_markup("<b><big>%s</big></b>\n\n%s" %
                                          (header, msg))

    def run(self):
        return self.dialog_unavailable.run()

    def hide(self):
        self.dialog_unavailable.hide()


