# copied from CDBS' buildvars
DEB_SOURCE_PACKAGE ?= $(strip $(shell egrep '^Source: ' debian/control | cut -f 2 -d ':'))
DEB_VERSION ?= $(shell dpkg-parsechangelog | egrep '^Version:' | cut -f 2 -d ' ')
DEB_NOEPOCH_VERSION ?= $(shell echo $(DEB_VERSION) | cut -d: -f2-)
DEB_UPSTREAM_VERSION ?= $(shell echo $(DEB_NOEPOCH_VERSION) | sed 's/-[^-]*$$//')

# compute the major.minor part of the upstream version
DEB_UPSTREAM_VERSION_MAJOR_MINOR := $(shell echo $(DEB_UPSTREAM_VERSION) | sed -r -n 's/^([0-9]+\.[0-9]+).*/\1/p')

# where to store the resulting .orig tarball
DEB_TARBALL_DOWNLOAD_DIR ?= ../tarballs

# whether to generate a tarball in tarball (dbs format); default is to use the
# upstream tarball, set to non-empty to change this behavior
DEB_USE_DBS_TARBALL_LAYOUT ?=

GNOME_MODULE ?= $(DEB_SOURCE_PACKAGE)
GNOME_TARBALL ?= $(GNOME_MODULE)-$(DEB_UPSTREAM_VERSION).tar.gz
GNOME_DOWNLOAD_URL ?= http://ftp.gnome.org/pub/GNOME/sources/$(GNOME_MODULE)/$(DEB_UPSTREAM_VERSION_MAJOR_MINOR)/$(GNOME_TARBALL)
GNOME_DOWNLOAD_COMMAND ?= wget -N -nv -T10 -t3 -O $(if $(DEB_USE_DBS_TARBALL_LAYOUT),$(DEB_TARBALL_DOWNLOAD_DIR)/$(GNOME_TARBALL),$(DEB_TARBALL_DOWNLOAD_DIR)/$(DEB_SOURCE_PACKAGE)_$(DEB_UPSTREAM_VERSION).orig.tar.gz) $(GNOME_DOWNLOAD_URL)

get-orig-source:
	dh_testdir
	@@echo 'Source package:                      $(DEB_SOURCE_PACKAGE)'
	@@echo 'Source package:                      $(DEB_VERSION)'
	@@echo 'Source version without epoch:        $(DEB_NOEPOCH_VERSION)'
	@@echo 'Upstream version (for orig tarball): $(DEB_UPSTREAM_VERSION)'
	mkdir -p $(DEB_TARBALL_DOWNLOAD_DIR)
	$(GNOME_DOWNLOAD_COMMAND)
	@# create a dbs tarball if necessary
	$(if $(DEB_USE_DBS_TARBALL_LAYOUT),gnome-make-tartar $(DEB_TARBALL_DOWNLOAD_DIR)/$(GNOME_TARBALL) $(DEB_SOURCE_PACKAGE) $(DEB_UPSTREAM_VERSION))
	@# remove the original tarball if necessary
	$(if $(DEB_USE_DBS_TARBALL_LAYOUT),rm -f $(DEB_TARBALL_DOWNLOAD_DIR)/$(GNOME_TARBALL))

.PHONY: get-orig-source print-version
