dnl macros for X-related detections
dnl AC_SUBST's HAVE_X, X_CFLAGS, X_LIBS
AC_DEFUN([AG_GST_CHECK_X],
[
  AC_PATH_XTRA
  ac_cflags_save="$CFLAGS"
  ac_cppflags_save="$CPPFLAGS"
  CFLAGS="$CFLAGS $X_CFLAGS"
  CPPFLAGS="$CPPFLAGS $X_CFLAGS"

  dnl now try to find the HEADER
  AC_CHECK_HEADER(X11/Xlib.h, HAVE_X="yes", HAVE_X="no")

  if test "x$HAVE_X" = "xno"
  then
    AC_MSG_NOTICE([cannot find X11 development files])
  else
    dnl this is much more than we want
    X_LIBS="$X_LIBS $X_PRE_LIBS $X_EXTRA_LIBS"
    dnl AC_PATH_XTRA only defines the path needed to find the X libs,
    dnl it does not add the libs; therefore we add them here
    X_LIBS="$X_LIBS -lX11"
    AC_SUBST(X_CFLAGS)
    AC_SUBST(X_LIBS)
  fi
  AC_SUBST(HAVE_X)
])

dnl *** XVideo ***
dnl Look for the PIC library first, Debian requires it.
dnl Check debian-devel archives for gory details.
dnl 20020110:
dnl At the moment XFree86 doesn't distribute shared libXv due
dnl to unstable API.  On many platforms you CAN NOT link a shared
dnl lib to a static non-PIC lib.  This is what the xvideo GStreamer
dnl plug-in wants to do.  So Debian distributes a PIC compiled
dnl version of the static lib for plug-ins to link to when it is
dnl inappropriate to link the main application to libXv directly.
dnl FIXME: add check if this platform can support linking to a
dnl        non-PIC libXv, if not then don not use Xv.
dnl FIXME: perhaps warn user if they have a shared libXv since
dnl        this is an error until XFree86 starts shipping one
AC_DEFUN([AG_GST_CHECK_XV],
[
  if test x$HAVE_X = xyes; then
    AC_CHECK_LIB(Xv_pic, XvQueryExtension,
                 HAVE_XVIDEO="yes", HAVE_XVIDEO="no",
                 $X_LIBS -lXext)

    if test x$HAVE_XVIDEO = xyes; then
      XVIDEO_LIBS="-lXv_pic -lXext"
      AC_SUBST(XVIDEO_LIBS)
    else
      dnl try again using something else if we didn't find it first
      if test x$HAVE_XVIDEO = xno; then
        AC_CHECK_LIB(Xv, XvQueryExtension,
                   HAVE_XVIDEO="yes", HAVE_XVIDEO="no",
                   $X_LIBS -lXext)

        if test x$HAVE_XVIDEO = xyes; then
          XVIDEO_LIBS="-lXv -lXext"
          AC_SUBST(XVIDEO_LIBS)
        fi
      fi
    fi
  fi
])
