// Copyright (C) 2000-2005, Luca Padovani <luca.padovani@cs.unibo.it>.
//
// This file is part of GtkMathView, a Gtk widget for MathML.
// 
// GtkMathView is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// GtkMathView is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with GtkMathView; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
// For details, see the GtkMathView World-Wide-Web page,
// http://helm.cs.unibo.it/mml-widget/, or send a mail to
// <lpadovan@cs.unibo.it>

#include "TFM.hh"

static TFM::Font font = {
"CMSSI",

  0xdb,
  "TeX text",
  0x01147ae0,
  0xa08fee75,
  7,
  128
};

static TFM::Dimension dimension[] = {
  { 0x01, "slant", 0x000366a0 },
  { 0x02, "space", 0x000503f1 },
  { 0x03, "space_stretch", 0x000281f8 },
  { 0x04, "space_shrink", 0x0001abfb },
  { 0x05, "x_height", 0x0006e34b },
  { 0x06, "quad", 0x000f0bd3 },
  { 0x07, "extra_space", 0x0001abfb }
};


static TFM::Kerning C_0b_Kerning[] = {
  { 0x21, 0x00010b7d },
  { 0x27, 0x00010b7d },
  { 0x29, 0x00010b7d },
  { 0x3f, 0x00010b7d },
  { 0x5d, 0x00010b7d }
};

static TFM::Kerning C_20_Kerning[] = {
  { 0x4c, 0xfffc2600 },
  { 0x6c, 0xfffc7012 }
};

static TFM::Kerning C_27_Kerning[] = {
  { 0x21, 0x0001abfb },
  { 0x3f, 0x0001abfb }
};

static TFM::Kerning C_41_Kerning[] = {
  { 0x43, 0xffff9501 },
  { 0x47, 0xffff9501 },
  { 0x4f, 0xffff9501 },
  { 0x51, 0xffff9501 },
  { 0x54, 0xfffebf04 },
  { 0x55, 0xffff9501 },
  { 0x56, 0xfffe5405 },
  { 0x57, 0xfffe5405 },
  { 0x59, 0xfffebf04 },
  { 0x74, 0xffff9501 }
};

static TFM::Kerning C_44_Kerning[] = {
  { 0x41, 0xffff9501 },
  { 0x56, 0xffff9501 },
  { 0x57, 0xffff9501 },
  { 0x58, 0xffff9501 },
  { 0x59, 0xffff9501 }
};

static TFM::Kerning C_46_Kerning[] = {
  { 0x41, 0xfffebf04 },
  { 0x43, 0xffff9501 },
  { 0x47, 0xffff9501 },
  { 0x4f, 0xffff9501 },
  { 0x51, 0xffff9501 },
  { 0x61, 0xffff9501 },
  { 0x65, 0xffff9501 },
  { 0x6f, 0xffff9501 },
  { 0x72, 0xffff9501 },
  { 0x75, 0xffff9501 }
};

static TFM::Kerning C_49_Kerning[] = {
  { 0x49, 0x00006aff }
};

static TFM::Kerning C_4b_Kerning[] = {
  { 0x43, 0xffff9501 },
  { 0x47, 0xffff9501 },
  { 0x4f, 0xffff9501 },
  { 0x51, 0xffff9501 }
};

static TFM::Kerning C_4c_Kerning[] = {
  { 0x54, 0xfffebf04 },
  { 0x56, 0xfffe5405 },
  { 0x57, 0xfffe5405 },
  { 0x59, 0xfffebf04 }
};

static TFM::Kerning C_4f_Kerning[] = {
  { 0x41, 0xffff9501 },
  { 0x56, 0xffff9501 },
  { 0x57, 0xffff9501 },
  { 0x58, 0xffff9501 },
  { 0x59, 0xffff9501 }
};

static TFM::Kerning C_50_Kerning[] = {
  { 0x2c, 0xfffebf04 },
  { 0x2e, 0xfffebf04 },
  { 0x41, 0xfffebf04 },
  { 0x61, 0xffff9501 },
  { 0x65, 0xffff9501 },
  { 0x6f, 0xffff9501 }
};

static TFM::Kerning C_54_Kerning[] = {
  { 0x41, 0xfffebf04 },
  { 0x61, 0xfffebf04 },
  { 0x65, 0xfffebf04 },
  { 0x6f, 0xfffebf04 },
  { 0x72, 0xfffebf04 },
  { 0x75, 0xfffebf04 },
  { 0x79, 0xfffebf04 }
};

static TFM::Kerning C_56_Kerning[] = {
  { 0x41, 0xfffebf04 },
  { 0x43, 0xffff9501 },
  { 0x47, 0xffff9501 },
  { 0x4f, 0xffff9501 },
  { 0x51, 0xffff9501 },
  { 0x61, 0xffff9501 },
  { 0x65, 0xffff9501 },
  { 0x6f, 0xffff9501 },
  { 0x72, 0xffff9501 },
  { 0x75, 0xffff9501 }
};

static TFM::Kerning C_57_Kerning[] = {
  { 0x41, 0xfffebf04 },
  { 0x43, 0xffff9501 },
  { 0x47, 0xffff9501 },
  { 0x4f, 0xffff9501 },
  { 0x51, 0xffff9501 },
  { 0x61, 0xffff9501 },
  { 0x65, 0xffff9501 },
  { 0x6f, 0xffff9501 },
  { 0x72, 0xffff9501 },
  { 0x75, 0xffff9501 }
};

static TFM::Kerning C_58_Kerning[] = {
  { 0x43, 0xffff9501 },
  { 0x47, 0xffff9501 },
  { 0x4f, 0xffff9501 },
  { 0x51, 0xffff9501 }
};

static TFM::Kerning C_59_Kerning[] = {
  { 0x41, 0xfffebf04 },
  { 0x61, 0xfffebf04 },
  { 0x65, 0xfffebf04 },
  { 0x6f, 0xfffebf04 },
  { 0x72, 0xfffebf04 },
  { 0x75, 0xfffebf04 }
};

static TFM::Kerning C_61_Kerning[] = {
  { 0x72, 0xffff9501 },
  { 0x77, 0xffff9501 },
  { 0x79, 0xffff9501 }
};

static TFM::Kerning C_62_Kerning[] = {
  { 0x63, 0x00006aff },
  { 0x64, 0x00006aff },
  { 0x65, 0x00006aff },
  { 0x6f, 0x00006aff },
  { 0x71, 0x00006aff },
  { 0x72, 0xffff9501 },
  { 0x77, 0xffff9501 },
  { 0x78, 0xffff9501 },
  { 0x79, 0xffff9501 }
};

static TFM::Kerning C_66_Kerning[] = {
  { 0x21, 0x00010b7d },
  { 0x27, 0x00010b7d },
  { 0x29, 0x00010b7d },
  { 0x3f, 0x00010b7d },
  { 0x5d, 0x00010b7d }
};

static TFM::Kerning C_67_Kerning[] = {
  { 0x6a, 0x00006aff }
};

static TFM::Kerning C_6b_Kerning[] = {
  { 0x61, 0xffff9501 },
  { 0x63, 0xffff9501 },
  { 0x65, 0xffff9501 },
  { 0x6f, 0xffff9501 }
};

static TFM::Kerning C_6f_Kerning[] = {
  { 0x63, 0x00006aff },
  { 0x64, 0x00006aff },
  { 0x65, 0x00006aff },
  { 0x6f, 0x00006aff },
  { 0x71, 0x00006aff },
  { 0x72, 0xffff9501 },
  { 0x77, 0xffff9501 },
  { 0x78, 0xffff9501 },
  { 0x79, 0xffff9501 }
};

static TFM::Kerning C_70_Kerning[] = {
  { 0x63, 0x00006aff },
  { 0x64, 0x00006aff },
  { 0x65, 0x00006aff },
  { 0x6f, 0x00006aff },
  { 0x71, 0x00006aff },
  { 0x72, 0xffff9501 },
  { 0x77, 0xffff9501 },
  { 0x78, 0xffff9501 },
  { 0x79, 0xffff9501 }
};

static TFM::Kerning C_74_Kerning[] = {
  { 0x77, 0xffff9501 },
  { 0x79, 0xffff9501 }
};

static TFM::Kerning C_75_Kerning[] = {
  { 0x77, 0xffff9501 }
};

static TFM::Kerning C_77_Kerning[] = {
  { 0x61, 0xffff9501 },
  { 0x63, 0xffff9501 },
  { 0x65, 0xffff9501 },
  { 0x6f, 0xffff9501 }
};

static TFM::Kerning C_79_Kerning[] = {
  { 0x2c, 0xfffebf04 },
  { 0x2e, 0xfffebf04 },
  { 0x61, 0xffff9501 },
  { 0x65, 0xffff9501 },
  { 0x6f, 0xffff9501 }
};

static TFM::Ligature C_0b_Ligature[] = {
  { 0x69, 0x00, 0x0e },
  { 0x6c, 0x00, 0x0f }
};

static TFM::Ligature C_21_Ligature[] = {
  { 0x60, 0x00, 0x3c }
};

static TFM::Ligature C_27_Ligature[] = {
  { 0x27, 0x00, 0x22 }
};

static TFM::Ligature C_2d_Ligature[] = {
  { 0x2d, 0x00, 0x7b }
};

static TFM::Ligature C_3f_Ligature[] = {
  { 0x60, 0x00, 0x3e }
};

static TFM::Ligature C_60_Ligature[] = {
  { 0x60, 0x00, 0x5c }
};

static TFM::Ligature C_66_Ligature[] = {
  { 0x66, 0x00, 0x0b },
  { 0x69, 0x00, 0x0c },
  { 0x6c, 0x00, 0x0d }
};

static TFM::Ligature C_7b_Ligature[] = {
  { 0x2d, 0x00, 0x7c }
};


static TFM::Character character[] = {
  { 0x00, 0x000823ee, 0x000b1c72, 0x00000000, 0x00003997, 0, 0, 0, 0 },
  { 0x01, 0x000c89da, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x02, 0x000bb3dd, 0x000b1c72, 0x00000000, 0x00006f6d, 0, 0, 0, 0 },
  { 0x03, 0x00092803, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x04, 0x000a07e2, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x05, 0x000a9c07, 0x000b1c72, 0x00000000, 0x0000ca94, 0, 0, 0, 0 },
  { 0x06, 0x000adddf, 0x000b1c72, 0x00000000, 0x0000d217, 0, 0, 0, 0 },
  { 0x07, 0x000bb3dd, 0x000b1c72, 0x00000000, 0x00005067, 0, 0, 0, 0 },
  { 0x08, 0x000adddf, 0x000b1c72, 0x00000000, 0x0000c34e, 0, 0, 0, 0 },
  { 0x09, 0x000bb3dd, 0x000b1c72, 0x00000000, 0x00005067, 0, 0, 0, 0 },
  { 0x0a, 0x000adddf, 0x000b1c72, 0x00000000, 0x0000b490, 0, 0, 0, 0 },
  { 0x0b, 0x0008c6e6, 0x000b1c72, 0x00000000, 0x00006f6d, 5, C_0b_Kerning, 2, C_0b_Ligature },
  { 0x0c, 0x00080ce4, 0x000b1c72, 0x00000000, 0x000086d7, 0, 0, 0, 0 },
  { 0x0d, 0x00080ce4, 0x000b1c72, 0x00000000, 0x000084d3, 0, 0, 0, 0 },
  { 0x0e, 0x000c3ad7, 0x000b1c72, 0x00000000, 0x000086d7, 0, 0, 0, 0 },
  { 0x0f, 0x000c3ad7, 0x000b1c72, 0x00000000, 0x000084d3, 0, 0, 0, 0 },
  { 0x10, 0x00038fee, 0x0006e34b, 0x00000000, 0x0000b490, 0, 0, 0, 0 },
  { 0x11, 0x0003faec, 0x0006e34b, 0x00031cb5, 0x0000b490, 0, 0, 0, 0 },
  { 0x12, 0x000785e9, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x13, 0x000785e9, 0x000b1c72, 0x00000000, 0x00006ea2, 0, 0, 0, 0 },
  { 0x14, 0x000785e9, 0x000a0e28, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x15, 0x000785e9, 0x000b1c72, 0x00000000, 0x00008025, 0, 0, 0, 0 },
  { 0x16, 0x000785e9, 0x000999ce, 0x00000000, 0x00003875, 0, 0, 0, 0 },
  { 0x17, 0x000b3068, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x18, 0x0006afec, 0x00000000, 0x0002b91f, 0x00000000, 0, 0, 0, 0 },
  { 0x19, 0x000736e7, 0x000b1c72, 0x00000000, 0x00006ea2, 0, 0, 0, 0 },
  { 0x1a, 0x000adddf, 0x0006e34b, 0x00000000, 0x00005067, 0, 0, 0, 0 },
  { 0x1b, 0x000bb3dd, 0x0006e34b, 0x00000000, 0x00005067, 0, 0, 0, 0 },
  { 0x1c, 0x000785e9, 0x000871a6, 0x00018e5b, 0x0000d217, 0, 0, 0, 0 },
  { 0x1d, 0x000cefe8, 0x000b1c72, 0x00000000, 0x0000d217, 0, 0, 0, 0 },
  { 0x1e, 0x000e9be3, 0x000b1c72, 0x00000000, 0x0000d217, 0, 0, 0, 0 },
  { 0x1f, 0x000bb3dd, 0x000be3a0, 0x0000c72e, 0x00006f6d, 0, 0, 0, 0 },
  { 0x20, 0x00038fee, 0x0006e34b, 0x00000000, 0x00000000, 2, C_20_Kerning, 0, 0 },
  { 0x21, 0x0004cbfa, 0x000b1c72, 0x00000000, 0x00003875, 0, 0, 1, C_21_Ligature },
  { 0x22, 0x000785e9, 0x000b1c72, 0x00000000, 0x00003875, 0, 0, 0, 0 },
  { 0x23, 0x000c89da, 0x000b1c72, 0x00031cb5, 0x0000ca94, 0, 0, 0, 0 },
  { 0x24, 0x000785e9, 0x000bfc50, 0x0000dfde, 0x0000b490, 0, 0, 0, 0 },
  { 0x25, 0x000c89da, 0x000bfc50, 0x0000dfde, 0x000086d7, 0, 0, 0, 0 },
  { 0x26, 0x000b64da, 0x000b1c72, 0x00000000, 0x000084d3, 0, 0, 0, 0 },
  { 0x27, 0x00042df3, 0x000b1c72, 0x00000000, 0x0000a03d, 2, C_27_Kerning, 1, C_27_Ligature },
  { 0x28, 0x0005d9ee, 0x000bfc50, 0x0003fc93, 0x00003875, 0, 0, 0, 0 },
  { 0x29, 0x0005d9ee, 0x000bfc50, 0x0003fc93, 0x00006ea2, 0, 0, 0, 0 },
  { 0x2a, 0x000785e9, 0x000bfc50, 0x00000000, 0x0000ca94, 0, 0, 0, 0 },
  { 0x2b, 0x000bb3dd, 0x000903cf, 0x00010413, 0x00006ea2, 0, 0, 0, 0 },
  { 0x2c, 0x00042df3, 0x00014938, 0x00020195, 0x00000000, 0, 0, 0, 0 },
  { 0x2d, 0x000503f1, 0x0006e34b, 0x00000000, 0x00005067, 0, 0, 1, C_2d_Ligature },
  { 0x2e, 0x00042df3, 0x00014938, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x2f, 0x000785e9, 0x000bfc50, 0x0003fc93, 0x00003875, 0, 0, 0, 0 },
  { 0x30, 0x000785e9, 0x000a7e6b, 0x00000000, 0x0000b490, 0, 0, 0, 0 },
  { 0x31, 0x000785e9, 0x000a7e6b, 0x00000000, 0x0000b490, 0, 0, 0, 0 },
  { 0x32, 0x000785e9, 0x000a7e6b, 0x00000000, 0x0000b490, 0, 0, 0, 0 },
  { 0x33, 0x000785e9, 0x000a7e6b, 0x00000000, 0x0000b490, 0, 0, 0, 0 },
  { 0x34, 0x000785e9, 0x000a7e6b, 0x00000000, 0x0000b490, 0, 0, 0, 0 },
  { 0x35, 0x000785e9, 0x000a7e6b, 0x00000000, 0x0000b490, 0, 0, 0, 0 },
  { 0x36, 0x000785e9, 0x000a7e6b, 0x00000000, 0x0000b490, 0, 0, 0, 0 },
  { 0x37, 0x000785e9, 0x000a7e6b, 0x00000000, 0x0000b490, 0, 0, 0, 0 },
  { 0x38, 0x000785e9, 0x000a7e6b, 0x00000000, 0x0000b490, 0, 0, 0, 0 },
  { 0x39, 0x000785e9, 0x000a7e6b, 0x00000000, 0x0000b490, 0, 0, 0, 0 },
  { 0x3a, 0x00042df3, 0x0006e34b, 0x00000000, 0x00006f6d, 0, 0, 0, 0 },
  { 0x3b, 0x00042df3, 0x0006e34b, 0x00020195, 0x00006f6d, 0, 0, 0, 0 },
  { 0x3c, 0x0004cbfa, 0x0007ffbc, 0x00031cb5, 0x00005cdf, 0, 0, 0, 0 },
  { 0x3d, 0x000bb3dd, 0x0005b073, 0xfffdb0b7, 0x0000ca94, 0, 0, 0, 0 },
  { 0x3e, 0x00071aeb, 0x0007ffbc, 0x00031cb5, 0x00000000, 0, 0, 0, 0 },
  { 0x3f, 0x00071aeb, 0x000b1c72, 0x00000000, 0x0000c34e, 0, 0, 1, C_3f_Ligature },
  { 0x40, 0x000a07e2, 0x000b1c72, 0x00000000, 0x00006f6d, 0, 0, 0, 0 },
  { 0x41, 0x0009fe00, 0x000b1c72, 0x00000000, 0x00000000, 10, C_41_Kerning, 0, 0 },
  { 0x42, 0x000a02f1, 0x000b1c72, 0x00000000, 0x0000b490, 0, 0, 0, 0 },
  { 0x43, 0x00099ce3, 0x000b1c72, 0x00000000, 0x0000d217, 0, 0, 0, 0 },
  { 0x44, 0x000ad8ee, 0x000b1c72, 0x00000000, 0x00006f6d, 5, C_44_Kerning, 0, 0 },
  { 0x45, 0x0008f9ec, 0x000b1c72, 0x00000000, 0x0000d217, 0, 0, 0, 0 },
  { 0x46, 0x00088eed, 0x000b1c72, 0x00000000, 0x00003997, 10, C_46_Kerning, 0, 0 },
  { 0x47, 0x000a07e2, 0x000b1c72, 0x00000000, 0x0000d217, 0, 0, 0, 0 },
  { 0x48, 0x000a9c07, 0x000b1c72, 0x00000000, 0x0000ca94, 0, 0, 0, 0 },
  { 0x49, 0x00042412, 0x000b1c72, 0x00000000, 0x00003997, 1, C_49_Kerning, 0, 0 },
  { 0x4a, 0x000715fa, 0x000b1c72, 0x00000000, 0x0000ca94, 0, 0, 0, 0 },
  { 0x4b, 0x000a68ff, 0x000b1c72, 0x00000000, 0x0000d217, 4, C_4b_Kerning, 0, 0 },
  { 0x4c, 0x000823ee, 0x000b1c72, 0x00000000, 0x00000000, 4, C_4c_Kerning, 0, 0 },
  { 0x4d, 0x000d1dff, 0x000b1c72, 0x00000000, 0x0000ca94, 0, 0, 0, 0 },
  { 0x4e, 0x000a9c07, 0x000b1c72, 0x00000000, 0x0000ca94, 0, 0, 0, 0 },
  { 0x4f, 0x000b15d6, 0x000b1c72, 0x00000000, 0x00006f6d, 5, C_4f_Kerning, 0, 0 },
  { 0x50, 0x000997f2, 0x000b1c72, 0x00000000, 0x0000b490, 6, C_50_Kerning, 0, 0 },
  { 0x51, 0x000b15d6, 0x000b1c72, 0x00020195, 0x00006f6d, 0, 0, 0, 0 },
  { 0x52, 0x0009b3ed, 0x000b1c72, 0x00000000, 0x0000b490, 0, 0, 0, 0 },
  { 0x53, 0x00085be7, 0x000b1c72, 0x00000000, 0x00006ea2, 0, 0, 0, 0 },
  { 0x54, 0x000a3fd9, 0x000b1c72, 0x00000000, 0x00003997, 7, C_54_Kerning, 0, 0 },
  { 0x55, 0x000a4d04, 0x000b1c72, 0x00000000, 0x0000ca94, 0, 0, 0, 0 },
  { 0x56, 0x0009fe00, 0x000b1c72, 0x00000000, 0x00005cdf, 10, C_56_Kerning, 0, 0 },
  { 0x57, 0x000e2bf4, 0x000b1c72, 0x00000000, 0x00005cdf, 10, C_57_Kerning, 0, 0 },
  { 0x58, 0x0009fe00, 0x000b1c72, 0x00000000, 0x00003997, 4, C_58_Kerning, 0, 0 },
  { 0x59, 0x0009fe00, 0x000b1c72, 0x00000000, 0x00006ea2, 6, C_59_Kerning, 0, 0 },
  { 0x5a, 0x000931e4, 0x000b1c72, 0x00000000, 0x0000d217, 0, 0, 0, 0 },
  { 0x5b, 0x00045db1, 0x000bfc50, 0x0003fc93, 0x00005855, 0, 0, 0, 0 },
  { 0x5c, 0x000785e9, 0x000b1c72, 0x00000000, 0x00005067, 0, 0, 0, 0 },
  { 0x5d, 0x00045db1, 0x000bfc50, 0x0003fc93, 0x00005cdf, 0, 0, 0, 0 },
  { 0x5e, 0x000785e9, 0x000b1c72, 0x00000000, 0x000084d3, 0, 0, 0, 0 },
  { 0x5f, 0x00042df3, 0x000a8230, 0x00000000, 0x00006ea2, 0, 0, 0, 0 },
  { 0x60, 0x00042df3, 0x000b1c72, 0x00000000, 0x0000a03d, 0, 0, 1, C_60_Ligature },
  { 0x61, 0x000736e7, 0x0006e34b, 0x00000000, 0x00003997, 3, C_61_Kerning, 0, 0 },
  { 0x62, 0x0007bde1, 0x000b1c72, 0x00000000, 0x00008025, 9, C_62_Kerning, 0, 0 },
  { 0x63, 0x0006afec, 0x0006e34b, 0x00000000, 0x00008025, 0, 0, 0, 0 },
  { 0x64, 0x0007bde1, 0x000b1c72, 0x00000000, 0x000084d3, 0, 0, 0, 0 },
  { 0x65, 0x0006afec, 0x0006e34b, 0x00000000, 0x00005067, 0, 0, 0, 0 },
  { 0x66, 0x000498f2, 0x000b1c72, 0x00000000, 0x00006f6d, 5, C_66_Kerning, 3, C_66_Ligature },
  { 0x67, 0x000785e9, 0x0006e34b, 0x00031cb5, 0x0000a03d, 1, C_67_Kerning, 0, 0 },
  { 0x68, 0x0007bde1, 0x000b1c72, 0x00000000, 0x00005855, 0, 0, 0, 0 },
  { 0x69, 0x00038fee, 0x000a8230, 0x00000000, 0x00006f6d, 0, 0, 0, 0 },
  { 0x6a, 0x0003faec, 0x000a8230, 0x00031cb5, 0x00005855, 0, 0, 0, 0 },
  { 0x6b, 0x000752e2, 0x000b1c72, 0x00000000, 0x00008025, 4, C_6b_Kerning, 0, 0 },
  { 0x6c, 0x00038fee, 0x000b1c72, 0x00000000, 0x000084d3, 0, 0, 0, 0 },
  { 0x6d, 0x000bebd5, 0x0006e34b, 0x00000000, 0x00005855, 0, 0, 0, 0 },
  { 0x6e, 0x0007bde1, 0x0006e34b, 0x00000000, 0x00005855, 0, 0, 0, 0 },
  { 0x6f, 0x000785e9, 0x0006e34b, 0x00000000, 0x00003997, 9, C_6f_Kerning, 0, 0 },
  { 0x70, 0x0007bde1, 0x0006e34b, 0x00031cb5, 0x0000a03d, 9, C_70_Kerning, 0, 0 },
  { 0x71, 0x0007bde1, 0x0006e34b, 0x00031cb5, 0x0000b490, 0, 0, 0, 0 },
  { 0x72, 0x00051fed, 0x0006e34b, 0x00000000, 0x0000a03d, 0, 0, 0, 0 },
  { 0x73, 0x0005c489, 0x0006e34b, 0x00000000, 0x00005cdf, 0, 0, 0, 0 },
  { 0x74, 0x00056ef0, 0x0008db1a, 0x00000000, 0x00005855, 2, C_74_Kerning, 0, 0 },
  { 0x75, 0x0007bde1, 0x0006e34b, 0x00000000, 0x0000b490, 1, C_75_Kerning, 0, 0 },
  { 0x76, 0x0006e7e4, 0x0006e34b, 0x00000000, 0x0000a03d, 0, 0, 0, 0 },
  { 0x77, 0x000a3fda, 0x0006e34b, 0x00000000, 0x0000a03d, 4, C_77_Kerning, 0, 0 },
  { 0x78, 0x0006e7e4, 0x0006e34b, 0x00000000, 0x00003997, 0, 0, 0, 0 },
  { 0x79, 0x0006e7e4, 0x0006e34b, 0x00031cb5, 0x0000a03d, 5, C_79_Kerning, 0, 0 },
  { 0x7a, 0x0006886a, 0x0006e34b, 0x00000000, 0x0000c34e, 0, 0, 0, 0 },
  { 0x7b, 0x000785e9, 0x0006e34b, 0x00000000, 0x000086d7, 0, 0, 1, C_7b_Ligature },
  { 0x7c, 0x000f0bd3, 0x0006e34b, 0x00000000, 0x000086d7, 0, 0, 0, 0 },
  { 0x7d, 0x000785e9, 0x000b1c72, 0x00000000, 0x00006ea2, 0, 0, 0, 0 },
  { 0x7e, 0x000785e9, 0x000a7b9a, 0x00000000, 0x0000d217, 0, 0, 0, 0 },
  { 0x7f, 0x000785e9, 0x000a8230, 0x00000000, 0x00000000, 0, 0, 0, 0 }
};

void
cmssi17_tables(TFM::Font*& _font, TFM::Dimension*& _dimension, TFM::Character*& _character)
{
  _font = &font;
  _dimension = dimension;
  _character = character;
}
