/*
 * Copyright (c) 2004 Intel Corp.
 *
 * Author: Zou Yixiong (yixiong.zou@intel.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

/*
 * Note: this file originally auto-generated by mib2c using
 *        : mib2c.scalar.conf,v 1.7 2003/04/08 14:57:04 dts12 Exp $
 */

#include <portability.h>
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "LHAHeartbeatConfigInfo.h"

#include "hbagent.h"
#include <hb_api.h>
#include "clplumbing/cl_malloc.h"

/** Initializes the LHAHeartbeatConfigInfo module */
void
init_LHAHeartbeatConfigInfo(void)
{
    static oid LHAHBVersion_oid[] = { 1,3,6,1,4,1,4682,7,1 };
    static oid LHAKeepAlive_oid[] = { 1,3,6,1,4,1,4682,7,3 };
    static oid LHADeadTime_oid[] = { 1,3,6,1,4,1,4682,7,4 };
    static oid LHADeadPing_oid[] = { 1,3,6,1,4,1,4682,7,5 };
    static oid LHAWarnTime_oid[] = { 1,3,6,1,4,1,4682,7,6 };
    static oid LHAInitDead_oid[] = { 1,3,6,1,4,1,4682,7,7 };
    static oid LHABaudRate_oid[] = { 1,3,6,1,4,1,4682,7,9 };
    static oid LHAutoFailBack_oid[] = { 1,3,6,1,4,1,4682,7,12 };
    static oid LHAStonith_oid[] = { 1,3,6,1,4,1,4682,7,13 };
    static oid LHAStonithHost_oid[] = { 1,3,6,1,4,1,4682,7,14 };
    static oid LHARespawn_oid[] = { 1,3,6,1,4,1,4682,7,15 };

    DEBUGMSGTL(("LHAHeartbeatConfigInfo", "Initializing\n"));

    netsnmp_register_scalar(
        netsnmp_create_handler_registration("LHAHBVersion", handle_LHAHBVersion,
                               LHAHBVersion_oid, OID_LENGTH(LHAHBVersion_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("LHAKeepAlive", handle_LHAKeepAlive,
                               LHAKeepAlive_oid, OID_LENGTH(LHAKeepAlive_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("LHADeadTime", handle_LHADeadTime,
                               LHADeadTime_oid, OID_LENGTH(LHADeadTime_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("LHADeadPing", handle_LHADeadPing,
                               LHADeadPing_oid, OID_LENGTH(LHADeadPing_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("LHAWarnTime", handle_LHAWarnTime,
                               LHAWarnTime_oid, OID_LENGTH(LHAWarnTime_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("LHAInitDead", handle_LHAInitDead,
                               LHAInitDead_oid, OID_LENGTH(LHAInitDead_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("LHABaudRate", handle_LHABaudRate,
                               LHABaudRate_oid, OID_LENGTH(LHABaudRate_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("LHAutoFailBack", handle_LHAutoFailBack,
                               LHAutoFailBack_oid, OID_LENGTH(LHAutoFailBack_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("LHAStonith", handle_LHAStonith,
                               LHAStonith_oid, OID_LENGTH(LHAStonith_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("LHAStonithHost", handle_LHAStonithHost,
                               LHAStonithHost_oid, OID_LENGTH(LHAStonithHost_oid),
                               HANDLER_CAN_RONLY
        ));
    netsnmp_register_scalar(
        netsnmp_create_handler_registration("LHARespawn", handle_LHARespawn,
                               LHARespawn_oid, OID_LENGTH(LHARespawn_oid),
                               HANDLER_CAN_RONLY
        ));
}

int
handle_LHAHBVersion(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    /* We are never called for a GETNEXT if it's registered as a
       "instance", as it's "magically" handled for us.  */

    /* a instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */
    
    char * value;

    if (hbconfig_get_str_value(KEY_HBVERSION, &value) != HA_OK) 
	return SNMP_ERR_GENERR;

    switch(reqinfo->mode) {

        case MODE_GET:
            snmp_set_var_typed_value(requests->requestvb, ASN_OCTET_STR,
                                     (u_char *) value,
				     strlen(value) + 1);
            break;


        default:
            /* we should never get here, so this is a really bad error */
            ha_free(value);
            return SNMP_ERR_GENERR;
    }

    ha_free(value);
    return SNMP_ERR_NOERROR;
}
int
handle_LHAKeepAlive(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    char * value;

    if (hbconfig_get_str_value(KEY_KEEPALIVE, &value) != HA_OK) 
	return SNMP_ERR_GENERR;

    switch(reqinfo->mode) {

        case MODE_GET:
            snmp_set_var_typed_value(requests->requestvb, ASN_OCTET_STR,
                                     (u_char *) value,
				     strlen(value) + 1);
            break;

       default:
            /* we should never get here, so this is a really bad error */
            ha_free(value);
            return SNMP_ERR_GENERR;
    }

    ha_free(value);
    return SNMP_ERR_NOERROR;
}
int
handle_LHADeadTime(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    char * value;

    if (hbconfig_get_str_value(KEY_DEADTIME, &value) != HA_OK) 
	return SNMP_ERR_GENERR;

    switch(reqinfo->mode) {

        case MODE_GET:
            snmp_set_var_typed_value(requests->requestvb, ASN_OCTET_STR,
                                     (u_char *) value,
				     strlen(value) + 1);
            break;

        default:
            /* we should never get here, so this is a really bad error */
            ha_free(value);
            return SNMP_ERR_GENERR;
    }

    ha_free(value);
    return SNMP_ERR_NOERROR;
}
int
handle_LHADeadPing(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    char * value;

    if (hbconfig_get_str_value(KEY_DEADPING, &value) != HA_OK) 
	return SNMP_ERR_GENERR;

    switch(reqinfo->mode) {

        case MODE_GET:
            snmp_set_var_typed_value(requests->requestvb, ASN_OCTET_STR,
                                     (u_char *) value,
				     strlen(value) + 1);
            break;

        default:
            /* we should never get here, so this is a really bad error */
            ha_free(value);
            return SNMP_ERR_GENERR;
    }

    ha_free(value);
    return SNMP_ERR_NOERROR;
}
int
handle_LHAWarnTime(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    char * value;

    if (hbconfig_get_str_value(KEY_WARNTIME, &value) != HA_OK) 
	return SNMP_ERR_GENERR;

    switch(reqinfo->mode) {

        case MODE_GET:
            snmp_set_var_typed_value(requests->requestvb, ASN_OCTET_STR,
                                     (u_char *) value,
				     strlen(value) + 1);
            break;

        default:
            /* we should never get here, so this is a really bad error */
            ha_free(value);
            return SNMP_ERR_GENERR;
    }

    ha_free(value);
    return SNMP_ERR_NOERROR;
}
int
handle_LHAInitDead(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    char * value;

    if (hbconfig_get_str_value(KEY_INITDEAD, &value) != HA_OK) 
	return SNMP_ERR_GENERR;

    switch(reqinfo->mode) {

        case MODE_GET:
            snmp_set_var_typed_value(requests->requestvb, ASN_OCTET_STR,
                                     (u_char *) value,
				     strlen(value) + 1);
            break;

        default:
            /* we should never get here, so this is a really bad error */
            ha_free(value);
            return SNMP_ERR_GENERR;
    }

    ha_free(value);
    return SNMP_ERR_NOERROR;
}
int
handle_LHABaudRate(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    char * value;

    if (hbconfig_get_str_value(KEY_BAUDRATE, &value) != HA_OK) 
	return SNMP_ERR_GENERR;

    switch(reqinfo->mode) {

        case MODE_GET:
            snmp_set_var_typed_value(requests->requestvb, ASN_OCTET_STR,
                                     (u_char *) value,
				     strlen(value) + 1);
            break;

        default:
            /* we should never get here, so this is a really bad error */
            ha_free(value);
            return SNMP_ERR_GENERR;
    }

    ha_free(value);
    return SNMP_ERR_NOERROR;
}
int
handle_LHAutoFailBack(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    char * ret;
    uint32_t value;

    if (hbconfig_get_str_value(KEY_AUTOFAIL, &ret) != HA_OK) 
	return SNMP_ERR_GENERR;

    if (strcmp(ret, "on") == 0) value = 1;
    else if (strcmp(ret, "off") == 0) value = 2;
    else if (strcmp(ret, "legacy") == 0) value = 3;
    else value = 0;

    switch(reqinfo->mode) {

        case MODE_GET:
            snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
                                     (u_char *) & value,
				     sizeof(value));
            break;

       default:
            /* we should never get here, so this is a really bad error */
            ha_free(ret);
            return SNMP_ERR_GENERR;
    }

    ha_free(ret);
    return SNMP_ERR_NOERROR;
}
int
handle_LHAStonith(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    char * value;

    if (hbconfig_get_str_value(KEY_STONITH, &value) != HA_OK) 
	return SNMP_ERR_GENERR;

    switch(reqinfo->mode) {

        case MODE_GET:
            snmp_set_var_typed_value(requests->requestvb, ASN_OCTET_STR,
                                     (u_char *) value,
				     strlen(value) + 1);
            break;

        default:
            /* we should never get here, so this is a really bad error */
            ha_free(value);
            return SNMP_ERR_GENERR;
    }

    ha_free(value);
    return SNMP_ERR_NOERROR;
}
int
handle_LHAStonithHost(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    char * value;

    if (hbconfig_get_str_value(KEY_STONITHHOST, &value) != HA_OK) 
	return SNMP_ERR_GENERR;

    switch(reqinfo->mode) {

        case MODE_GET:
            snmp_set_var_typed_value(requests->requestvb, ASN_OCTET_STR,
                                     (u_char *) value,
				     strlen(value) + 1);
            break;

       default:
            /* we should never get here, so this is a really bad error */
            ha_free(value);
            return SNMP_ERR_GENERR;
    }

    ha_free(value);
    return SNMP_ERR_NOERROR;
}
int
handle_LHARespawn(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info   *reqinfo,
                          netsnmp_request_info         *requests)
{
    char * value;

    if (hbconfig_get_str_value(KEY_CLIENT_CHILD, &value) != HA_OK) 
	return SNMP_ERR_GENERR;

    switch(reqinfo->mode) {

        case MODE_GET:
            snmp_set_var_typed_value(requests->requestvb, ASN_OCTET_STR,
                                     (u_char *) value,
				     strlen(value) + 1);
            break;

        default:
            /* we should never get here, so this is a really bad error */
            ha_free(value);
            return SNMP_ERR_GENERR;
    }

    ha_free(value);
    return SNMP_ERR_NOERROR;
}


