#!/usr/bin/python
# -*- coding: UTF-8 -*-
###########################################################################
# wineread.py - description                                             #
# ------------------------------                                          #
# begin     : Fri Mar 26 2004                                             #
# copyright : (C) 2006 by Yuriy Kozlov                                    #
# email     : yuriy.kozlov@gmail.com                                      #
#                                                                         #
###########################################################################
#                                                                         #
#   This program is free software; you can redistribute it and/or modify  #
#   it under the terms of the GNU General Public License as published by  #
#   the Free Software Foundation; either version 2 of the License, or     #
#   (at your option) any later version.                                   #
#                                                                         #
###########################################################################

import os
import wineread

""" Reads a default set of drives from /etc/fstab """

fstabpath = "/etc/fstab"

# Listed in winecfg
ignored_fs_types = set(["devpts",
    "tmpfs",
    "proc",
    "sysfs",
    "swap",
    "usbdevfs",
    "rpc_pipefs",
    "binfmt_misc"])
    
# Listed in winecfg
ignored_mnt_pts = set(["/boot"])

cd_fs_types = set(["cdfs","udf","iso9660"])

# An incomplete listing, I don't know how winecfg does this.
# RAMFS is included here because I don't know what the correct type for it is in wine.
hd_fs_types = set(["ext4","ext3","ext2","ext","fat","fat32","fat16","ntfs","reiserfs","reiser4",
    "jfs","xfs","ramfs","vfat","ufs","hfs","hfsplus"])
    
# Listed in winecfg
net_fs_types = set(["nfs","nfs4","smbfs","cifs","coda"])

def autodetect(drives=None):
    """ Returns a set of drives found by scanning /etc/fstab, and an error code """
    if not drives:
        drives = wineread.GetEmptyDrives()
    mappings = set()
    if not drives[2][2]:
        drives[2][2] = "../drive_c"
        drives[2][3] = "hd"
        
    for drive in drives:
        mapping = drive[2]
        if mapping:
            mappings.add(mapping)
    
    driveid = 3
    fstab=open(fstabpath,'r')

    for driveline in fstab:
        if driveline[0] == '#' or len(driveline.strip()) == 0: # Comment or empty line
            continue
        else:
            driveprops = driveline.split()
            fs = driveprops[0]
            mnt = driveprops[1]
            fstypes = set(driveprops[2].split(','))
            
            ignore = False
            for fstype in fstypes:
                if fstype in ignored_fs_types:
                    ignore = True
                    break
                
            if mnt in ignored_mnt_pts or mnt in mappings:
                ignore = True
            
            if not ignore:
                while drives[driveid][2]:   # Drive is in use, don't overwrite.
                    driveid += 1
                if driveid > 25:
                    return (1,drives)
                drives[driveid][2] = mnt
                if "/dev/fd" in fs or "floppy" in mnt:
                    drives[driveid][3] = "floppy"
                elif fstype in cd_fs_types or "/dev/cdrom" in fs or "cdrom" in mnt:
                    drives[driveid][3] = "cdrom"
                elif fstype in hd_fs_types:
                    drives[driveid][3] = "hd"
                elif fstype in net_fs_types:
                    drives[driveid][3] = "network"
                else:
                    drives[driveid][3] = "auto"
                driveid += 1
                
    fstab.close()
    return (0,drives)
                
def autodetectshelllinks(shelllinks = None):
    """ Returns a default set of windows shell folder mappings """
    if not shelllinks:
        shelllinks = wineread.GetEmptyShellLinks()
        
    for link in shelllinks:
        if link[2]:
            continue
        else:
            link[3] = "shellfolder"
            #link[4] = wineread.winepath + "/dosdevices/c:/windows/profiles/" + os.environ['USER'] + "/" + link[1]
            link[4] = wineread.defaultwinfolderspath + "\\" + link[1]
            link[5] = wineread.defaultwinfolderspath + "\\" + link[1]
            link[2] = os.environ['HOME']
            if link[1] == "Desktop":
                link[2] = os.environ['HOME'] + "/Desktop"
                
    return shelllinks
