/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _CHILD_LOG_LINE_H_
#define _CHILD_LOG_LINE_H_

#include <qobject.h>

#include <kurl.h>

#include "globals.h"


#include "logLine.h"

class ParentLogLine;

/**
 * @author Nicolas Ternisien
 */
class ChildLogLine : public LogLine {
	
	public:
		ChildLogLine(QDate& date, QTime& time, QStringList& list, QString& originalFile, LogLevel* level, int tpe);

		virtual ~ChildLogLine();
		
		void setParent(ParentLogLine* line);
		ParentLogLine* getParent();
		
		virtual bool isChildLogLine();
		
	protected:
		ParentLogLine* parent;

};

#endif
