/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <klocale.h>
#include <kmessagebox.h>

#include "parsingHelper.h"
#include "cupsAccessReader.h"

CupsAccessReader::CupsAccessReader(QObject *parent, const char *name) :
	DefaultReader(parent, name)
	{
}


CupsAccessReader::~CupsAccessReader() {

}


void CupsAccessReader::initColumns(LogViewColumns* columns) {
	columns->append(new LogViewColumn(i18n("Date"), true, false));
	columns->append(new LogViewColumn(i18n("Host Name"), true, true));
	columns->append(new LogViewColumn(i18n("Id."), true, true)); //=Identification protocol [From RFC1413 (see Google for more infos)]
	columns->append(new LogViewColumn(i18n("User"), true, true));
	columns->append(new LogViewColumn(i18n("Response"), true, true));
	columns->append(new LogViewColumn(i18n("Bytes Sent"), true, false));
	columns->append(new LogViewColumn(i18n("HTTP Request"), true, false));

}

LogLine* CupsAccessReader::parseMessage(QString& logLine, LogFile* logFile) {
	int spacePos=logLine.find(' ');
	
	QString hostName=logLine.left(spacePos);	
	logLine=logLine.remove(0, spacePos+1);
	
	spacePos=logLine.find(' ');
	QString identd=logLine.left(spacePos);
	logLine=logLine.remove(0, spacePos+1);
	
	spacePos=logLine.find(' ');
	QString userName=logLine.left(spacePos);
	logLine=logLine.remove(0, spacePos+1);

	int endDate=logLine.find(']');
	QString strDateTime=logLine.left(endDate);
	logLine=logLine.remove(0, endDate+3);
	
	QDateTime dateTime=ParsingHelper::parseDateTimeFromHTTP(strDateTime);
	QDate date=dateTime.date();
	QTime time=dateTime.time();
	
	int endQuote=logLine.find('\"');
	QString message=logLine.left(endQuote);
	logLine=logLine.remove(0, endQuote+2);
	
	spacePos=logLine.find(' ');
	QString httpResponse=ParsingHelper::parseHTTPResponse(logLine.left(spacePos));
	logLine=logLine.remove(0, spacePos+1);

	spacePos=logLine.find(' ');
	QString bytesSent=ParsingHelper::parseSize(logLine.left(spacePos));
	
	
	QStringList list;
	
	list.push_back(hostName);
	list.push_back(identd);
	list.push_back(userName);
	list.push_back(httpResponse);
	list.push_back(bytesSent);
	list.push_back(message);
	

	QString filePath=logFile->url.path();
	LogLine* line=new LogLine(date, time, list, filePath, Globals::informationLogLevel, Globals::cupsAccessMode->id);
	return(line);
}



#include "cupsAccessReader.moc"
