#!/bin/sh

cd po

xgettext --language=Perl --default-domain=pppconfig --directory=.. \
	 --add-comments --keyword=_ --keyword=N_ \
	 --files-from=POTFILES.in && test ! -f pppconfig.po \
	 || ( rm -f templates.pot && mv pppconfig.po templates.pot )

# Moving along..

catalogs=`ls *.po`
for cat in $catalogs; do
  lang=`echo $cat | sed 's/\.po$//'`
  mv $cat $lang.old.po
  echo "$lang:"
  if msgmerge $lang.old.po templates.pot -o $cat; then
    rm -f $lang.old.po
  else
    echo "msgmerge for $cat failed!"
    if cmp --quiet $cat $lang.old.po ; then
      rm -f $lang.old.po
    else
      mv -f $lang.old.po $cat
    fi
  fi
done
