from RestrictedManager.xorg_driver import XorgDriverHandler

from gettext import gettext as _

class AtiDriver(XorgDriverHandler):
    is_handler = True

    name = "fglrx"
    description = _("ATI accelerated graphics driver")
    rationale = _("This driver is required to fully utilise the 3D potential "
                 "of ATI graphics cards, as well as provide 2D "
                 "acceleration of newer cards.")

    def __init__(self, module):
        XorgDriverHandler.__init__(self, module, "xorg-driver-fglrx", "fglrx",
            {}, "ati", ["glx"], [])

    def enable_config_hook(self):
        if len(self.xorg_conf.getSections("extensions")) < 1:
            self.xorg_conf.append(self.xorg_conf.makeSection(None, ["Section",
                "Extensions"]))
        section = self.xorg_conf.getSections("extensions")[0]

        section.makeListAttr(None, ["option", "Composite", "0"])

    def disable_config_hook(self):
        if len(self.xorg_conf.getSections("extensions")) < 1:
            return

        self.xorg_conf.getSections("extensions")[0].option.removeOptionByName('composite')
