#!/usr/bin/python

from distutils.core import setup

import subprocess, glob, os.path

mo_files = []
# HACK: make sure that the mo files are generated and up-to-date
subprocess.call(["make", "-C", "po", "build-mo"])
for filepath in glob.glob("po/mo/*/LC_MESSAGES/*.mo"):
    lang = filepath[len("po/mo/"):]
    targetpath = os.path.dirname(os.path.join("share/locale",lang))
    mo_files.append((targetpath, [filepath]))

setup(
    name="restricted-manager",
    author="Scott James Remnant",
    author_email="scott@ubuntu.com",
    maintainer="Martin Pitt",
    maintainer_email="martin.pitt@ubuntu.com",
    url="http://www.ubuntu.com",
    license="gpl",
    description="check, enable, and disable non-free hardware drivers",
    packages=["RestrictedManager"],
    data_files=[("share/restricted-manager", ["RestrictedManager/manager.glade"]),
                ("share/applications", glob.glob("applications/*.desktop")),
                ("/etc/xdg/autostart", glob.glob("autostart/*.desktop")),
               ] + mo_files,
    scripts=["restricted-manager"],
)
