#ifndef SCREEM_EDITOR_H
#define SCREEM_EDITOR_H

#include <sys/types.h>

#include "screem-view.h"

#define SCREEM_TYPE_EDITOR  (screem_editor_get_type())
#define SCREEM_EDITOR(obj)  (G_TYPE_CHECK_INSTANCE_CAST( ( obj ),   \
                                                SCREEM_TYPE_EDITOR, \
                                                ScreemEditor ) )
#define SCREEM_IS_EDITOR(obj)  (G_TYPE_CHECK_INSTANCE_TYPE( ( obj ), \
                                               SCREEM_TYPE_EDITOR ) )

#ifndef SCREEM_WINDOW_DEFINED
#define SCREEM_WINDOW_DEFINED
typedef struct ScreemWindow ScreemWindow;
#endif
	       

typedef struct ScreemEditorPrivate ScreemEditorPrivate;

typedef struct {
	ScreemView parent;

	ScreemEditorPrivate *priv;
} ScreemEditor;

typedef struct {
	ScreemViewClass parent_class;

	void (*overwrite)( ScreemEditor *editor, gboolean overwrite );
} ScreemEditorClass;

typedef enum {
	TEXT,
	ADD_CLOSE
} ScreemEditorAction;

typedef struct {
	gchar *key_name;
	gchar *text;
	ScreemEditorAction action;
} ScreemEditorMacro;

GType screem_editor_get_type( void );
ScreemEditor *screem_editor_new( ScreemWindow *window );


gint screem_editor_auto_indent( ScreemEditor *editor, gint pos );
void screem_editor_indent( ScreemEditor *editor, guint pos );
void screem_editor_unindent( ScreemEditor *editor, guint pos );

/* position / text functions */
void screem_editor_goto_line( ScreemEditor *editor, gint line );
void screem_editor_encode_text( ScreemEditor *editor, gboolean urienc );
gchar* screem_editor_get_word( ScreemEditor *editor, gint pos );


#endif
