/*  Screem:  screem-ctags-view.c
 *
 *  Copyright (C) 2003 David A Knight
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */

#include "config.h"

#include <glib/gi18n.h>

#include <gtk/gtkcellrenderertext.h>
#include <gtk/gtkcellrenderertoggle.h>
#include <gtk/gtkcellrendererpixbuf.h>

#include "screem-ctags-view.h"
#include "screem-ctags-model.h"

#include "readtags.h"

#include "screemmarshal.h"


static void row_activated( GtkTreeView *view, GtkTreePath *path,
			GtkTreeViewColumn *column, gpointer *data );

struct ScreemCtagsViewPrivate {
	gpointer dummy;
};

enum {
	JUMPTO,
	LAST_SIGNAL
};

enum {
	PROP_0
};

static guint screem_ctags_view_signals[ LAST_SIGNAL ] = { 0 };

G_DEFINE_TYPE( ScreemCtagsView, screem_ctags_view, GTK_TYPE_TREE_VIEW )

static void screem_ctags_view_finalize( GObject *object );
static void screem_ctags_view_set_prop( GObject *object, guint prop_id,
				const GValue *value, GParamSpec *spec );
static void screem_ctags_view_get_prop( GObject *object, guint prop_id,
				GValue *value, GParamSpec *spec );

static void screem_ctags_view_class_init( ScreemCtagsViewClass *klass )
{
	GObjectClass *obj_class;
	
	obj_class = G_OBJECT_CLASS( klass );
	obj_class->finalize = screem_ctags_view_finalize;
	obj_class->get_property = screem_ctags_view_get_prop;
	obj_class->set_property = screem_ctags_view_set_prop;

	screem_ctags_view_signals[ JUMPTO ] = 
		g_signal_new( "jumpto",
			      G_OBJECT_CLASS_TYPE( obj_class ),
			      G_SIGNAL_RUN_LAST,
			      G_STRUCT_OFFSET( ScreemCtagsViewClass, 
					       jumpto ),
			      NULL, NULL,
			      screem_marshal_VOID__STRING_STRING_UINT,
			      G_TYPE_NONE, 3,
			      G_TYPE_STRING,
			      G_TYPE_STRING,
			      G_TYPE_UINT );
}

static void screem_ctags_view_init( ScreemCtagsView *ctags_view )
{
	ScreemCtagsViewPrivate *priv;
	GtkTreeView *view;
	GtkCellRenderer *rend;
	GtkCellRenderer *prend;
	GtkTreeViewColumn *col;
	
	priv = ctags_view->priv = g_new0( ScreemCtagsViewPrivate, 1 );

	view = GTK_TREE_VIEW( ctags_view );
	
	gtk_tree_view_set_rules_hint( view, TRUE );

	prend = gtk_cell_renderer_pixbuf_new();
	rend = gtk_cell_renderer_text_new ();
	col = gtk_tree_view_column_new();
	
	gtk_tree_view_column_set_title( col, _( "Name" ) );
	gtk_tree_view_column_pack_start( col, prend, FALSE );
	gtk_tree_view_column_pack_start( col, rend, TRUE );
	gtk_tree_view_column_set_attributes( col, rend,
					     "text", CTAGS_NAME_COL,
					     NULL );
	gtk_tree_view_column_set_attributes( col, prend,
					     "pixbuf",
					     CTAGS_ICON_COL,
					     NULL );
	gtk_tree_view_column_set_resizable( col, TRUE );
	gtk_tree_view_append_column( view, col );

	rend = gtk_cell_renderer_text_new ();
	col = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title( col, _( "In File" ) );
	gtk_tree_view_column_pack_start( col, rend, TRUE );
	gtk_tree_view_column_set_attributes( col, rend,
					     "text", CTAGS_FILE_COL,
					     NULL );
	gtk_tree_view_column_set_resizable( col, TRUE );
	gtk_tree_view_append_column( view, col );

	g_signal_connect( G_OBJECT( view ), "row_activated",
			G_CALLBACK( row_activated ),
			NULL );
}

static void screem_ctags_view_finalize( GObject *object )
{
	ScreemCtagsView *ctags_view;
	ScreemCtagsViewPrivate *priv;
				
	g_return_if_fail( object != NULL );
	g_return_if_fail( SCREEM_IS_CTAGS_VIEW( object ) );

	ctags_view = SCREEM_CTAGS_VIEW( object );

	priv = ctags_view->priv;

	g_free( priv );
	
	G_OBJECT_CLASS( screem_ctags_view_parent_class )->finalize( object );
}

static void screem_ctags_view_set_prop( GObject *object, guint prop_id,
				const GValue *value, GParamSpec *spec )
{
	ScreemCtagsView *ctags_view;
	ScreemCtagsViewPrivate *priv;
	
	ctags_view = SCREEM_CTAGS_VIEW( object );
	priv = ctags_view->priv;

	switch( prop_id ) {
		default:
			break;
	}
}

static void screem_ctags_view_get_prop( GObject *object, guint prop_id,
				GValue *value, GParamSpec *spec )
{
	ScreemCtagsView *ctags_view;
	ScreemCtagsViewPrivate *priv;
	
	ctags_view = SCREEM_CTAGS_VIEW( object );
	priv = ctags_view->priv;

	switch( prop_id ) {
		default:
			break;
	}
}

/* static stuff */

static void row_activated( GtkTreeView *view, GtkTreePath *path,
			GtkTreeViewColumn *column, gpointer *data )
{
	ScreemCtagsView *cview;
	ScreemCtagsViewPrivate *priv;
	GtkTreeModel *model;
	GtkTreeIter it;
	gchar *file;
	gchar *pattern;
	guint line;
	
	cview = SCREEM_CTAGS_VIEW( view );
	priv = cview->priv;
	
	model = gtk_tree_view_get_model( view );
	if( gtk_tree_model_get_iter( model, &it, path ) ) {
	
		gtk_tree_model_get( model, &it,
				CTAGS_FILE_COL, &file,
				CTAGS_PATTERN_COL, &pattern,
				CTAGS_LINE_COL, &line,
				-1 );
		if( file ) {
			g_signal_emit( G_OBJECT( view ),
				screem_ctags_view_signals[ JUMPTO ], 0,
				file, pattern, line );

		}
		g_free( file );
		g_free( pattern );
	}
}

/* public stuff */

ScreemCtagsView *screem_ctags_view_new( void )
{
	ScreemCtagsView *ctags_view;

	ctags_view = g_object_new( SCREEM_TYPE_CTAGS_VIEW, NULL );

	return ctags_view;
}

