
# Copyright (c) 2001-2004 Twisted Matrix Laboratories.
# See LICENSE for details.


from twisted.trial import unittest
from twisted.python.runtime import platformType

class AtLeastImportTestCase(unittest.TestCase):

    """I test that there are no syntax errors which will not allow importing.
    """

    failureException = ImportError

    def test_misc(self):
        """Test importing other misc. modules
        """
        from twisted import copyright

    def test_persisted(self):
        """Test importing persisted
        """
        from twisted.persisted import dirdbm
        from twisted.persisted import styles

    def test_internet(self):
        """Test importing internet
        """
        from twisted.internet import tcp
        from twisted.internet import main
        from twisted.internet import app
        # from twisted.internet import ssl    
        from twisted.internet import abstract
        from twisted.internet import udp
        from twisted.internet import protocol
        from twisted.internet import defer

    def test_unix(self):
        """internet modules for unix."""
        from twisted.internet import stdio
        from twisted.internet import process
        from twisted.internet import unix
    
    if platformType != "posix":
        test_unix.skip = "UNIX-only modules"
    
    def test_spread(self):
        """Test importing spreadables
        """
        from twisted.spread import pb
        from twisted.spread import jelly
        from twisted.spread import banana
        from twisted.spread import flavors
    
    def test_twistedPython(self):
        """Test importing twisted.python
        """
        from twisted.python import hook
        from twisted.python import log
        from twisted.python import reflect
        # from twisted.python import threadable
        # from twisted.python import threadpool
        from twisted.python import usage
        from twisted.python import otp
    
    def test_protocols(self):
        """Test importing protocols
        """
        from twisted.protocols import basic
        from twisted.protocols import ftp
        from twisted.protocols import telnet
        from twisted.protocols import policies
    
    def test_enterprise(self):
        from twisted.enterprise import adbapi
        from twisted.enterprise import reflector
        from twisted.enterprise import sqlreflector
        from twisted.enterprise import row

    def test_test(self):
        import os, sys
        oldargv = sys.argv
        sys.argv = sys.argv[:1]
        try:
            tests = os.listdir(os.path.dirname(__file__))
            for f in tests:
                if f.startswith('test_') and f.endswith('.py'):
                    __import__('twisted.test.%s' % f[:-3])
        finally:
            sys.argv = oldargv

testCases = [AtLeastImportTestCase]
