# Part of the A-A-P recipe executive: Testing passing variable on cmdline

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

import sys, os

def runaap(args):
    return os.system("%s ..%sMain.py %s" % (sys.argv[1], os.sep, args))

os.chdir("rectest")

# Create a very simple recipe and try running it.
rec = "rectest.aap"
out = "rectest.out"

f = open(rec, "w")
f.write("""
BBB ?= xxx
CCC = yyy
all:
    :print $AAA $BBB $CCC
""")
f.close()

res = runaap("-f %s AAA=aaa BBB=bbb CCC=ccc >%s" % (rec, out))

f = open(out)
l = f.read()
if l != "aaa bbb yyy\n":
    print 'Aap returned "%s" instead of "aaa bbb yyy"' % l
    res = 1
f.close()

os.remove(rec)
os.remove(out)

sys.exit(res)


# vim: set sw=4 et sts=4 tw=79 fo+=l:
