
/* 
	--- ACA example ---
 */

#include <aca/aca.h>
#include <aca/aca_widget.h>

#include "examples_colors.h"


#include <time.h>	/* for exapmle only */

/* 
	Change first char in value content to 'A' 
*/	
int extra_value_fn(INI_SectionData *d, char *value, char *content)
{
	*d->content = 'A';
	return TRUE;
}

/*
	Change second and third char in value to 'CA'
 */
int extra_sect_fn(INI_Section *sect, char *value, char *content)
{
	*(content+1) = 'C';	
	*(content+2) = 'A';
	return TRUE;
}

int main()
{	
	time_t	t;
	char	xxx[16];
	
	INI_SectionData	sec1_d[] = {
		{ "value1", chN, NULL },
		{ "value2", chN, NULL },
		{ chN,	    chN, NULL } 
	};
	INI_SectionData	sec2_d[] = {
		{ "value1",  chN, NULL },
		{ "value2",  chN, extra_value_fn },
		{ "value3",  chN, NULL },
		{ chN, 	     chN, NULL }
	};
	
	INI_Section	ini_sec[] = {
		{ "A-Section", SECT_LOAD, sec1_d, NULL },
		{ "B-Section", SECT_LOAD, sec2_d, extra_sect_fn },		
		TERMINAM_KEYS_SECTION,
		{ chN, FALSE, NULL, NULL }
	};
	aca_INI	INI = { "ini_test.ini", ini_sec };	

	/* init ACA */
	init_aca(TRUE);
	init_keys_ini(&ini_sec[2]);
	examples_colors();
	
	/* print ini structs before load data */
	INI_fprintf(stderr, &INI);
	
	/* load data */
	INI_load(&INI);
	
	/* init keys */
	init_keys(&INI);
	
	/* print ini structs to stderr */
	INI_fprintf(stderr, &INI);
	
	/* make new data */
	time(&t);
	strftime(xxx, 10, "%H:%M:%S", localtime(&t));
	
	/* init new data in structs */
	INI_set_data(sec1_d, "value1", xxx);
	INI_set_data(sec2_d, "value2", "new data to INI-section2-value2");
	
	/* init flags */
	INI_set_flag_save (&INI, "A-Section");
	
	/* print ini structs to stderr (with new change) */
	INI_fprintf(stderr, &INI);
	
	/* write to ini file */
	INI_save(&INI);
		
	exit(RE_OK);
}