
/* 
	--- ACA example ---
 */

#include <aca/aca.h>
#include <aca/aca_widget.h>

#include "examples_colors.h"

   void spec_resize(void *data)
   {
       int 	tmp;
       SessW	*s = (SessW *) data;
	
       tmp = size_widgets_progression("wiwwiw", &s->wtab[0], 13, &s->wtab[1], &s->wtab[2], 4, &s->wtab[3]);
       set_widgets_progression(COLS/2-tmp/2, "wiwwiw", &s->wtab[0], 13, &s->wtab[1], &s->wtab[2], 4, &s->wtab[3]);
       W_redraw_session(s);
       clean_hline(LINES-2, 0, COLS, WHITE_RED);
   }

   void bgr_examp(SessW *s)
   {
      clean_box(0, 0, LINES, COLS, WHITE_BLUE); 
      center_addnstr(1, COLS/2, "ACA menu example\n{ QUIT: press button quit or key F10 }", 40);
      mvaddstr(LINES-1, COLS-17,"(C) Zakkr - 1999");
   }

#define ITEMS1	(sizeof(menu_strings1)/sizeof(char *) -1)
#define ITEMS2	(sizeof(menu_strings2)/sizeof(char *) -1)

   int main() {
      int	re;
      char	buff[64], buff2[64];
      char	*menu_strings1[] = {
      	"|O|ne",
      	"T|w|o",
      	"|T|hree",
      	"Fo|u|r",
      	"Fi|v|e",
      	"Si|x|",
      	"S|e|ven",
      	"Ei|g|ht",
      	"N|i|ne",
      	"Te|n|",
      	"Last |m|enu item"
      };
      char	*menu_strings2[] = {
      	"AAAA AAAA AAAA", "BBBB BBBB BBBB", "CCCC CCCC CCCC",
      	"EE EE EE EE EE", "FF FF FF FF FF", "GG GG GG GG GG",
      	"HHHHHHHHHHHHHH", "IIIIIIIIIIIIII", "JJJJJJJJJJJJJJ",
      	"KKKKKKK KKKKKK", "LLLLLLL LLLLLL", "MMMMMMM MMMMMM"
      };
      Wmenu	m[] = {
      	{ 
      	" |A|menu ", 0, M_TITLE|M_COLORIN|M_BORDER|M_OPEN|M_SLIST, 
      	ITEMS2,0,0,ITEMS2,0,0,0,0,0,0,menu_strings2,NULL,mpr_str
      	},{
      	" |B|menu ", 0, M_TOPTITLE|M_COLOROUT|M_BORDER|M_ALIST, 
      	ITEMS1,0,0,ITEMS1,0,0,0,0,0,0,menu_strings1,NULL,mpr_astr 
      	},{ 
      	" |C|menu ", 0, M_TOPTITLE|M_COLOROUT|M_BORDER|M_ALIST, 
      	ITEMS1,0,0,ITEMS1/2,0,0,0,0,0,0,menu_strings1,NULL,mpr_astr 
      	},
      };
      Widget	w[] = {
      	{ TRUE, 5,0,0,0, menu_fn, (void *)  &m[0], Wf_DEFAULT, NULL },
      	{ TRUE, 5,0,0,0, menu_fn, (void *)  &m[1], Wf_DEFAULT, NULL },	
      	{ TRUE, 5,0,0,0, menu_fn, (void *)  &m[2], Wf_DEFAULT, NULL },			
      	{ TRUE, 5,0,0,0, button_fn, (void *) &def_button[_BUTT_QUIT], Wf_DEFAULT, ACA_TD },
      	W_NULL
      };
      SessW	s;

      setlocale(LC_MESSAGES, "");
   
      init_aca(TRUE);
      examples_colors();
      init_keys((aca_INI *) NULL);
      aca.extra_resize		= TRUE;
      aca.extra_resize_call_fn 	= spec_resize;
      aca.extra_resize_data	= (void *) &s;
   
      init_sessw(&s, 0, FALSE, w, bgr_examp, 0);
      spec_resize((void *) &s);
      *buff = 0;
   
      do {
         if (s.key == K_SCREEN_RESIZED) continue;
         re = 0;
         re = run_act_widget(&s);
      
         if (re & Wr_BUTTON_PRESS) 
            exit(RE_OK);
         if (re & Wr_MENU_PRESS)
            sprintf(buff, "PRESS: %s item: %d", astr2str(buff2, m[s.actual].astr), 
               m[s.actual].item_act +1); 	
      
         W_default_go(&s);
         W_key_to_widgets(&s);		
         if (re & Wr_NEED_REDRAW) 
            W_redraw_session(&s);
         clean_hline(LINES-2, 0, COLS, WHITE_RED);
         if (*buff) 
            center_addnstr(LINES-2, COLS/2, buff, strlen(buff));
      } while((s.key = get_k()) != KEY_F(10));  		
      exit(RE_OK);							
   }